/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.effects;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Set;
import railcraft.common.util.effects.IEffectManager;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.PacketEffect;
import railcraft.common.util.sounds.SoundHelper;

public class CommonProxy
implements IEffectManager {
    protected static final Random rand = new Random();

    @Override
    public void teleportEffect(lq entity, double destX, double destY, double destZ) {
        if (Game.isNotHost(entity.p)) {
            return;
        }
        try {
            PacketEffect pkt = new PacketEffect(PacketEffect.Effect.TELEPORT);
            DataOutputStream data = pkt.getOutputStream();
            data.writeDouble(entity.t);
            data.writeDouble(entity.u);
            data.writeDouble(entity.v);
            data.writeDouble(destX);
            data.writeDouble(destY);
            data.writeDouble(destZ);
            pkt.sendPacket(entity.p, entity.t, entity.u, entity.v);
        }
        catch (IOException ex) {
            // empty catch block
        }
        SoundHelper.playSoundAtEntity(entity, "mob.endermen.portal", 0.25f, 1.0f);
    }

    @Override
    public boolean isAnchorAuraActive() {
        return false;
    }

    @Override
    public boolean isTuningAuraActive() {
        return false;
    }

    @Override
    public void tuningEffect(any start, any dest) {
    }

    @Override
    public void chunkLoaderEffect(yc world, Object source, Set chunks) {
    }

    @Override
    public void handleEffectPacket(DataInputStream data) throws IOException {
    }

    protected void spawnParticle(azq particle) {
    }

    @Override
    public void steamEffect(yc world, Object source, double yOffset) {
    }
}

