/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.inventory;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import railcraft.common.blocks.RailcraftTileEntity;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.inventory.InvTools;

public class StandaloneInventory
implements la,
Iterable {
    private Callback callback;
    private final String name;
    private ur[] contents;

    public StandaloneInventory(int size, String name, la callback) {
        this.name = name;
        this.contents = new ur[size];
        this.callback = callback == null ? null : new InventoryCallback(callback);
    }

    public StandaloneInventory(int size, String name, RailcraftTileEntity callback) {
        this.name = name;
        this.contents = new ur[size];
        this.callback = callback == null ? null : new TileCallback(callback);
    }

    public StandaloneInventory(int size, la callback) {
        this(size, null, callback);
    }

    public StandaloneInventory(int size, RailcraftTileEntity callback) {
        this(size, null, callback);
    }

    public StandaloneInventory(int size, String name) {
        this(size, name, (RailcraftTileEntity)null);
    }

    public StandaloneInventory(int size) {
        this(size, null, (RailcraftTileEntity)null);
    }

    public int k_() {
        return this.contents.length;
    }

    public ur a(int i) {
        return this.contents[i];
    }

    public ur a(int i, int j) {
        if (this.contents[i] != null) {
            if (this.contents[i].a <= j) {
                ur itemstack = this.contents[i];
                this.contents[i] = null;
                this.d();
                return itemstack;
            }
            ur itemstack1 = this.contents[i].a(j);
            if (this.contents[i].a <= 0) {
                this.contents[i] = null;
            }
            this.d();
            return itemstack1;
        }
        return null;
    }

    public void a(int i, ur itemstack) {
        this.contents[i] = itemstack;
        if (itemstack != null && itemstack.a > this.c()) {
            itemstack.a = this.c();
        }
        this.d();
    }

    public String b() {
        if (this.name != null) {
            return RailcraftLanguage.translate(this.name);
        }
        if (this.callback != null) {
            return this.callback.getInvName();
        }
        return this.invTypeName();
    }

    protected String invTypeName() {
        return "Standalone";
    }

    public int c() {
        return 64;
    }

    public void d() {
        if (this.callback != null) {
            this.callback.onInventoryChanged();
        }
    }

    public boolean a_(qx entityplayer) {
        if (this.callback != null) {
            return this.callback.isUseableByPlayer(entityplayer);
        }
        return true;
    }

    public void l_() {
        if (this.callback != null) {
            this.callback.openChest();
        }
    }

    public void f() {
        if (this.callback != null) {
            this.callback.closeChest();
        }
    }

    public ur a_(int slot) {
        return null;
    }

    public ur[] getContents() {
        return this.contents;
    }

    public void writeToNBT(String tag, bq data) {
        InvTools.writeInvToNBT(this, tag, data);
    }

    public void readFromNBT(String tag, bq data) {
        InvTools.readInvFromNBT(this, tag, data);
    }

    public Iterator iterator() {
        return Iterators.forArray((Object[])this.contents);
    }

    private class TileCallback
    extends Callback {
        private RailcraftTileEntity inv;

        public TileCallback(RailcraftTileEntity inv) {
            this.inv = inv;
        }

        @Override
        public void onInventoryChanged() {
            this.inv.d();
        }

        @Override
        public String getInvName() {
            return this.inv.b();
        }
    }

    private class InventoryCallback
    extends Callback {
        private la inv;

        public InventoryCallback(la inv) {
            this.inv = inv;
        }

        @Override
        public boolean isUseableByPlayer(qx entityplayer) {
            return this.inv.a_(entityplayer);
        }

        @Override
        public void openChest() {
            this.inv.l_();
        }

        @Override
        public void closeChest() {
            this.inv.f();
        }

        @Override
        public void onInventoryChanged() {
            this.inv.d();
        }

        @Override
        public String getInvName() {
            return this.inv.b();
        }
    }

    private abstract class Callback {
        private Callback() {
        }

        public boolean isUseableByPlayer(qx entityplayer) {
            return true;
        }

        public void openChest() {
        }

        public void closeChest() {
        }

        public abstract void onInventoryChanged();

        public abstract String getInvName();
    }
}

