/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import railcraft.common.api.signals.AbstractPair;
import railcraft.common.api.signals.ISignalPacketBuilder;
import railcraft.common.blocks.RailcraftTileEntity;
import railcraft.common.util.network.IGuiReturnHandler;
import railcraft.common.util.network.PacketGuiReturn;
import railcraft.common.util.network.PacketPairRequest;
import railcraft.common.util.network.PacketPairUpdate;
import railcraft.common.util.network.PacketTileEntity;

public class PacketBuilder
implements ISignalPacketBuilder {
    private static PacketBuilder instance;

    public static PacketBuilder getInstance() {
        if (instance == null) {
            instance = new PacketBuilder();
        }
        return instance;
    }

    private PacketBuilder() {
    }

    public void sendTileEntityPacket(RailcraftTileEntity tile) {
        in world;
        il playerInstance;
        if (tile.k instanceof in && (playerInstance = (world = (in)tile.k).r().a(tile.l >> 4, tile.n >> 4, false)) != null) {
            PacketTileEntity pkt = new PacketTileEntity(tile);
            playerInstance.a(pkt.getPacket());
        }
    }

    @Override
    public void sendPairPacketUpdate(AbstractPair pairing) {
        PacketPairUpdate pkt = new PacketPairUpdate(pairing);
        PacketDispatcher.sendPacketToAllInDimension((ef)pkt.getPacket(), (int)pairing.getTile().k.u.h);
    }

    @Override
    public void sendPairPacketRequest(AbstractPair pairing) {
        PacketPairRequest pkt = new PacketPairRequest(pairing);
        PacketDispatcher.sendPacketToServer((ef)pkt.getPacket());
    }

    public void sendGuiReturnPacket(IGuiReturnHandler handler) {
        PacketGuiReturn pkt = new PacketGuiReturn(handler);
        PacketDispatcher.sendPacketToServer((ef)pkt.getPacket());
    }
}

