/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.network;

import cpw.mods.fml.common.network.PacketDispatcher;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.util.effects.EffectManager;
import railcraft.common.util.network.RailcraftPacket;

public class PacketEffect
extends RailcraftPacket {
    private Effect effect;
    private ByteArrayOutputStream bytes;
    private DataOutputStream outStream;

    public PacketEffect() {
    }

    public PacketEffect(Effect effect) {
        this.effect = effect;
    }

    public DataOutputStream getOutputStream() {
        if (this.outStream == null) {
            this.bytes = new ByteArrayOutputStream();
            this.outStream = new DataOutputStream(this.bytes);
        }
        return this.outStream;
    }

    public void sendPacket(yc world, double x, double y, double z) {
        PacketDispatcher.sendPacketToAllAround((double)x, (double)y, (double)z, (double)80.0, (int)world.u.h, (ef)this.getPacket());
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeByte(this.effect.ordinal());
        data.write(this.bytes.toByteArray());
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        EffectManager.instance.handleEffectPacket(data);
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.EFFECT.ordinal();
    }

    public static enum Effect {
        TELEPORT;

    }
}

