/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.api;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.List;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.LiquidFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.Util;

public class LiquidSlot
implements Slot {
    private int x;
    private int y;
    private int width = 16;
    private int height = 16;
    private SlotType slotType = SlotType.INPUT_SLOT;
    private static NamedTexture containerTexture = null;

    public LiquidSlot(int x, int y) {
        this.x = x;
        this.y = y;
        if (containerTexture == null) {
            containerTexture = Util.instance.getTexture("liquidFilterContainer");
        }
    }

    @Override
    public void draw(Renderer renderer, int recipeX, int recipeY, Object[] data, int dataIndex, boolean isMouseOver) {
        int x = recipeX + this.x;
        int y = recipeY + this.y;
        if (data[dataIndex] instanceof LiquidStack) {
            LiquidStack liquid = (LiquidStack)data[dataIndex];
            bba renderEngine = FMLClientHandler.instance().getClient().o;
            if (liquid.itemID < amq.p.length && amq.p[liquid.itemID] != null) {
                amq block = amq.p[liquid.itemID];
                int index = block.cl;
                int texture = renderEngine.b(block.getTextureFile());
                GL11.glBindTexture((int)3553, (int)texture);
                LiquidSlot.rect(x + 3, y + 1, 10, 14, (index & 0xF) * 16 + 3, (index & 0xF0) + 1);
            } else if (up.e[liquid.itemID] != null) {
                up item = up.e[liquid.itemID];
                int index = item.b(liquid.itemMeta);
                int texture = renderEngine.b(item.getTextureFile());
                GL11.glBindTexture((int)3553, (int)texture);
                LiquidSlot.rect(x + 3, y + 1, 10, 14, (index & 0xF) * 16 + 3, (index & 0xF0) + 1);
            }
        }
        renderer.renderRect(x - 1, y - 1, 18, 18, containerTexture);
    }

    @Override
    public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
        if (data[dataIndex] instanceof LiquidStack) {
            return new LiquidFilter((LiquidStack)data[dataIndex]);
        }
        return null;
    }

    @Override
    public boolean isPointInBounds(int x, int y, Object[] data, int dataIndex) {
        return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
    }

    @Override
    public List getTooltip(int x, int y, Object[] data, int dataIndex) {
        List tooltip = null;
        if (data[dataIndex] instanceof LiquidStack) {
            LiquidStack stack = (LiquidStack)data[dataIndex];
            tooltip = Util.instance.getItemStackText(stack.asItemStack());
            tooltip.set(0, (String)tooltip.get(0) + " (" + stack.amount + " milliBuckets)");
        }
        return tooltip;
    }

    @Override
    public boolean matches(ItemFilter filter, Object[] data, int dataIndex, SlotType type) {
        if (!(data[dataIndex] instanceof LiquidStack) || type != this.slotType && (type != SlotType.ANY_SLOT || this.slotType == SlotType.DISPLAY_SLOT || this.slotType == SlotType.HIDDEN_SLOT)) {
            return false;
        }
        LiquidStack stack = (LiquidStack)data[dataIndex];
        if (filter.matches(stack)) {
            return true;
        }
        for (LiquidContainerData liquidData : LiquidContainerRegistry.getRegisteredLiquidContainerData()) {
            if (!stack.isLiquidEqual(liquidData.stillLiquid) || !filter.matches(liquidData.filled)) continue;
            return true;
        }
        return filter.matches(stack.asItemStack());
    }

    private static void rect(int x, int y, int width, int height, int texX, int texY) {
        double u = (double)texX / 256.0;
        double v = (double)texY / 256.0;
        double u2 = (double)(texX + width) / 256.0;
        double v2 = (double)(texY + height) / 256.0;
        GL11.glEnable((int)3553);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glTexCoord2d((double)u, (double)v2);
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glTexCoord2d((double)u2, (double)v2);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glTexCoord2d((double)u2, (double)v);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glEnd();
    }

    public Slot setSlotType(SlotType type) {
        this.slotType = type;
        return this;
    }
}

