/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.ASMDev;
import codechicken.core.asm.CodeChickenAccessTransformer;
import codechicken.core.asm.DelegatedTransformer;
import codechicken.core.asm.ObfuscationMappings;
import codechicken.core.asm.TweakTransformer;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import cpw.mods.fml.relauncher.RelaunchClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

@IFMLLoadingPlugin.TransformerExclusions(value={"codechicken.core.asm"})
public class CodeChickenCorePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static RelaunchClassLoader cl;
    public static File minecraftDir;

    public String[] getLibraryRequestClass() {
        return null;
    }

    public String[] getASMTransformerClass() {
        return new String[]{"codechicken.core.asm.ClassHeirachyManager", "codechicken.core.asm.CodeChickenAccessTransformer", "codechicken.core.asm.InterfaceDependancyTransformer", "codechicken.core.asm.TweakTransformer", "codechicken.core.asm.FeatureHackTransformer", "codechicken.core.asm.DelegatedTransformer"};
    }

    public String getModContainerClass() {
        return "codechicken.core.asm.CodeChickenCoreModContainer";
    }

    public String getSetupClass() {
        return "codechicken.core.asm.CodeChickenCorePlugin";
    }

    public void injectData(Map data) {
        cl = (RelaunchClassLoader)data.get("classLoader");
        if (data.containsKey("mcLocation")) {
            minecraftDir = (File)data.get("mcLocation");
        }
    }

    public Void call() throws Exception {
        CodeChickenAccessTransformer.addTransformerMap("codechickencore_at.cfg");
        TweakTransformer.load();
        this.scanCodeChickenMods();
        if (!ObfuscationMappings.obfuscated) {
            ASMDev.print();
        }
        return null;
    }

    private void scanCodeChickenMods() {
        File modsDir = new File(minecraftDir, "mods");
        if (!modsDir.exists()) {
            return;
        }
        File[] fileArray = modsDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".jar");
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                JarFile jar = new JarFile(file);
                try {
                    Attributes attr;
                    Manifest manifest = jar.getManifest();
                    if (manifest != null && (attr = manifest.getMainAttributes()) != null) {
                        String transformer;
                        String mapFile = attr.getValue("AccessTransformer");
                        if (mapFile != null && ObfuscationMappings.obfuscated) {
                            File temp = this.extractTemp(jar, mapFile);
                            System.out.println("Adding AccessTransformer: " + mapFile);
                            CodeChickenAccessTransformer.addTransformerMap(temp.getPath());
                            temp.delete();
                        }
                        if ((transformer = attr.getValue("CCTransformer")) != null) {
                            System.out.println("Adding CCTransformer: " + transformer);
                            DelegatedTransformer.addTransformer(transformer, jar, file);
                        }
                    }
                }
                finally {
                    jar.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("CodeChickenCore: Failed to read jar file: " + file.getName());
            }
            ++n2;
        }
    }

    private File extractTemp(JarFile jar, String mapFile) throws IOException {
        File temp = new File("temp.dat");
        if (!temp.exists()) {
            temp.createNewFile();
        }
        FileOutputStream fout = new FileOutputStream(temp);
        byte[] data = new byte[4096];
        int read = 0;
        InputStream fin = jar.getInputStream(jar.getEntry(mapFile));
        while ((read = fin.read(data)) > 0) {
            fout.write(data, 0, read);
        }
        fin.close();
        fout.close();
        return temp;
    }
}

