/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.data;

import codechicken.core.data.MCDataInput;
import codechicken.core.data.MCDataOutput;
import codechicken.core.vec.BlockCoord;
import net.minecraftforge.liquids.LiquidStack;

public class NBTDataWrapper
implements MCDataInput,
MCDataOutput {
    private by readList;
    private int readTag = 0;
    private by writeList;

    public NBTDataWrapper(by input) {
        this.readList = input;
    }

    public NBTDataWrapper() {
        this.writeList = new by();
    }

    public by toTag() {
        return this.writeList;
    }

    @Override
    public void writeLong(long l) {
        this.writeList.a((cd)new bz(null, l));
    }

    @Override
    public void writeInt(int i) {
        this.writeList.a((cd)new bx(null, i));
    }

    @Override
    public void writeShort(int s) {
        this.writeList.a((cd)new cb(null, (short)s));
    }

    @Override
    public void writeByte(int b) {
        this.writeList.a((cd)new bp(null, (byte)b));
    }

    @Override
    public void writeDouble(double d) {
        this.writeList.a((cd)new bt(null, d));
    }

    @Override
    public void writeFloat(float f) {
        this.writeList.a((cd)new bv(null, f));
    }

    @Override
    public void writeBoolean(boolean b) {
        this.writeList.a((cd)new bp(null, (byte)(b ? 1 : 0)));
    }

    @Override
    public void writeChar(char c) {
        this.writeList.a((cd)new cb(null, (short)c));
    }

    @Override
    public void writeByteArray(byte[] array) {
        this.writeList.a((cd)new bo(null, array));
    }

    @Override
    public void writeString(String s) {
        this.writeList.a((cd)new cc(null, s));
    }

    @Override
    public void writeCoord(int x2, int y2, int z2) {
        this.writeInt(x2);
        this.writeInt(y2);
        this.writeInt(z2);
    }

    @Override
    public void writeCoord(BlockCoord coord) {
        this.writeCoord(coord.x, coord.y, coord.z);
    }

    @Override
    public void writeNBTTagCompound(bq tag) {
        this.writeList.a((cd)tag);
    }

    @Override
    public void writeItemStack(ur stack) {
        this.writeList.a((cd)stack.b(new bq()));
    }

    @Override
    public void writeLiquidStack(LiquidStack liquid) {
        this.writeList.a((cd)liquid.writeToNBT(new bq()));
    }

    @Override
    public long readLong() {
        return ((bz)this.readTag()).a;
    }

    @Override
    public int readInt() {
        return ((bx)this.readTag()).a;
    }

    @Override
    public short readShort() {
        return ((cb)this.readTag()).a;
    }

    @Override
    public int readUnsignedShort() {
        return ((cb)this.readTag()).a & 0xFFFF;
    }

    @Override
    public byte readByte() {
        return ((bp)this.readTag()).a;
    }

    @Override
    public int readUnsignedByte() {
        return ((bp)this.readTag()).a & 0xFF;
    }

    @Override
    public double readDouble() {
        return ((bt)this.readTag()).a;
    }

    @Override
    public float readFloat() {
        return ((bv)this.readTag()).a;
    }

    @Override
    public boolean readBoolean() {
        return ((bp)this.readTag()).a != 0;
    }

    @Override
    public char readChar() {
        return (char)((cb)this.readTag()).a;
    }

    @Override
    public byte[] readByteArray(int length) {
        return ((bo)this.readTag()).a;
    }

    @Override
    public String readString() {
        return ((cc)this.readTag()).a;
    }

    @Override
    public BlockCoord readCoord() {
        return new BlockCoord(this.readInt(), this.readInt(), this.readInt());
    }

    @Override
    public bq readNBTTagCompound() {
        return (bq)this.readTag();
    }

    @Override
    public ur readItemStack() {
        return ur.a((bq)this.readNBTTagCompound());
    }

    @Override
    public LiquidStack readLiquidStack() {
        return LiquidStack.loadLiquidStackFromNBT((bq)this.readNBTTagCompound());
    }

    private cd readTag() {
        return this.readList.b(this.readTag++);
    }
}

