/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.raytracer;

import codechicken.core.vec.Cuboid6;
import codechicken.core.vec.Quat;
import codechicken.core.vec.Vector3;

public class SelectionBox {
    private Vector3[] corners = new Vector3[8];
    private static Quat[] h_quats = new Quat[]{Quat.aroundAxis(new Vector3(0.0, 1.0, 0.0), 0.0), Quat.aroundAxis(new Vector3(0.0, 1.0, 0.0), -1.5707963267948966), Quat.aroundAxis(new Vector3(0.0, 1.0, 0.0), Math.PI), Quat.aroundAxis(new Vector3(0.0, 1.0, 0.0), 1.5707963267948966)};

    private SelectionBox() {
    }

    public SelectionBox(Cuboid6 bound) {
        Vector3 min = bound.min;
        Vector3 max = bound.max;
        this.corners[0] = new Vector3(min.x, min.y, min.z);
        this.corners[1] = new Vector3(min.x, min.y, max.z);
        this.corners[2] = new Vector3(min.x, max.y, min.z);
        this.corners[3] = new Vector3(min.x, max.y, max.z);
        this.corners[4] = new Vector3(max.x, min.y, min.z);
        this.corners[5] = new Vector3(max.x, min.y, max.z);
        this.corners[6] = new Vector3(max.x, max.y, min.z);
        this.corners[7] = new Vector3(max.x, max.y, max.z);
    }

    public SelectionBox rotateH(int rotation) {
        return this.rotate(h_quats[(rotation + 2) % 4], new Vector3(0.5, 0.0, 0.5));
    }

    public Cuboid6 bound() {
        Vector3 min = new Vector3(this.corners[0]);
        Vector3 max = new Vector3(this.corners[0]);
        Vector3[] vector3Array = this.corners;
        int n = this.corners.length;
        int n2 = 0;
        while (n2 < n) {
            Vector3 vec = vector3Array[n2];
            if (vec.x > max.x) {
                max.x = vec.x;
            }
            if (vec.y > max.y) {
                max.y = vec.y;
            }
            if (vec.z > max.z) {
                max.z = vec.z;
            }
            if (vec.x < min.x) {
                min.x = vec.x;
            }
            if (vec.y < min.y) {
                min.y = vec.y;
            }
            if (vec.z < min.z) {
                min.z = vec.z;
            }
            ++n2;
        }
        return new Cuboid6(min, max);
    }

    public SelectionBox copy() {
        SelectionBox copy = new SelectionBox();
        int i = 0;
        while (i < 8) {
            copy.corners[i] = this.corners[i].copy();
            ++i;
        }
        return copy;
    }

    public SelectionBox rotate(Quat quat) {
        return this.rotate(quat, new Vector3());
    }

    public SelectionBox rotate(Quat quat, Vector3 point) {
        boolean translate = !point.isZero();
        int k = 0;
        while (k < this.corners.length) {
            if (translate) {
                this.corners[k].subtract(point).rotate(quat).add(point);
            } else {
                this.corners[k].rotate(quat);
            }
            ++k;
        }
        return this;
    }

    public SelectionBox scale(double f) {
        return this.scale(new Vector3(f, f, f), new Vector3());
    }

    public SelectionBox scale(double f, Vector3 point) {
        return this.scale(new Vector3(f, f, f), point);
    }

    public SelectionBox scale(Vector3 f) {
        return this.scale(f, new Vector3());
    }

    public SelectionBox scale(Vector3 f, Vector3 point) {
        boolean translate = !point.isZero();
        int k = 0;
        while (k < this.corners.length) {
            if (translate) {
                this.corners[k].subtract(point).multiply(f).add(point);
            } else {
                this.corners[k].multiply(f);
            }
            ++k;
        }
        return this;
    }

    public SelectionBox translate(Vector3 offset) {
        int k = 0;
        while (k < this.corners.length) {
            this.corners[k].add(offset);
            ++k;
        }
        return this;
    }
}

