/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.core.ContainerIC2;
import ic2.core.IHasGui;
import ic2.core.block.machine.ContainerIronFurnace;
import ic2.core.block.machine.tileentity.TileEntityMachine;
import ic2.core.item.ItemFuelCanFilled;
import ic2.core.util.StackUtil;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class TileEntityIronFurnace
extends TileEntityMachine
implements IHasGui,
ISidedInventory {
    public int fuel = 0;
    public int maxFuel = 0;
    public short progress = 0;
    public final short operationLength = (short)160;

    public TileEntityIronFurnace() {
        super(3);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        try {
            this.fuel = nbttagcompound.e("fuel");
        }
        catch (Throwable e) {
            this.fuel = nbttagcompound.d("fuel");
        }
        try {
            this.maxFuel = nbttagcompound.e("maxFuel");
        }
        catch (Throwable e) {
            this.maxFuel = nbttagcompound.d("maxFuel");
        }
        this.progress = nbttagcompound.d("progress");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("fuel", this.fuel);
        nbttagcompound.a("maxFuel", this.maxFuel);
        nbttagcompound.a("progress", this.progress);
    }

    public int gaugeProgressScaled(int i) {
        return this.progress * i / 160;
    }

    public int gaugeFuelScaled(int i) {
        if (this.maxFuel == 0) {
            this.maxFuel = this.fuel;
            if (this.maxFuel == 0) {
                this.maxFuel = 160;
            }
        }
        return this.fuel * i / this.maxFuel;
    }

    @Override
    public void g() {
        super.g();
        boolean wasOperating = this.isBurning();
        boolean needsInvUpdate = false;
        if (this.fuel <= 0 && this.canOperate()) {
            this.fuel = this.maxFuel = TileEntityIronFurnace.getFuelValueFor(this.inventory[1]);
            if (this.fuel > 0) {
                if (this.inventory[1].b().s()) {
                    this.inventory[1] = this.inventory[1].b().getContainerItemStack(this.inventory[1]);
                } else {
                    --this.inventory[1].a;
                }
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
                needsInvUpdate = true;
            }
        }
        if (this.isBurning() && this.canOperate()) {
            this.progress = (short)(this.progress + 1);
            if (this.progress >= 160) {
                this.progress = 0;
                this.operate();
                needsInvUpdate = true;
            }
        } else {
            this.progress = 0;
        }
        if (this.fuel > 0) {
            --this.fuel;
        }
        if (wasOperating != this.isBurning()) {
            this.setActive(this.isBurning());
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.d();
        }
    }

    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        ur itemstack = this.getResultFor(this.inventory[0]);
        if (this.inventory[2] == null) {
            this.inventory[2] = itemstack.l();
        } else {
            this.inventory[2].a += itemstack.a;
        }
        if (this.inventory[0].b().s()) {
            this.inventory[0] = this.inventory[0].b().getContainerItemStack(this.inventory[0]);
        } else {
            --this.inventory[0].a;
        }
        if (this.inventory[0].a <= 0) {
            this.inventory[0] = null;
        }
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ur itemstack = this.getResultFor(this.inventory[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].a(itemstack)) {
            return false;
        }
        return this.inventory[2].a + itemstack.a <= this.inventory[2].d();
    }

    public static int getFuelValueFor(ur itemstack) {
        if (itemstack == null) {
            return 0;
        }
        int itemIndex = itemstack.b().cj;
        LiquidStack liquid = LiquidContainerRegistry.getLiquidForFilledItem((ur)itemstack);
        if (liquid != null && liquid.itemID == amq.G.cm) {
            return 2000;
        }
        if (itemstack.b() instanceof ItemFuelCanFilled) {
            bq data = StackUtil.getOrCreateNbtData(itemstack);
            if (itemstack.j() > 0) {
                data.a("value", itemstack.j());
            }
            return data.e("value") * 2;
        }
        return anr.a((ur)itemstack);
    }

    public ur getResultFor(ur itemstack) {
        return wj.a().getSmeltingResult(itemstack);
    }

    @Override
    public String b() {
        return "Iron Furnace";
    }

    @Override
    public ContainerIC2 getGuiContainer(qx entityPlayer) {
        return new ContainerIronFurnace(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(qx entityPlayer) {
        return "block.machine.gui.GuiIronFurnace";
    }

    @Override
    public void onGuiClosed(qx entityPlayer) {
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 1;
            }
            case UP: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

