/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.Ic2Items;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.TileEntityLuminator;
import java.util.List;
import java.util.Vector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileEntityCable
extends TileEntityBlock
implements IEnergyConductor,
INetworkTileEntityEventListener {
    public short cableType = 0;
    public short color = 0;
    public byte foamed = 0;
    public byte foamColor = 0;
    private byte prevFoamed = 0;
    public boolean addedToEnergyNet = false;
    private ITickCallback continuousTickCallback = null;
    private static final int EventRemoveConductor = 0;

    public TileEntityCable(short type) {
        this.cableType = type;
    }

    public TileEntityCable() {
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.cableType = nbttagcompound.d("cableType");
        this.color = nbttagcompound.d("color");
        this.foamColor = nbttagcompound.c("foamColor");
        this.foamed = nbttagcompound.c("foamed");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("cableType", this.cableType);
        nbttagcompound.a("color", this.color);
        nbttagcompound.a("foamed", this.foamed);
        nbttagcompound.a("foamColor", this.foamColor);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            if (this.foamed == 1) {
                this.changeFoam(this.foamed, true);
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        if (this.continuousTickCallback != null) {
            IC2.removeContinuousTickCallback(this.k, this.continuousTickCallback);
            this.continuousTickCallback = null;
        }
        super.onUnloaded();
    }

    public boolean shouldRefresh(int oldID, int newID, int oldMeta, int newMeta, yc world, int x, int y, int z) {
        return oldID != newID;
    }

    public boolean changeColor(int newColor) {
        if (this.foamed == 0 && (this.color == newColor || this.cableType == 1 || this.cableType == 2 || this.cableType == 5 || this.cableType == 10 || this.cableType == 11 || this.cableType == 12) || this.foamed > 0 && this.foamColor == newColor) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            if (this.foamed == 0) {
                if (this.addedToEnergyNet) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
                }
                this.addedToEnergyNet = false;
                this.color = (short)newColor;
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                this.addedToEnergyNet = true;
                IC2.network.updateTileEntityField(this, "color");
            } else {
                this.foamColor = (byte)newColor;
                IC2.network.updateTileEntityField(this, "foamColor");
            }
        }
        return true;
    }

    public boolean changeFoam(byte foamed) {
        return this.changeFoam(foamed, false);
    }

    public boolean tryAddInsulation() {
        short target;
        switch (this.cableType) {
            case 1: {
                target = 0;
                break;
            }
            case 2: {
                target = 3;
                break;
            }
            case 3: {
                target = 4;
                break;
            }
            case 5: {
                target = 6;
                break;
            }
            case 6: {
                target = 7;
                break;
            }
            case 7: {
                target = 8;
                break;
            }
            default: {
                target = this.cableType;
            }
        }
        if (target != this.cableType) {
            if (IC2.platform.isSimulating()) {
                this.changeType(target);
            }
            return true;
        }
        return false;
    }

    public boolean tryRemoveInsulation() {
        short target;
        switch (this.cableType) {
            case 0: {
                target = 1;
                break;
            }
            case 3: {
                target = 2;
                break;
            }
            case 4: {
                target = 3;
                break;
            }
            case 6: {
                target = 5;
                break;
            }
            case 7: {
                target = 6;
                break;
            }
            case 8: {
                target = 7;
                break;
            }
            default: {
                target = this.cableType;
            }
        }
        if (target != this.cableType) {
            if (IC2.platform.isSimulating()) {
                this.changeType(target);
            }
            return true;
        }
        return false;
    }

    public void changeType(short cableType) {
        this.k.d(this.l, this.m, this.n, (int)cableType);
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.cableType = cableType;
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
        IC2.network.updateTileEntityField(this, "cableType");
    }

    @Override
    public boolean wrenchCanSetFacing(qx entityPlayer, int side) {
        return false;
    }

    @Override
    public boolean wrenchCanRemove(qx entityPlayer) {
        return false;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return !(emitter instanceof TileEntityCable) || this.canInteractWithCable((TileEntityCable)emitter);
    }

    @Override
    public boolean emitsEnergyTo(any receiver, Direction direction) {
        if (receiver instanceof TileEntityCable && !this.canInteractWithCable((TileEntityCable)receiver)) {
            return false;
        }
        if (receiver instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)receiver).canCableConnectFrom(this.l, this.m, this.n);
        }
        return true;
    }

    public boolean canInteractWith(any te) {
        if (te instanceof TileEntityCable) {
            return this.canInteractWithCable((TileEntityCable)te);
        }
        if (te instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)te).canCableConnectFrom(this.l, this.m, this.n);
        }
        return te instanceof IEnergySink || te instanceof IEnergySource || te instanceof IEnergyConductor;
    }

    public boolean canInteractWithCable(TileEntityCable cable) {
        return this.color == 0 || cable.color == 0 || this.color == cable.color;
    }

    public float getCableThickness() {
        if (this.foamed == 2) {
            return 1.0f;
        }
        return TileEntityCable.getCableThickness(this.cableType);
    }

    public static float getCableThickness(int cableType) {
        float p = 1.0f;
        switch (cableType) {
            case 0: {
                p = 6.0f;
                break;
            }
            case 1: {
                p = 4.0f;
                break;
            }
            case 2: {
                p = 3.0f;
                break;
            }
            case 3: {
                p = 5.0f;
                break;
            }
            case 4: {
                p = 6.0f;
                break;
            }
            case 5: {
                p = 6.0f;
                break;
            }
            case 6: {
                p = 8.0f;
                break;
            }
            case 7: {
                p = 10.0f;
                break;
            }
            case 8: {
                p = 12.0f;
                break;
            }
            case 9: {
                p = 4.0f;
                break;
            }
            case 10: {
                p = 5.0f;
                break;
            }
            case 11: {
                p = 8.0f;
                break;
            }
            case 12: {
                p = 8.0f;
                break;
            }
            case 13: {
                p = 16.0f;
            }
        }
        return p / 16.0f;
    }

    @Override
    public double getConductionLoss() {
        switch (this.cableType) {
            case 0: {
                return 0.2;
            }
            case 1: {
                return 0.3;
            }
            case 2: {
                return 0.5;
            }
            case 3: {
                return 0.45;
            }
            case 4: {
                return 0.4;
            }
            case 5: {
                return 1.0;
            }
            case 6: {
                return 0.95;
            }
            case 7: {
                return 0.9;
            }
            case 8: {
                return 0.8;
            }
            case 9: {
                return 0.025;
            }
            case 10: {
                return 0.025;
            }
            case 11: {
                return 0.5;
            }
            case 12: {
                return 0.5;
            }
        }
        return 0.025;
    }

    @Override
    public int getInsulationEnergyAbsorption() {
        switch (this.cableType) {
            case 0: {
                return 32;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 128;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 128;
            }
            case 7: {
                return 512;
            }
            case 8: {
                return 9001;
            }
            case 9: {
                return 9001;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 9001;
            }
            case 12: {
                return 9001;
            }
        }
        return 0;
    }

    @Override
    public int getInsulationBreakdownEnergy() {
        return 9001;
    }

    @Override
    public int getConductorBreakdownEnergy() {
        switch (this.cableType) {
            case 0: {
                return 33;
            }
            case 1: {
                return 33;
            }
            case 2: {
                return 129;
            }
            case 3: {
                return 129;
            }
            case 4: {
                return 129;
            }
            case 5: {
                return 2049;
            }
            case 6: {
                return 2049;
            }
            case 7: {
                return 2049;
            }
            case 8: {
                return 2049;
            }
            case 9: {
                return 513;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 2049;
            }
            case 12: {
                return 2049;
            }
        }
        return 0;
    }

    @Override
    public void removeInsulation() {
    }

    @Override
    public void removeConductor() {
        this.k.e(this.l, this.m, this.n, 0);
        IC2.network.initiateTileEntityEvent(this, 0, true);
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>();
        ret.add("cableType");
        ret.add("color");
        ret.add("foamed");
        ret.add("foamColor");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("cableType") || field.equals("color") || field.equals("foamColor")) {
            this.k.i(this.l, this.m, this.n);
        } else if (field.equals("foamed") && this.prevFoamed != this.foamed) {
            if (this.foamed == 0 && this.prevFoamed != 1 || this.foamed == 2) {
                this.k.c(this.l, this.m, this.n, Ic2Items.insulatedCopperCableBlock.c, (this.cableType + 1) % 16);
                this.k.c(this.l, this.m, this.n, Ic2Items.insulatedCopperCableBlock.c, (int)this.cableType);
            } else {
                this.k.i(this.l, this.m, this.n);
            }
            this.prevFoamed = this.foamed;
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                this.k.a((double)((float)this.l + 0.5f), (double)((float)this.m + 0.5f), (double)((float)this.n + 0.5f), "random.fizz", 0.5f, 2.6f + (this.k.t.nextFloat() - this.k.t.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    this.k.a("largesmoke", (double)this.l + Math.random(), (double)this.m + 1.2, (double)this.n + Math.random(), 0.0, 0.0, 0.0);
                }
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.l + "," + this.m + "," + this.n + ")");
            }
        }
    }

    @Override
    public float getWrenchDropRate() {
        return 0.0f;
    }

    private boolean changeFoam(byte foamed, boolean duringLoad) {
        if (this.foamed == foamed && !duringLoad) {
            return false;
        }
        if (IC2.platform.isSimulating()) {
            byte prevFoamed = this.foamed;
            this.foamed = foamed;
            if (this.continuousTickCallback != null) {
                IC2.removeContinuousTickCallback(this.k, this.continuousTickCallback);
                this.continuousTickCallback = null;
            }
            if (foamed == 0 && prevFoamed != 1 || foamed == 2) {
                BlockCable blockCable = (BlockCable)amq.p[Ic2Items.insulatedCopperCableBlock.c];
                blockCable.enableBreakBlock = false;
                this.k.c(this.l, this.m, this.n, Ic2Items.insulatedCopperCableBlock.c, (this.cableType + 1) % 16);
                this.k.c(this.l, this.m, this.n, Ic2Items.insulatedCopperCableBlock.c, (int)this.cableType);
                blockCable.enableBreakBlock = true;
            } else if (foamed == 1) {
                this.foamColor = (byte)7;
                if (!duringLoad) {
                    IC2.network.updateTileEntityField(this, "foamColor");
                }
                this.continuousTickCallback = new ITickCallback(){

                    @Override
                    public void tickCallback(yc world) {
                        if (world.t.nextInt(500) == 0 && world.m(TileEntityCable.this.l, TileEntityCable.this.m, TileEntityCable.this.n) * 6 >= TileEntityCable.this.k.t.nextInt(1000)) {
                            TileEntityCable.this.changeFoam((byte)2);
                        }
                    }
                };
                IC2.addContinuousTickCallback(this.k, this.continuousTickCallback);
            }
            if (!duringLoad) {
                IC2.network.updateTileEntityField(this, "foamed");
            }
        }
        return true;
    }
}

