/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.IC2;
import ic2.core.block.TileEntityBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileEntityTransformer
extends TileEntityBlock
implements IEnergySink,
IEnergySource {
    public int lowOutput;
    public int highOutput;
    public int maxStorage;
    public int energy = 0;
    public boolean redstone = false;
    public boolean addedToEnergyNet = false;

    public TileEntityTransformer(int low, int high, int max) {
        this.lowOutput = low;
        this.highOutput = high;
        this.maxStorage = max;
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.energy = nbttagcompound.e("energy");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", this.energy);
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    public void g() {
        super.g();
        this.updateRedstone();
        if (this.redstone) {
            if (this.energy >= this.highOutput) {
                EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.highOutput);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.energy -= this.highOutput - event.amount;
            }
        } else {
            for (int i = 0; i < 4 && this.energy >= this.lowOutput; ++i) {
                EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.lowOutput);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.energy -= this.lowOutput - event.amount;
            }
        }
    }

    public void updateRedstone() {
        boolean red = this.k.B(this.l, this.m, this.n);
        if (red != this.redstone) {
            if (this.addedToEnergyNet) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.addedToEnergyNet = false;
            this.redstone = red;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            this.setActive(this.redstone);
        }
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.addedToEnergyNet;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        if (this.redstone) {
            return !this.facingMatchesDirection(direction);
        }
        return this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(any receiver, Direction direction) {
        if (this.redstone) {
            return this.facingMatchesDirection(direction);
        }
        return !this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(Direction direction) {
        return direction.toSideValue() == this.getFacing();
    }

    @Override
    public int getMaxEnergyOutput() {
        if (this.redstone) {
            return this.highOutput;
        }
        return this.lowOutput;
    }

    @Override
    public int demandsEnergy() {
        return this.maxStorage - this.energy;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (amount > this.getMaxSafeInput()) {
            IC2.explodeMachineAt(this.k, this.l, this.m, this.n);
            return 0;
        }
        int need = amount;
        if (this.energy + amount >= this.maxStorage + this.highOutput) {
            need = this.maxStorage + this.highOutput - this.energy - 1;
        }
        this.energy += need;
        return amount - need;
    }

    @Override
    public int getMaxSafeInput() {
        if (this.redstone) {
            return this.lowOutput;
        }
        if (this.highOutput != 2048) {
            return this.highOutput;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean wrenchCanSetFacing(qx entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short side) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        super.setFacing(side);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
    }
}

