/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.init;

import cpw.mods.fml.common.registry.LanguageRegistry;
import ic2.core.IC2;
import java.io.File;
import net.minecraftforge.common.Configuration;

public class Localization {
    private static Configuration lang;

    public static void init() {
        try {
            lang = new Configuration(new File(IC2.platform.getMinecraftDir(), "/config/IC2.lang"));
            lang.load();
        }
        catch (Exception e) {
            IC2.log.warning("Error while trying to access language file!");
            lang = null;
        }
        Localization.initBlocks();
        Localization.initItems();
        Localization.initAchievements();
        Localization.initMisc();
    }

    public static void addLocalization(String name, String desc) {
        if (lang != null) {
            desc = Localization.lang.get((String)"general", (String)name, (String)desc).value;
        }
        LanguageRegistry.instance().addStringLocalization(name, desc);
    }

    private static void initBlocks() {
        Localization.addLocalization("blockMachine.name", "Machine Block");
        Localization.addLocalization("blockIronFurnace.name", "Iron Furnace");
        Localization.addLocalization("blockElecFurnace.name", "Electric Furnace");
        Localization.addLocalization("blockMacerator.name", "Macerator");
        Localization.addLocalization("blockExtractor.name", "Extractor");
        Localization.addLocalization("blockCompressor.name", "Compressor");
        Localization.addLocalization("blockCanner.name", "Canning Machine");
        Localization.addLocalization("blockMiner.name", "Miner");
        Localization.addLocalization("blockPump.name", "Pump");
        Localization.addLocalization("blockMagnetizer.name", "Magnetizer");
        Localization.addLocalization("blockElectrolyzer.name", "Electrolyzer");
        Localization.addLocalization("blockRecycler.name", "Recycler");
        Localization.addLocalization("blockAdvMachine.name", "Advanced Machine Block");
        Localization.addLocalization("blockInduction.name", "Induction Furnace");
        Localization.addLocalization("blockMatter.name", "Mass Fabricator");
        Localization.addLocalization("blockTerra.name", "Terraformer");
        Localization.addLocalization("tile.blockOreCopper.name", "Copper Ore");
        Localization.addLocalization("tile.blockOreTin.name", "Tin Ore");
        Localization.addLocalization("tile.blockOreUran.name", "Uranium Ore");
        Localization.addLocalization("blockGenerator.name", "Generator");
        Localization.addLocalization("blockGeoGenerator.name", "Geothermal Generator");
        Localization.addLocalization("blockWaterGenerator.name", "Water Mill");
        Localization.addLocalization("blockSolarGenerator.name", "Solar Panel");
        Localization.addLocalization("blockWindGenerator.name", "Wind Mill");
        Localization.addLocalization("blockNuclearReactor.name", "Nuclear Reactor");
        Localization.addLocalization("tile.blockMiningPipe.name", "Mining Pipe");
        Localization.addLocalization("tile.blockMiningTip.name", "Mining Pipe");
        Localization.addLocalization("tile.blockRubWood.name", "Rubber Wood");
        Localization.addLocalization("tile.blockRubSapling.name", "Rubber Tree Sapling");
        Localization.addLocalization("tile.blockITNT.name", "Industrial TNT");
        Localization.addLocalization("tile.blockNuke.name", "Nuke");
        Localization.addLocalization("tile.blockRubber.name", "Rubber Sheet");
        Localization.addLocalization("tile.blockReactorChamber.name", "Reactor Chamber");
        Localization.addLocalization("tile.blockFenceIron.name", "Iron Fence");
        Localization.addLocalization("tile.blockAlloy.name", "Reinforced Stone");
        Localization.addLocalization("tile.blockAlloyGlass.name", "Reinforced Glass");
        Localization.addLocalization("blockBatBox.name", "BatBox");
        Localization.addLocalization("blockMFE.name", "MFE");
        Localization.addLocalization("blockMFSU.name", "MFSU");
        Localization.addLocalization("blockTransformerLV.name", "LV-Transformer");
        Localization.addLocalization("blockTransformerMV.name", "MV-Transformer");
        Localization.addLocalization("blockTransformerHV.name", "HV-Transformer");
        Localization.addLocalization("tile.blockLuminator.name", "Luminator");
        Localization.addLocalization("blockPersonalChest.name", "Personal Safe");
        Localization.addLocalization("blockPersonalTrader.name", "Trade-O-Mat");
        Localization.addLocalization("blockPersonalTraderEnergy.name", "Energy-O-Mat");
        Localization.addLocalization("blockMetalCopper.name", "Copper Block");
        Localization.addLocalization("blockMetalTin.name", "Tin Block");
        Localization.addLocalization("blockMetalBronze.name", "Bronze Block");
        Localization.addLocalization("blockMetalUranium.name", "Uranium Block");
        Localization.addLocalization("blockTeleporter.name", "Teleporter");
        Localization.addLocalization("blockTesla.name", "Tesla Coil");
        Localization.addLocalization("tile.blockFoam.name", "Construction Foam");
        Localization.addLocalization("tile.blockScaffold.name", "Scaffold");
        Localization.addLocalization("tile.blockLuminatorD.name", "Luminator");
        Localization.addLocalization("tile.blockCrop.name", "Crop");
        Localization.addLocalization("blockCropmatron.name", "Crop-Matron");
        Localization.addLocalization("tile.blockIronScaffold.name", "Iron Scaffold");
    }

    private static void initItems() {
        Localization.addLocalization("item.itemDustCoal.name", "Coal Dust");
        Localization.addLocalization("item.itemDustIron.name", "Iron Dust");
        Localization.addLocalization("item.itemDustGold.name", "Gold Dust");
        Localization.addLocalization("item.itemDustCopper.name", "Copper Dust");
        Localization.addLocalization("item.itemDustTin.name", "Tin Dust");
        Localization.addLocalization("item.itemDustBronze.name", "Bronze Dust");
        Localization.addLocalization("item.itemDustIronSmall.name", "Small Pile of Iron Dust");
        Localization.addLocalization("item.itemIngotAdvIron.name", "Refined Iron");
        Localization.addLocalization("item.itemIngotCopper.name", "Copper");
        Localization.addLocalization("item.itemIngotTin.name", "Tin");
        Localization.addLocalization("item.itemIngotBronze.name", "Bronze");
        Localization.addLocalization("item.itemIngotAlloy.name", "Mixed Metal Ingot");
        Localization.addLocalization("item.itemIngotUran.name", "Refined Uranium");
        Localization.addLocalization("item.itemOreUran.name", "Uranium Ore");
        Localization.addLocalization("item.itemBatRE.name", "RE-Battery");
        Localization.addLocalization("item.itemBatSU.name", "Single-Use Battery");
        Localization.addLocalization("item.itemBatCrystal.name", "Energy Crystal");
        Localization.addLocalization("item.itemBatLamaCrystal.name", "Lapotron Crystal");
        Localization.addLocalization("item.itemCellEmpty.name", "Empty Cell");
        Localization.addLocalization("item.itemCellLava.name", "Lava Cell");
        Localization.addLocalization("item.itemToolDrill.name", "Mining Drill");
        Localization.addLocalization("item.itemToolDDrill.name", "Diamond Drill");
        Localization.addLocalization("item.itemToolChainsaw.name", "Chainsaw");
        Localization.addLocalization("item.itemFuelCan.name", "Filled Fuel Can");
        Localization.addLocalization("item.itemFuelCanEmpty.name", "(Empty) Fuel Can");
        Localization.addLocalization("item.itemCellCoal.name", "H. Coal Cell");
        Localization.addLocalization("item.itemCellCoalRef.name", "Coalfuel Cell");
        Localization.addLocalization("item.itemCellBio.name", "Bio Cell");
        Localization.addLocalization("item.itemCellBioRef.name", "Biofuel Cell");
        Localization.addLocalization("item.itemFuelCoalDust.name", "Hydrated Coal Dust");
        Localization.addLocalization("item.itemFuelCoalCmpr.name", "H. Coal");
        Localization.addLocalization("item.itemFuelPlantBall.name", "Plantball");
        Localization.addLocalization("item.itemFuelPlantCmpr.name", "Compressed Plants");
        Localization.addLocalization("item.itemTinCan.name", "Tin Can");
        Localization.addLocalization("item.itemTinCanFilled.name", "(Filled) Tin Can");
        Localization.addLocalization("item.itemScanner.name", "OD Scanner");
        Localization.addLocalization("item.itemScannerAdv.name", "OV Scanner");
        Localization.addLocalization("item.itemCellWater.name", "Water Cell");
        Localization.addLocalization("item.itemHarz.name", "Sticky Resin");
        Localization.addLocalization("item.itemRubber.name", "Rubber");
        Localization.addLocalization("item.itemDynamite.name", "Dynamite");
        Localization.addLocalization("item.itemDynamiteSticky.name", "Sticky Dynamite");
        Localization.addLocalization("item.itemRemote.name", "Dynamite-O-Mote");
        Localization.addLocalization("item.itemTreetap.name", "Treetap");
        Localization.addLocalization("item.itemArmorJetpack.name", "Jetpack");
        Localization.addLocalization("item.itemArmorJetpackElectric.name", "Electric Jetpack");
        Localization.addLocalization("item.itemToolMiningLaser.name", "Mining Laser");
        Localization.addLocalization("item.itemToolBronzePickaxe.name", "Bronze Pickaxe");
        Localization.addLocalization("item.itemToolBronzeAxe.name", "Bronze Axe");
        Localization.addLocalization("item.itemToolBronzeSword.name", "Bronze Sword");
        Localization.addLocalization("item.itemToolBronzeSpade.name", "Bronze Shovel");
        Localization.addLocalization("item.itemToolBronzeHoe.name", "Bronze Hoe");
        Localization.addLocalization("item.itemArmorBronzeHelmet.name", "Bronze Helmet");
        Localization.addLocalization("item.itemArmorBronzeChestplate.name", "Bronze Chestplate");
        Localization.addLocalization("item.itemArmorBronzeLegs.name", "Bronze Leggings");
        Localization.addLocalization("item.itemArmorBronzeBoots.name", "Bronze Boots");
        Localization.addLocalization("item.itemPartCircuit.name", "Electronic Circuit");
        Localization.addLocalization("item.itemPartCircuitAdv.name", "Advanced Circuit");
        Localization.addLocalization("item.itemPartAlloy.name", "Advanced Alloy");
        Localization.addLocalization("item.itemScrap.name", "Scrap");
        Localization.addLocalization("item.itemMatter.name", "UU-Matter");
        Localization.addLocalization("item.itemCoin.name", "Industrial Credit");
        Localization.addLocalization("item.itemDoorAlloy.name", "Reinforced Door");
        Localization.addLocalization("itemCable.name", "Copper Cable");
        Localization.addLocalization("itemCableO.name", "Uninsulated Copper Cable");
        Localization.addLocalization("itemGoldCable.name", "Gold Cable");
        Localization.addLocalization("itemGoldCableI.name", "Insulated Gold Cable");
        Localization.addLocalization("itemGoldCableII.name", "2xIns. Gold Cable");
        Localization.addLocalization("itemIronCable.name", "HV Cable");
        Localization.addLocalization("itemIronCableI.name", "Insulated HV Cable");
        Localization.addLocalization("itemIronCableII.name", "2xIns. HV Cable");
        Localization.addLocalization("itemIronCableIIII.name", "4xIns. HV Cable");
        Localization.addLocalization("itemGlassCable.name", "Glass Fibre Cable");
        Localization.addLocalization("itemTinCable.name", "Ultra-Low-Current Cable");
        Localization.addLocalization("itemDetectorCable.name", "EU-Detector Cable");
        Localization.addLocalization("itemSplitterCable.name", "EU-Splitter Cable");
        Localization.addLocalization("item.itemToolWrench.name", "Wrench");
        Localization.addLocalization("item.itemToolMeter.name", "EU-Reader");
        Localization.addLocalization("item.itemCellWaterElectro.name", "Electrolyzed Water Cell");
        Localization.addLocalization("item.itemArmorBatpack.name", "BatPack");
        Localization.addLocalization("item.itemArmorAlloyChestplate.name", "Composite Vest");
        Localization.addLocalization("item.itemArmorNanoHelmet.name", "NanoSuit Helmet");
        Localization.addLocalization("item.itemArmorNanoChestplate.name", "NanoSuit Bodyarmor");
        Localization.addLocalization("item.itemArmorNanoLegs.name", "NanoSuit Leggings");
        Localization.addLocalization("item.itemArmorNanoBoots.name", "NanoSuit Boots");
        Localization.addLocalization("item.itemArmorQuantumHelmet.name", "QuantumSuit Helmet");
        Localization.addLocalization("item.itemArmorQuantumChestplate.name", "QuantumSuit Bodyarmor");
        Localization.addLocalization("item.itemArmorQuantumLegs.name", "QuantumSuit Leggings");
        Localization.addLocalization("item.itemArmorQuantumBoots.name", "QuantumSuit Boots");
        Localization.addLocalization("item.itemToolPainter.name", "Painter");
        Localization.addLocalization("item.itemToolCutter.name", "Insulation Cutter");
        Localization.addLocalization("item.itemPartCarbonFibre.name", "Raw Carbon Fibre");
        Localization.addLocalization("item.itemPartCarbonMesh.name", "Raw Carbon Mesh");
        Localization.addLocalization("item.itemPartCarbonPlate.name", "Carbon Plate");
        Localization.addLocalization("item.itemNanoSaber.name", "Nano Saber");
        Localization.addLocalization("item.itemPartIridium.name", "Iridium Plate");
        Localization.addLocalization("item.itemTFBP.name", "TFBP - Empty");
        Localization.addLocalization("item.itemTFBPCultivation.name", "TFBP - Cultivation");
        Localization.addLocalization("item.itemTFBPIrrigation.name", "TFBP - Irrigation");
        Localization.addLocalization("item.itemTFBPDesertification.name", "TFBP - Desertification");
        Localization.addLocalization("item.itemTFBPChilling.name", "TFBP - Chilling");
        Localization.addLocalization("item.itemTFBPFlatification.name", "TFBP - Flatification");
        Localization.addLocalization("item.itemTFBPMushroom.name", "TFBP - Mushroom");
        Localization.addLocalization("item.itemToolWrenchElectric.name", "Electric Wrench");
        Localization.addLocalization("item.itemTreetapElectric.name", "Electric Treetap");
        Localization.addLocalization("item.itemScrapbox.name", "Scrap Box");
        Localization.addLocalization("item.itemPartCoalBall.name", "Coal Ball");
        Localization.addLocalization("item.itemPartCoalBlock.name", "Compressed Coal Ball");
        Localization.addLocalization("item.itemPartCoalChunk.name", "Coal Chunk");
        Localization.addLocalization("item.itemPartIndustrialDiamond.name", "Industrial Diamond");
        Localization.addLocalization("item.itemFreq.name", "Frequency Transmitter");
        Localization.addLocalization("item.itemDustClay.name", "Clay Dust");
        Localization.addLocalization("item.itemPartPellet.name", "CF Pellet");
        Localization.addLocalization("item.itemFoamSprayer.name", "CF Sprayer");
        Localization.addLocalization("item.itemDustSilver.name", "Silver Dust");
        Localization.addLocalization("item.itemArmorCFPack.name", "CF Backpack");
        Localization.addLocalization("item.itemOreIridium.name", "Iridium Ore");
        Localization.addLocalization("item.itemArmorLappack.name", "Lappack");
        Localization.addLocalization("item.cropSeedUn.name", "Unknown Seeds");
        Localization.addLocalization("item.cropSeedInvalid.name", "Seed is missing data - bug?");
        Localization.addLocalization("item.itemCropnalyzer.name", "Cropnalyzer");
        Localization.addLocalization("item.itemFertilizer.name", "Fertilizer");
        Localization.addLocalization("item.itemCellHydrant.name", "Hydration Cell");
        Localization.addLocalization("item.itemToolHoe.name", "Electric Hoe");
        Localization.addLocalization("overclockerUpgrade.name", "Overclocker Upgrade");
        Localization.addLocalization("transformerUpgrade.name", "Transformer Upgrade");
        Localization.addLocalization("energyStorageUpgrade.name", "Energy Storage Upgrade");
        Localization.addLocalization("item.itemToolbox.name", "Tool Box");
        Localization.addLocalization("item.itemSolarHelmet.name", "Solar Helmet");
        Localization.addLocalization("item.itemStaticBoots.name", "Static Boots");
        Localization.addLocalization("item.itemTerraWart.name", "Terra Wart");
        Localization.addLocalization("item.itemCoffeeBeans.name", "Coffee Beans");
        Localization.addLocalization("item.itemCoffeePowder.name", "Coffee Powder");
        Localization.addLocalization("item.itemMugEmpty.name", "Stone Mug");
        Localization.addLocalization("item.itemMugCoffee0.name", "Cold Coffee");
        Localization.addLocalization("item.itemMugCoffee1.name", "Dark Coffee");
        Localization.addLocalization("item.itemMugCoffee2.name", "Coffee");
        Localization.addLocalization("item.itemHops.name", "Hops");
        Localization.addLocalization("item.itemGrinPowder.name", "Grin Powder");
        Localization.addLocalization("item.itemWeedEx.name", "Weed-EX");
        Localization.addLocalization("debugItem.name", "Debug Item");
        Localization.addLocalization("item.reactorUraniumSimple.name", "Uranium Cell");
        Localization.addLocalization("item.reactorUraniumDual.name", "Dual Uranium Cell");
        Localization.addLocalization("item.reactorUraniumQuad.name", "Quad Uranium Cell");
        Localization.addLocalization("item.reactorCoolantSimple.name", "10k Coolant Cell");
        Localization.addLocalization("item.reactorCoolantTriple.name", "30k Coolant Cell");
        Localization.addLocalization("item.reactorCoolantSix.name", "60k Coolant Cell");
        Localization.addLocalization("item.reactorPlating.name", "Reactor Plating");
        Localization.addLocalization("item.reactorPlatingHeat.name", "Heat-Capacity Reactor Plating");
        Localization.addLocalization("item.reactorPlatingExplosive.name", "Containment Reactor Plating");
        Localization.addLocalization("item.reactorHeatSwitch.name", "Heat Exchanger");
        Localization.addLocalization("item.reactorHeatSwitchCore.name", "Reactor Heat Exchanger");
        Localization.addLocalization("item.reactorHeatSwitchSpread.name", "Component Heat Exchanger");
        Localization.addLocalization("item.reactorHeatSwitchDiamond.name", "Advanced Heat Exchanger");
        Localization.addLocalization("item.reactorVent.name", "Heat Vent");
        Localization.addLocalization("item.reactorVentCore.name", "Reactor Heat Vent");
        Localization.addLocalization("item.reactorVentGold.name", "Overclocked Heat Vent");
        Localization.addLocalization("item.reactorVentSpread.name", "Component Heat Vent");
        Localization.addLocalization("item.reactorVentDiamond.name", "Advanced Heat Vent");
        Localization.addLocalization("item.reactorIsotopeCell.name", "Depleted Isotope Cell");
        Localization.addLocalization("item.itemCellUranEnriched.name", "Re-Enriched Uranium Cell");
        Localization.addLocalization("item.itemCellUranEmpty.name", "Near-depleted Uranium Cell");
        Localization.addLocalization("item.reactorHeatpack.name", "Heating Cell");
        Localization.addLocalization("item.reactorReflector.name", "Neutron Reflector");
        Localization.addLocalization("item.reactorReflectorThick.name", "Thick Neutron Reflector");
        Localization.addLocalization("item.reactorCondensator.name", "RSH-Condensator");
        Localization.addLocalization("item.itemPartDCP.name", "Dense Copper Plate");
        Localization.addLocalization("item.reactorCondensatorLap.name", "LZH-Condensator");
        Localization.addLocalization("item.itemArmorRubBoots.name", "Rubber Boots");
        Localization.addLocalization("item.itemArmorHazmatHelmet.name", "Scuba Helmet");
        Localization.addLocalization("item.itemArmorHazmatChestplate.name", "Hazmat Suit");
        Localization.addLocalization("item.itemArmorHazmatLeggings.name", "Hazmat Suit Leggings");
        Localization.addLocalization("item.itemCellAir.name", "Compressed Air Cell");
        Localization.addLocalization("item.itemNightvisionGoggles.name", "Nightvision Goggles");
        Localization.addLocalization("item.itemCoolant.name", "Coolant");
    }

    private static void initAchievements() {
        Localization.addLocalization("achievement.acquireRefinedIron", "Better than Iron");
        Localization.addLocalization("achievement.acquireRefinedIron.desc", "Smelt a refined iron ingot");
        Localization.addLocalization("achievement.buildGenerator", "Suitable Power");
        Localization.addLocalization("achievement.buildGenerator.desc", "Build a generator");
        Localization.addLocalization("achievement.acquireResin", "Sticky Situation");
        Localization.addLocalization("achievement.acquireResin.desc", "Get resin from a rubber tree with a treetap");
        Localization.addLocalization("achievement.buildCable", "Energy Flow");
        Localization.addLocalization("achievement.buildCable.desc", "Make some cables");
        Localization.addLocalization("achievement.mineOre", "New Ore Miner");
        Localization.addLocalization("achievement.mineOre.desc", "Mine copper, tin or uranium");
        Localization.addLocalization("achievement.buildMacerator", "Double Trouble");
        Localization.addLocalization("achievement.buildMacerator.desc", "Build a macerator");
        Localization.addLocalization("achievement.buildCoalDiamond", "Shiny");
        Localization.addLocalization("achievement.buildCoalDiamond.desc", "Make a coal chunk to compress into a diamond");
        Localization.addLocalization("achievement.buildElecFurnace", "Even Hotter Topic");
        Localization.addLocalization("achievement.buildElecFurnace.desc", "Build an electric furnace");
        Localization.addLocalization("achievement.buildIndFurnace", "Hyperspeed");
        Localization.addLocalization("achievement.buildIndFurnace.desc", "Build an induction furnace");
        Localization.addLocalization("achievement.buildBatBox", "Stash It");
        Localization.addLocalization("achievement.buildBatBox.desc", "Build a BatBox");
        Localization.addLocalization("achievement.buildCompressor", "Epic Squeeze");
        Localization.addLocalization("achievement.buildCompressor.desc", "Build a compressor");
        Localization.addLocalization("achievement.compressUranium", "Radioactivity");
        Localization.addLocalization("achievement.compressUranium.desc", "Compress uranium into an uranium fuel ingot");
        Localization.addLocalization("achievement.dieFromOwnNuke", "Crazy Ivan");
        Localization.addLocalization("achievement.dieFromOwnNuke.desc", "Die from a nuke you have placed");
        Localization.addLocalization("achievement.buildExtractor", "Super Treetap");
        Localization.addLocalization("achievement.buildExtractor.desc", "Build an extractor");
        Localization.addLocalization("achievement.buildChainsaw", "Lumberjack Assassin");
        Localization.addLocalization("achievement.buildChainsaw.desc", "Build a chainsaw");
        Localization.addLocalization("achievement.killCreeperChainsaw", "Creeper Chainsaw Massacre");
        Localization.addLocalization("achievement.killCreeperChainsaw.desc", "Kill a creeper with a chainsaw");
        Localization.addLocalization("achievement.buildDrill", "Meet the Dentist");
        Localization.addLocalization("achievement.buildDrill.desc", "Build a mining drill");
        Localization.addLocalization("achievement.buildDDrill", "Valuable Upgrade");
        Localization.addLocalization("achievement.buildDDrill.desc", "Upgrade your mining drill to a diamond-tipped mining drill");
        Localization.addLocalization("achievement.buildMFE", "Storage Upgrade");
        Localization.addLocalization("achievement.buildMFE.desc", "Build a MFE Unit");
        Localization.addLocalization("achievement.buildMiningLaser", "Laser Time");
        Localization.addLocalization("achievement.buildMiningLaser.desc", "Build a mining laser");
        Localization.addLocalization("achievement.killDragonMiningLaser", "Like A Boss");
        Localization.addLocalization("achievement.killDragonMiningLaser.desc", "Kill the enderdragon with a mining laser");
        Localization.addLocalization("achievement.buildMassFab", "Energy To Matter");
        Localization.addLocalization("achievement.buildMassFab.desc", "Build a Mass Fabricator");
        Localization.addLocalization("achievement.acquireMatter", "Pink Blob");
        Localization.addLocalization("achievement.acquireMatter.desc", "Produce some UU-Matter");
        Localization.addLocalization("achievement.buildQArmor", "Hi-Tech Wonder");
        Localization.addLocalization("achievement.buildQArmor.desc", "Build a piece of the quantum suit");
        Localization.addLocalization("achievement.starveWithQHelmet", "Forgot to Recharge");
        Localization.addLocalization("achievement.starveWithQHelmet.desc", "Starve to death or drown with a quantum helmet");
        Localization.addLocalization("achievement.buildMFS", "Just Too Much");
        Localization.addLocalization("achievement.buildMFS.desc", "Build a MFS Unit");
        Localization.addLocalization("achievement.buildTeleporter", "Intradimensional Warp");
        Localization.addLocalization("achievement.buildTeleporter.desc", "Build a Teleporter");
        Localization.addLocalization("achievement.teleportFarAway", "Far Far Away");
        Localization.addLocalization("achievement.teleportFarAway.desc", "Teleport for at least 1 km");
        Localization.addLocalization("achievement.buildTerraformer", "Change The World");
        Localization.addLocalization("achievement.buildTerraformer.desc", "Build a terraformer");
        Localization.addLocalization("achievement.terraformEndCultivation", "Endgame Paradise");
        Localization.addLocalization("achievement.terraformEndCultivation.desc", "Terraform the End to look like the overworld");
    }

    private static void initMisc() {
        Localization.addLocalization("container.electricBlock.level", "Power Level:");
        Localization.addLocalization("container.electricBlock.output", "Out: %1$s EU/t");
        Localization.addLocalization("container.induction.heat", "Heat:");
        Localization.addLocalization("container.matter.progress", "Progress:");
        Localization.addLocalization("container.matter.amplifier", "Amplifier:");
        Localization.addLocalization("container.personalTrader.want", "Want:");
        Localization.addLocalization("container.personalTrader.offer", "Offer:");
        Localization.addLocalization("container.personalTrader.totalTrades0", "Performed");
        Localization.addLocalization("container.personalTrader.totalTrades1", "Trades:");
        Localization.addLocalization("container.personalTraderEnergy.paidFor", "Paid For: %1$s EU");
        Localization.addLocalization("container.personalTraderEnergy.energyBuffer", "Buffer:");
        Localization.addLocalization("itemGroup.IC2", "IndustrialCraft 2");
        Localization.addLocalization("potion.radiation", "Radiation");
        Localization.addLocalization("death.electricity", "%1$s was electrocuted");
        Localization.addLocalization("death.nuke", "%1$s was nuked");
        Localization.addLocalization("death.radiation", "%1$s died from radiation");
    }
}

