/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.IReactor;
import ic2.api.IReactorComponent;
import ic2.core.item.reactor.ItemReactorHeatStorage;
import java.util.ArrayList;

public class ItemReactorHeatSwitch
extends ItemReactorHeatStorage {
    public int switchSide;
    public int switchReactor;

    public ItemReactorHeatSwitch(int id, int index, int heatStorage, int switchside, int switchreactor) {
        super(id, index, heatStorage);
        this.switchSide = switchside;
        this.switchReactor = switchreactor;
    }

    @Override
    public void processChamber(IReactor reactor, ur yourStack, int x, int y) {
        int myHeat = 0;
        ArrayList heatAcceptors = new ArrayList();
        double med = (double)this.getCurrentHeat(reactor, yourStack, x, y) / (double)this.getMaxHeat(reactor, yourStack, x, y);
        int c = 1;
        if (this.switchReactor > 0) {
            ++c;
            med += (double)reactor.getHeat() / (double)reactor.getMaxHeat();
        }
        if (this.switchSide > 0) {
            med += this.checkHeatAcceptor(reactor, x - 1, y, heatAcceptors);
            med += this.checkHeatAcceptor(reactor, x + 1, y, heatAcceptors);
            med += this.checkHeatAcceptor(reactor, x, y - 1, heatAcceptors);
            med += this.checkHeatAcceptor(reactor, x, y + 1, heatAcceptors);
        }
        med /= (double)(c + heatAcceptors.size());
        if (this.switchSide > 0) {
            for (ItemStackCoord stackcoord : heatAcceptors) {
                IReactorComponent heatable = (IReactorComponent)stackcoord.stack.b();
                int add = (int)(med * (double)heatable.getMaxHeat(reactor, stackcoord.stack, stackcoord.x, stackcoord.y)) - heatable.getCurrentHeat(reactor, stackcoord.stack, stackcoord.x, stackcoord.y);
                if (add > this.switchSide) {
                    add = this.switchSide;
                }
                if (add < -this.switchSide) {
                    add = -this.switchSide;
                }
                myHeat -= add;
                add = heatable.alterHeat(reactor, stackcoord.stack, stackcoord.x, stackcoord.y, add);
                myHeat += add;
            }
        }
        if (this.switchReactor > 0) {
            int add = (int)(med * (double)reactor.getMaxHeat()) - reactor.getHeat();
            if (add > this.switchReactor) {
                add = this.switchReactor;
            }
            if (add < -this.switchReactor) {
                add = -this.switchReactor;
            }
            myHeat -= add;
            reactor.setHeat(reactor.getHeat() + add);
        }
        this.alterHeat(reactor, yourStack, x, y, myHeat);
    }

    private double checkHeatAcceptor(IReactor reactor, int x, int y, ArrayList heatAcceptors) {
        IReactorComponent comp;
        ur thing = reactor.getItemAt(x, y);
        if (thing != null && thing.b() instanceof IReactorComponent && (comp = (IReactorComponent)thing.b()).canStoreHeat(reactor, thing, x, y)) {
            heatAcceptors.add(new ItemStackCoord(thing, x, y));
            double max = comp.getMaxHeat(reactor, thing, x, y);
            if (max <= 0.0) {
                return 0.0;
            }
            double cur = comp.getCurrentHeat(reactor, thing, x, y);
            return cur / max;
        }
        return 0.0;
    }

    private class ItemStackCoord {
        public ur stack;
        public int x;
        public int y;

        public ItemStackCoord(ur stack, int x, int y) {
            this.stack = stack;
            this.x = x;
            this.y = y;
        }
    }
}

