/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.plants;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.api.IFactoryPlantable;
import powercrystals.minefactoryreloaded.core.HarvestAreaManager;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryPowered;

public class TileEntityPlanter
extends TileEntityFactoryPowered
implements ISidedInventory {
    private HarvestAreaManager _areaManager = new HarvestAreaManager(this, 1, 0, 0);
    private boolean _isMultiPlanter = true;

    public TileEntityPlanter() {
        super(160);
        this._areaManager.setOverrideDirection(ForgeDirection.UP);
    }

    @Override
    public String getGuiBackground() {
        return "planter.png";
    }

    public static void registerPlantable(IFactoryPlantable plantable) {
        MFRRegistry.getPlantables().put(new Integer(plantable.getSourceId()), plantable);
    }

    @Override
    public boolean canRotate() {
        return false;
    }

    @Override
    protected void onFactoryInventoryChanged() {
        this._areaManager.updateUpgradeLevel(this._inventory[9]);
    }

    @Override
    public boolean activateMachine() {
        BlockPosition bp = this._areaManager.getNextBlock().copy();
        ++bp.y;
        List<Integer> slotOrder = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8);
        if (this._isMultiPlanter) {
            int ps = this.getPlanterSlotIdFromBp(bp);
            Collections.shuffle(slotOrder);
            if (slotOrder.contains(ps) && slotOrder.indexOf(ps) != 0) {
                Collections.swap(slotOrder, slotOrder.indexOf(ps), 0);
            }
        }
        for (Integer stackIndex : slotOrder) {
            IFactoryPlantable plantable;
            if (this.a(stackIndex) == null) continue;
            ur availableStack = this.a(stackIndex);
            if (!MFRRegistry.getPlantables().containsKey(new Integer(availableStack.c)) || !(plantable = (IFactoryPlantable)MFRRegistry.getPlantables().get(new Integer(availableStack.c))).canBePlantedHere(this.k, bp.x, bp.y, bp.z, availableStack)) continue;
            plantable.prePlant(this.k, bp.x, bp.y, bp.z, availableStack);
            this.k.d(bp.x, bp.y, bp.z, plantable.getPlantedBlockId(this.k, bp.x, bp.y, bp.z, availableStack), plantable.getPlantedBlockMetadata(this.k, bp.x, bp.y, bp.z, availableStack));
            plantable.postPlant(this.k, bp.x, bp.y, bp.z, availableStack);
            this.a((int)stackIndex, 1);
            return true;
        }
        this.setIdleTicks(this.getIdleTicksMax());
        return false;
    }

    private int getPlanterSlotIdFromBp(BlockPosition bp) {
        int radius = this._areaManager.getRadius();
        int xAdjusted = Math.round(1.49f * (float)(bp.x - this.l) / (float)radius);
        int zAdjusted = Math.round(1.49f * (float)(bp.z - this.n) / (float)radius);
        return 4 + xAdjusted + 3 * zAdjusted;
    }

    @Override
    public String b() {
        return "Planter";
    }

    public int k_() {
        return 10;
    }

    @Override
    public int getEnergyStoredMax() {
        return 8000;
    }

    @Override
    public int getWorkMax() {
        return 1;
    }

    @Override
    public int getIdleTicksMax() {
        return 5;
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 9;
    }
}

