/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.plants;

import java.util.List;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;

public class TreeHarvestManager {
    private List _treeBlocks;
    private int _currentBlock;
    private boolean _isLeafPass;
    private boolean _isDone;
    private Area _treeArea;

    public TreeHarvestManager(Area treeArea) {
        this._treeArea = treeArea;
        this.reset();
    }

    public BlockPosition getNextBlock() {
        return (BlockPosition)this._treeBlocks.get(this._currentBlock);
    }

    public void moveNext() {
        ++this._currentBlock;
        if (this._currentBlock >= this._treeBlocks.size()) {
            if (this._isLeafPass) {
                this._currentBlock = 0;
                this._treeBlocks = this._treeArea.getPositionsTopFirst();
                this._isLeafPass = false;
            } else {
                this._isDone = true;
            }
        }
    }

    public void reset() {
        this._currentBlock = 0;
        this._isLeafPass = true;
        this._treeBlocks = this._treeArea.getPositionsBottomFirst();
    }

    public boolean getIsLeafPass() {
        return this._isLeafPass;
    }

    public boolean getIsDone() {
        return this._isDone;
    }
}

