/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.processing;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.util.Util;
import powercrystals.minefactoryreloaded.MFRRegistry;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryInventory;

public class TileEntityBioReactor
extends TileEntityFactoryInventory
implements ITankContainer,
ISidedInventory {
    private LiquidTank _tank = new LiquidTank(4000);
    private int _burnTime;
    private static final int _burnTimeMax = 8000;
    private static final int _bioFuelPerTick = 10;
    private static final int _burnTimeDecreasePerTick = 10;
    private static final int[] _outputValues = new int[]{0, 80, 180, 300, 440, 600, 780, 980, 1200, 1440};

    public int getBurnTime() {
        return this._burnTime;
    }

    public void setBurnTime(int burnTime) {
        this._burnTime = burnTime;
    }

    public int getBurnTimeMax() {
        return 8000;
    }

    public int getOutputValue() {
        int occupiedSlots = 0;
        for (int i = 9; i < 18; ++i) {
            if (this._inventory[i] == null) continue;
            ++occupiedSlots;
        }
        return _outputValues[occupiedSlots];
    }

    public int getOutputValueMax() {
        return _outputValues[9];
    }

    @Override
    public void g() {
        super.g();
        if (!this.k.I) {
            for (int i = 0; i < 9; ++i) {
                int targetSlot;
                if (this._inventory[i] == null || !MFRRegistry.getPlantables().containsKey(this._inventory[i].c) || (targetSlot = this.findMatchingSlot(this._inventory[i])) < 0) continue;
                if (this._inventory[targetSlot] == null) {
                    this._inventory[targetSlot] = this._inventory[i];
                    this._inventory[i] = null;
                    continue;
                }
                MFRUtil.mergeStacks(this._inventory[targetSlot], this._inventory[i]);
                if (this._inventory[i].a > 0) continue;
                this._inventory[i] = null;
            }
            if (Util.isRedstonePowered((any)this)) {
                return;
            }
            int newBurn = this.getOutputValue();
            if (8000 - this._burnTime >= newBurn) {
                this._burnTime += newBurn;
                for (int i = 9; i < 18; ++i) {
                    if (this._inventory[i] == null) continue;
                    this.a(i, 1);
                }
            }
            if (this._burnTime > 0 && (this._tank.getLiquid() == null || this._tank.getLiquid().amount < this._tank.getCapacity() - 10)) {
                this._burnTime -= 10;
                this._tank.fill(LiquidDictionary.getLiquid((String)"biofuel", (int)10), true);
            }
        }
    }

    private int findMatchingSlot(ur s2) {
        for (int i = 9; i < 18; ++i) {
            if (this._inventory[i] == null || this._inventory[i].c != s2.c || this._inventory[i].j() != s2.j()) continue;
            return i;
        }
        return this.findEmptySlot();
    }

    private int findEmptySlot() {
        for (int i = 9; i < 18; ++i) {
            if (this._inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getGuiBackground() {
        return "bioreactor.png";
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    protected boolean shouldPumpLiquid() {
        return true;
    }

    public int k_() {
        return 18;
    }

    public String b() {
        return "Bio Reactor";
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 9;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this._tank;
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("burnTime", this._burnTime);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this._burnTime = nbttagcompound.e("burnTime");
    }
}

