/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.processing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.position.Area;
import powercrystals.core.position.BlockPosition;
import powercrystals.core.random.WeightedRandomItemStack;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryPowered;

public class TileEntitySludgeBoiler
extends TileEntityFactoryPowered
implements ITankContainer {
    private LiquidTank _tank = new LiquidTank(4000);
    private static List _drops = new ArrayList();
    private Random _rand = new Random();
    private int _tick;

    public static void registerSludgeDrop(int weight, ur drop) {
        _drops.add(new WeightedRandomItemStack(weight, drop));
    }

    public TileEntitySludgeBoiler() {
        super(20);
    }

    @Override
    public String getGuiBackground() {
        return "sludgeboiler.png";
    }

    @Override
    public boolean canRotate() {
        return false;
    }

    @Override
    public ILiquidTank getTank() {
        return this._tank;
    }

    @Override
    public int getEnergyStoredMax() {
        return 16000;
    }

    @Override
    public int getWorkMax() {
        return 1000;
    }

    @Override
    public int getIdleTicksMax() {
        return 1;
    }

    @Override
    protected boolean activateMachine() {
        if (this._tank.getLiquid() != null && this._tank.getLiquid().amount > 10) {
            this._tank.drain(10, true);
            this.setWorkDone(this.getWorkDone() + 10);
            ++this._tick;
            if (this.getWorkDone() >= this.getWorkMax()) {
                ur s2 = ((WeightedRandomItemStack)ku.a((Random)this._rand, (Collection)_drops)).getStack();
                if (s2 != null) {
                    MFRUtil.dropStack(this, s2);
                }
                this.setWorkDone(0);
            }
            if (this._tick >= 23) {
                Area a = new Area(new BlockPosition((any)this), 3, 3, 3);
                List entities = this.k.a(md.class, a.toAxisAlignedBB());
                for (Object o : entities) {
                    if (o != null && o instanceof qx) {
                        ((qx)o).d(new lm(ll.s.H, 400, 0));
                    }
                    if (o == null || !(o instanceof md)) continue;
                    ((md)o).d(new lm(ll.u.H, 120, 0));
                }
                this._tick = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.DOWN;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID != MineFactoryReloadedCore.sludgeItem.cj) {
            return 0;
        }
        return this._tank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID != MineFactoryReloadedCore.sludgeItem.cj) {
            return 0;
        }
        return this._tank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this._tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (type != null && type.itemID == MineFactoryReloadedCore.sludgeItem.cj) {
            return this._tank;
        }
        return null;
    }

    @Override
    public String b() {
        return "Sludge Boiler";
    }

    public int k_() {
        return 0;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }
}

