/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.transport;

import java.util.ArrayList;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryInventory;

public class TileEntityItemRouter
extends TileEntityFactoryInventory
implements ISidedInventory {
    private static final int[] _invOffsets = new int[]{0, 0, 9, 18, 36, 27};
    private static final ForgeDirection[] _outputDirections = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    private Random _rand = new Random();

    @Override
    public void g() {
        super.g();
        if (!this.k.I) {
            for (int i = 45; i < this.k_(); ++i) {
                if (this._inventory[i] == null || !this.routeItem(this._inventory[i])) continue;
                this._inventory[i] = null;
            }
        }
    }

    @Override
    public boolean canRotate() {
        return false;
    }

    public boolean routeItem(ur stack) {
        ArrayList<ForgeDirection> filteredOutputs = new ArrayList<ForgeDirection>();
        ArrayList<ForgeDirection> emptyOutputs = new ArrayList<ForgeDirection>();
        for (ForgeDirection d : _outputDirections) {
            if (this.isSideValidForItem(stack, d)) {
                filteredOutputs.add(d);
            }
            if (!this.isSideEmpty(d)) continue;
            emptyOutputs.add(d);
        }
        if (filteredOutputs.size() > 0) {
            MFRUtil.dropStackDirected(this, stack, (ForgeDirection)filteredOutputs.get(this._rand.nextInt(filteredOutputs.size())));
            return stack.a == 0;
        }
        if (emptyOutputs.size() > 0) {
            MFRUtil.dropStackDirected(this, stack, (ForgeDirection)emptyOutputs.get(this._rand.nextInt(emptyOutputs.size())));
            return stack.a == 0;
        }
        return false;
    }

    public boolean hasRouteForItem(ur stack) {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.isSideValidForItem(stack, d)) continue;
            return true;
        }
        return false;
    }

    private boolean isSideValidForItem(ur stack, ForgeDirection side) {
        int sideStart;
        if (side == ForgeDirection.UNKNOWN || side == ForgeDirection.UP) {
            return false;
        }
        for (int i = sideStart = _invOffsets[side.ordinal()]; i < sideStart + 9; ++i) {
            if (this._inventory[i] == null || (this._inventory[i].c != stack.c || this._inventory[i].j() != stack.j()) && !stack.b().n()) continue;
            return true;
        }
        return false;
    }

    private boolean isSideEmpty(ForgeDirection side) {
        int sideStart;
        if (side == ForgeDirection.UNKNOWN || side == ForgeDirection.UP) {
            return false;
        }
        for (int i = sideStart = _invOffsets[side.ordinal()]; i < sideStart + 9; ++i) {
            if (this._inventory[i] == null) continue;
            return false;
        }
        return true;
    }

    public int k_() {
        return 48;
    }

    public String b() {
        return "Item Router";
    }

    @Override
    public String getGuiBackground() {
        return "itemrouter.png";
    }

    @Override
    public int c() {
        return 64;
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 45;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 3;
    }
}

