/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public class ConnectedTextures {
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] terrainProperties = null;
    private static boolean matchingCtmPng = false;
    private static final int BOTTOM = 0;
    private static final int TOP = 1;
    private static final int EAST = 2;
    private static final int WEST = 3;
    private static final int NORTH = 4;
    private static final int SOUTH = 5;
    private static final String[] propSuffixes = new String[]{"", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};

    public static void update(bba re2) {
        blockProperties = null;
        terrainProperties = null;
        matchingCtmPng = false;
        blockProperties = ConnectedTextures.readConnectedProperties("/ctm/block", 256, re2, 1);
        terrainProperties = ConnectedTextures.readConnectedProperties("/ctm/terrain", 256, re2, 2);
        matchingCtmPng = ConnectedTextures.getMatchingCtmPng(re2);
        Config.dbg("MatchingCtmPng: " + matchingCtmPng);
        if (blockProperties == null && terrainProperties == null && matchingCtmPng) {
            Config.dbg("Registering default ConnectedTextures");
            blockProperties = new ConnectedProperties[256][];
            ConnectedTextures.blockProperties[amq.P.cm] = new ConnectedProperties[1];
            ConnectedTextures.blockProperties[amq.P.cm][0] = ConnectedTextures.makeDefaultProperties("ctm", re2);
            ConnectedTextures.blockProperties[amq.aq.cm] = new ConnectedProperties[1];
            ConnectedTextures.blockProperties[amq.aq.cm][0] = ConnectedTextures.makeDefaultProperties("horizontal", re2);
            terrainProperties = new ConnectedProperties[256][];
            ConnectedTextures.terrainProperties[amq.T.cl] = new ConnectedProperties[1];
            ConnectedTextures.terrainProperties[amq.T.cl][0] = ConnectedTextures.makeDefaultProperties("top", re2);
        }
    }

    private static ConnectedProperties[][] readConnectedProperties(String prefix, int num, bba re2, int defConnect) {
        ConnectedProperties[][] cps = null;
        for (int i2 = 0; i2 < num; ++i2) {
            ArrayList<ConnectedProperties> listIndexProps = new ArrayList<ConnectedProperties>();
            for (int is2 = 0; is2 < propSuffixes.length; ++is2) {
                String suff = propSuffixes[is2];
                String path = prefix + i2 + suff + ".properties";
                InputStream in2 = re2.k.e().a(path);
                if (in2 == null) break;
                try {
                    Properties props = new Properties();
                    props.load(in2);
                    Config.dbg("Connected texture: " + path);
                    ConnectedProperties cp2 = new ConnectedProperties(props);
                    if (cp2.connect == 0) {
                        cp2.connect = defConnect;
                    }
                    if (!cp2.isValid(path)) continue;
                    TextureUtils.addAtlasName(cp2.source);
                    cp2.textureId = re2.b(cp2.source);
                    listIndexProps.add(cp2);
                    in2.close();
                    continue;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            if (listIndexProps.size() <= 0) continue;
            if (cps == null) {
                cps = new ConnectedProperties[num][0];
            }
            cps[i2] = listIndexProps.toArray(new ConnectedProperties[listIndexProps.size()]);
        }
        return cps;
    }

    public static int getConnectedTexture(ym blockAccess, amq block, int x2, int y2, int z2, int side, int tileNum) {
        ConnectedProperties[] cps;
        int blockId;
        ConnectedProperties[] cps2;
        if (blockAccess == null) {
            return -1;
        }
        int metadata = -1;
        if (terrainProperties != null && baz.a.defaultTexture && tileNum >= 0 && tileNum < terrainProperties.length && (cps2 = terrainProperties[tileNum]) != null) {
            int texNum;
            if (metadata < 0) {
                metadata = blockAccess.h(x2, y2, z2);
            }
            if ((texNum = ConnectedTextures.getConnectedTexture(cps2, blockAccess, block, x2, y2, z2, side, tileNum, metadata)) >= 0) {
                return texNum;
            }
        }
        if (blockProperties != null && (blockId = block.cm) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null) {
            int texNum;
            if (metadata < 0) {
                metadata = blockAccess.h(x2, y2, z2);
            }
            if ((texNum = ConnectedTextures.getConnectedTexture(cps, blockAccess, block, x2, y2, z2, side, tileNum, metadata)) >= 0) {
                return texNum;
            }
        }
        return -1;
    }

    private static int getConnectedTexture(ConnectedProperties[] cps, ym blockAccess, amq block, int x2, int y2, int z2, int side, int tileNum, int metadata) {
        for (int i2 = 0; i2 < cps.length; ++i2) {
            int texNum;
            ConnectedProperties cp2 = cps[i2];
            if (cp2 == null || (texNum = ConnectedTextures.getConnectedTexture(cp2, blockAccess, block, x2, y2, z2, side, tileNum, metadata)) < 0) continue;
            return texNum;
        }
        return -1;
    }

    private static int getConnectedTexture(ConnectedProperties cp2, ym blockAccess, amq block, int x2, int y2, int z2, int side, int tileNum, int metadata) {
        boolean blockWood = block instanceof ana;
        if (side >= 0 && cp2.faces != 63) {
            int checkSide = side;
            if (blockWood) {
                checkSide = ConnectedTextures.fixWoodSide(blockAccess, x2, y2, z2, side, metadata);
            }
            if ((1 << checkSide & cp2.faces) == 0) {
                return -1;
            }
        }
        int checkMetadata = metadata;
        if (blockWood) {
            checkMetadata &= 3;
        }
        if (cp2.metadatas != null) {
            int[] mds = cp2.metadatas;
            boolean metadataFound = false;
            for (int i2 = 0; i2 < mds.length; ++i2) {
                if (mds[i2] != checkMetadata) continue;
                metadataFound = true;
                break;
            }
            if (!metadataFound) {
                return -1;
            }
        }
        switch (cp2.method) {
            case 1: {
                return ConnectedTextures.getConnectedTextureCtm(cp2, blockAccess, block, x2, y2, z2, side, tileNum, metadata);
            }
            case 2: {
                return ConnectedTextures.getConnectedTextureHorizontal(cp2, blockAccess, block, x2, y2, z2, side, tileNum, metadata);
            }
            case 6: {
                return ConnectedTextures.getConnectedTextureVertical(cp2, blockAccess, block, x2, y2, z2, side, tileNum, metadata);
            }
            case 3: {
                return ConnectedTextures.getConnectedTextureTop(cp2, blockAccess, block, x2, y2, z2, side, tileNum, metadata);
            }
            case 4: {
                return ConnectedTextures.getConnectedTextureRandom(cp2, x2, y2, z2, side);
            }
            case 5: {
                return ConnectedTextures.getConnectedTextureRepeat(cp2, x2, y2, z2, side);
            }
            case 7: {
                return ConnectedTextures.getConnectedTextureFixed(cp2);
            }
        }
        return -1;
    }

    private static int fixWoodSide(ym blockAccess, int x2, int y2, int z2, int side, int metadata) {
        int orient = (metadata & 0xC) >> 2;
        switch (orient) {
            case 0: {
                return side;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 0;
                    }
                }
                break;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                break;
            }
            case 3: {
                return 2;
            }
        }
        return side;
    }

    private static int getConnectedTextureRandom(ConnectedProperties cp2, int x2, int y2, int z2, int side) {
        if (cp2.tiles.length == 1) {
            return cp2.textureId * 256 + cp2.tiles[0];
        }
        int face = side / cp2.symmetry * cp2.symmetry;
        int rand = Config.getRandom(x2, y2, z2, face) & Integer.MAX_VALUE;
        int index = 0;
        if (cp2.weights == null) {
            index = rand % cp2.tiles.length;
        } else {
            int randWeight = rand % cp2.sumAllWeights;
            int[] sumWeights = cp2.sumWeights;
            for (int i2 = 0; i2 < sumWeights.length; ++i2) {
                if (randWeight >= sumWeights[i2]) continue;
                index = i2;
                break;
            }
        }
        return cp2.textureId * 256 + cp2.tiles[index];
    }

    private static int getConnectedTextureFixed(ConnectedProperties cp2) {
        return cp2.textureId * 256 + cp2.tiles[0];
    }

    private static int getConnectedTextureRepeat(ConnectedProperties cp2, int x2, int y2, int z2, int side) {
        if (cp2.tiles.length == 1) {
            return cp2.textureId * 256 + cp2.tiles[0];
        }
        int nx = 0;
        int ny2 = 0;
        switch (side) {
            case 0: {
                nx = x2;
                ny2 = z2;
                break;
            }
            case 1: {
                nx = x2;
                ny2 = z2;
                break;
            }
            case 2: {
                nx = -x2 - 1;
                ny2 = -y2;
                break;
            }
            case 3: {
                nx = x2;
                ny2 = -y2;
                break;
            }
            case 4: {
                nx = z2;
                ny2 = -y2;
                break;
            }
            case 5: {
                nx = -z2 - 1;
                ny2 = -y2;
            }
        }
        ny2 %= cp2.height;
        if ((nx %= cp2.width) < 0) {
            nx += cp2.width;
        }
        if (ny2 < 0) {
            ny2 += cp2.height;
        }
        int index = ny2 * cp2.width + nx;
        return cp2.textureId * 256 + cp2.tiles[index];
    }

    private static int getConnectedTextureCtm(ConnectedProperties cp2, ym blockAccess, amq block, int x2, int y2, int z2, int side, int tileNum, int metadata) {
        boolean[] borders = new boolean[6];
        switch (side) {
            case 0: 
            case 1: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, tileNum, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, tileNum, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, tileNum, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, tileNum, metadata);
                break;
            }
            case 2: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, tileNum, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, tileNum, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, tileNum, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, tileNum, metadata);
                break;
            }
            case 3: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, tileNum, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, tileNum, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, tileNum, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, tileNum, metadata);
                break;
            }
            case 4: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, tileNum, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, tileNum, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, tileNum, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, tileNum, metadata);
                break;
            }
            case 5: {
                borders[0] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, tileNum, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, tileNum, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, tileNum, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, tileNum, metadata);
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (!Config.isConnectedTexturesFancy()) {
            return cp2.textureId * 256 + cp2.tiles[index];
        }
        boolean[] edges = new boolean[6];
        switch (side) {
            case 0: 
            case 1: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2 + 1, side, tileNum, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2 + 1, side, tileNum, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2 - 1, side, tileNum, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2 - 1, side, tileNum, metadata);
                break;
            }
            case 2: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2 - 1, z2, side, tileNum, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2 - 1, z2, side, tileNum, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2 + 1, z2, side, tileNum, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2 + 1, z2, side, tileNum, metadata);
                break;
            }
            case 3: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2 - 1, z2, side, tileNum, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2 - 1, z2, side, tileNum, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2 + 1, z2, side, tileNum, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2 + 1, z2, side, tileNum, metadata);
                break;
            }
            case 4: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2 + 1, side, tileNum, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2 - 1, side, tileNum, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2 + 1, side, tileNum, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2 - 1, side, tileNum, metadata);
                break;
            }
            case 5: {
                edges[0] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2 - 1, side, tileNum, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2 + 1, side, tileNum, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2 - 1, side, tileNum, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2 + 1, side, tileNum, metadata);
            }
        }
        if (index == 13 && edges[0]) {
            index = 4;
        }
        if (index == 15 && edges[1]) {
            index = 5;
        }
        if (index == 37 && edges[2]) {
            index = 16;
        }
        if (index == 39 && edges[3]) {
            index = 17;
        }
        if (index == 14 && edges[0] && edges[1]) {
            index = 7;
        }
        if (index == 25 && edges[0] && edges[2]) {
            index = 6;
        }
        if (index == 27 && edges[3] && edges[1]) {
            index = 19;
        }
        if (index == 38 && edges[3] && edges[2]) {
            index = 18;
        }
        if (index == 14 && !edges[0] && edges[1]) {
            index = 31;
        }
        if (index == 25 && edges[0] && !edges[2]) {
            index = 30;
        }
        if (index == 27 && !edges[3] && edges[1]) {
            index = 41;
        }
        if (index == 38 && edges[3] && !edges[2]) {
            index = 40;
        }
        if (index == 14 && edges[0] && !edges[1]) {
            index = 29;
        }
        if (index == 25 && !edges[0] && edges[2]) {
            index = 28;
        }
        if (index == 27 && edges[3] && !edges[1]) {
            index = 43;
        }
        if (index == 38 && !edges[3] && edges[2]) {
            index = 42;
        }
        if (index == 26 && edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 46;
        }
        if (index == 26 && !edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 9;
        }
        if (index == 26 && edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 21;
        }
        if (index == 26 && edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 8;
        }
        if (index == 26 && edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 20;
        }
        if (index == 26 && edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 11;
        }
        if (index == 26 && !edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 22;
        }
        if (index == 26 && !edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 23;
        }
        if (index == 26 && edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 10;
        }
        if (index == 26 && edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 34;
        }
        if (index == 26 && !edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 35;
        }
        if (index == 26 && edges[0] && !edges[1] && !edges[2] && !edges[3]) {
            index = 32;
        }
        if (index == 26 && !edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 33;
        }
        if (index == 26 && !edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 44;
        }
        if (index == 26 && !edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 45;
        }
        return cp2.textureId * 256 + cp2.tiles[index];
    }

    private static boolean isNeighbour(ConnectedProperties cp2, ym iblockaccess, amq block, int x2, int y2, int z2, int side, int tileNum, int metadata) {
        int blockId = iblockaccess.a(x2, y2, z2);
        if (cp2.connect == 2) {
            amq neighbourBlock = amq.p[blockId];
            if (neighbourBlock == null) {
                return false;
            }
            int neighbourTileNum = neighbourBlock.d(iblockaccess, x2, y2, z2, side);
            return neighbourTileNum == tileNum;
        }
        if (cp2.connect == 3) {
            amq neighbourBlock = amq.p[blockId];
            if (neighbourBlock == null) {
                return false;
            }
            return neighbourBlock.cB == block.cB;
        }
        return blockId == block.cm && iblockaccess.h(x2, y2, z2) == metadata;
    }

    private static int getConnectedTextureHorizontal(ConnectedProperties cp2, ym blockAccess, amq block, int x2, int y2, int z2, int side, int tileNum, int metadata) {
        if (side == 0 || side == 1) {
            return -1;
        }
        boolean left = false;
        boolean right = false;
        switch (side) {
            case 2: {
                left = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, tileNum, metadata);
                right = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, tileNum, metadata);
                break;
            }
            case 3: {
                left = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 - 1, y2, z2, side, tileNum, metadata);
                right = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2 + 1, y2, z2, side, tileNum, metadata);
                break;
            }
            case 4: {
                left = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, tileNum, metadata);
                right = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, tileNum, metadata);
                break;
            }
            case 5: {
                left = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 + 1, side, tileNum, metadata);
                right = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2, z2 - 1, side, tileNum, metadata);
            }
        }
        int index = 3;
        index = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return cp2.textureId * 256 + cp2.tiles[index];
    }

    private static int getConnectedTextureVertical(ConnectedProperties cp2, ym blockAccess, amq block, int x2, int y2, int z2, int side, int tileNum, int metadata) {
        if (side == 0 || side == 1) {
            return -1;
        }
        boolean bottom = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 - 1, z2, side, tileNum, metadata);
        boolean top = ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, tileNum, metadata);
        int index = 3;
        index = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return cp2.textureId * 256 + cp2.tiles[index];
    }

    private static int getConnectedTextureTop(ConnectedProperties cp2, ym blockAccess, amq block, int x2, int y2, int z2, int side, int tileNum, int metadata) {
        if (side == 0 || side == 1) {
            return -1;
        }
        if (ConnectedTextures.isNeighbour(cp2, blockAccess, block, x2, y2 + 1, z2, side, tileNum, metadata)) {
            return cp2.textureId * 256 + cp2.tiles[0];
        }
        return -1;
    }

    public static boolean isConnectedGlassPanes() {
        return Config.isConnectedTextures() && matchingCtmPng;
    }

    private static boolean getMatchingCtmPng(bba re2) {
        Dimension dimCtm = re2.getTextureDimensions(re2.b("/ctm.png"));
        if (dimCtm == null) {
            return false;
        }
        Dimension dimTerrain = re2.getTextureDimensions(re2.b("/terrain.png"));
        if (dimTerrain == null) {
            return false;
        }
        return dimCtm.width == dimTerrain.width && dimCtm.height == dimTerrain.height;
    }

    private static ConnectedProperties makeDefaultProperties(String methodStr, bba re2) {
        Properties props = new Properties();
        props.put("source", "/ctm.png");
        props.put("method", methodStr);
        ConnectedProperties cp2 = new ConnectedProperties(props);
        cp2.isValid("(default)");
        cp2.textureId = re2.b(cp2.source);
        return cp2;
    }
}

