/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;

public class TextureUtils {
    private static Set atlasNames = TextureUtils.makeAtlasNames();
    private static Set atlasIds = new HashSet();

    private static Set makeAtlasNames() {
        HashSet<String> set = new HashSet<String>();
        set.add("/terrain.png");
        set.add("/gui/items.png");
        set.add("/ctm.png");
        set.add("/eloraam/world/world1.png");
        set.add("/gfx/buildcraft/blocks/blocks.png");
        return set;
    }

    public static void textureCreated(String name, int id) {
        if (atlasNames.contains(name)) {
            atlasIds.add(id);
        }
    }

    public static void addAtlasName(String name) {
        if (name == null) {
            return;
        }
        atlasNames.add(name);
        Config.dbg("TextureAtlas: " + name);
    }

    public static boolean isAtlasId(int i2) {
        return atlasIds.contains(i2);
    }

    public static boolean isAtlasName(String name) {
        return atlasNames.contains(name);
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi2) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi2.getWidth()) == (height = bi2.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi2, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi2;
    }
}

