/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.eventbus.EventBus;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.ItemData;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class FMLDummyContainer
extends DummyModContainer
implements WorldAccessContainer {
    public FMLDummyContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "FML";
        meta.name = "Forge Mod Loader";
        meta.version = Loader.instance().getFMLVersionString();
        meta.credits = "Made possible with help from many people";
        meta.authorList = Arrays.asList("cpw, LexManos");
        meta.description = "The Forge Mod Loader provides the ability for systems to load mods from the file system. It also provides key capabilities for mods to be able to cooperate and provide a good modding environment. The mod loading system is compatible with ModLoader, all your ModLoader mods should work.";
        meta.url = "https://github.com/MinecraftForge/FML/wiki";
        meta.updateUrl = "https://github.com/MinecraftForge/FML/wiki";
        meta.screenshots = new String[0];
        meta.logoFile = "";
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        return true;
    }

    @Override
    public bq getDataForWriting(ahv handler, ahx info) {
        bq fmlData = new bq();
        by list = new by();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            bq mod = new bq();
            mod.a("ModId", mc.getModId());
            mod.a("ModVersion", mc.getVersion());
            list.a((cd)mod);
        }
        fmlData.a("ModList", (cd)list);
        by itemList = new by();
        GameData.writeItemData(itemList);
        fmlData.a("ModItemData", (cd)itemList);
        return fmlData;
    }

    @Override
    public void readData(ahv handler, ahx info, Map<String, cd> propertyMap, bq tag) {
        by modList;
        if (tag.b("ModList")) {
            modList = tag.m("ModList");
            for (int i2 = 0; i2 < modList.c(); ++i2) {
                bq mod = (bq)modList.b(i2);
                String modId = mod.i("ModId");
                String modVersion = mod.i("ModVersion");
                ModContainer container = Loader.instance().getIndexedModList().get(modId);
                if (container == null) {
                    FMLLog.log("fml.ModTracker", Level.SEVERE, "This world was saved with mod %s which appears to be missing, things may not work well", modId);
                    continue;
                }
                if (modVersion.equals(container.getVersion())) continue;
                FMLLog.log("fml.ModTracker", Level.INFO, "This world was saved with mod %s version %s and it is now at version %s, things may not work well", modId, modVersion, container.getVersion());
            }
        }
        if (tag.b("ModItemData")) {
            modList = tag.m("ModItemData");
            Set<ItemData> worldSaveItems = GameData.buildWorldItemData(modList);
            GameData.validateWorldSave(worldSaveItems);
        } else {
            GameData.validateWorldSave(null);
        }
    }

    @Override
    public Certificate getSigningCertificate() {
        Certificate[] certificates = this.getClass().getProtectionDomain().getCodeSource().getCertificates();
        return certificates != null ? certificates[0] : null;
    }
}

