/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.Random;
import net.minecraftforge.common.ChestGenHooks;

public class DungeonHooks {
    private static ArrayList<DungeonMob> dungeonMobs = new ArrayList();

    public static float addDungeonMob(String name, int rarity) {
        if (rarity <= 0) {
            throw new IllegalArgumentException("Rarity must be greater then zero");
        }
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            return mob.a += rarity;
        }
        dungeonMobs.add(new DungeonMob(rarity, name));
        return rarity;
    }

    public static int removeDungeonMob(String name) {
        for (DungeonMob mob : dungeonMobs) {
            if (!name.equals(mob.type)) continue;
            dungeonMobs.remove((Object)mob);
            return mob.a;
        }
        return 0;
    }

    public static String getRandomDungeonMob(Random rand) {
        DungeonMob mob = (DungeonMob)ku.a((Random)rand, dungeonMobs);
        if (mob == null) {
            return "";
        }
        return mob.type;
    }

    @Deprecated
    public static void setDungeonLootTries(int number) {
        ChestGenHooks.getInfo("dungeonChest").setMax(number);
        ChestGenHooks.getInfo("dungeonChest").setMin(number);
    }

    @Deprecated
    public static int getDungeonLootTries() {
        return ChestGenHooks.getInfo("dungeonChest").getMax();
    }

    @Deprecated
    public void addDungeonLoot(DungeonLoot loot) {
        ChestGenHooks.getInfo("dungeonChest").addItem(loot);
    }

    @Deprecated
    public boolean removeDungeonLoot(DungeonLoot loot) {
        return ChestGenHooks.getInfo((String)"dungeonChest").contents.remove((Object)loot);
    }

    @Deprecated
    public static void addDungeonLoot(ur item, int rarity) {
        DungeonHooks.addDungeonLoot(item, rarity, 1, 1);
    }

    @Deprecated
    public static float addDungeonLoot(ur item, int rarity, int minCount, int maxCount) {
        ChestGenHooks.addDungeonLoot(ChestGenHooks.getInfo("dungeonChest"), item, rarity, minCount, maxCount);
        return rarity;
    }

    @Deprecated
    public static void removeDungeonLoot(ur item) {
        ChestGenHooks.removeItem("dungeonChest", item);
    }

    @Deprecated
    public static void removeDungeonLoot(ur item, int minCount, int maxCount) {
        ChestGenHooks.removeItem("dungeonChest", item);
    }

    @Deprecated
    public static ur getRandomDungeonLoot(Random rand) {
        return ChestGenHooks.getOneItem("dungeonChest", rand);
    }

    static {
        DungeonHooks.addDungeonMob("Skeleton", 100);
        DungeonHooks.addDungeonMob("Zombie", 200);
        DungeonHooks.addDungeonMob("Spider", 100);
    }

    @Deprecated
    public static class DungeonLoot
    extends kw {
        @Deprecated
        public DungeonLoot(int weight, ur item, int min, int max) {
            super(item, weight, min, max);
        }

        @Deprecated
        public ur generateStack(Random rand) {
            int min = this.c;
            int max = this.d;
            ur ret = this.b.l();
            ret.a = min + rand.nextInt(max - min + 1);
            return ret;
        }

        @Override
        protected final ur[] generateChestContent(Random random, la newInventory) {
            FMLLog.warning("Some mod is still using DungeonHooks.DungonLoot, tell them to stop! %s", new Object[]{this});
            return new ur[]{this.generateStack(random)};
        }

        public boolean equals(ur item, int min, int max) {
            int minCount = this.c;
            int maxCount = this.d;
            return min == minCount && max == maxCount && item.a(this.b) && ur.a((ur)item, (ur)this.b);
        }

        public boolean equals(ur item) {
            return item.a(this.b) && ur.a((ur)item, (ur)this.b);
        }
    }

    public static class DungeonMob
    extends kv {
        public String type;

        public DungeonMob(int weight, String type) {
            super(weight);
            this.type = type;
        }

        public boolean equals(Object target) {
            return target instanceof DungeonMob && this.type.equals(((DungeonMob)((Object)target)).type);
        }
    }
}

