/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;

public class ForgeHooks {
    static final List<GrassEntry> grassList = new ArrayList<GrassEntry>();
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static HashMap<up, List> toolClasses = new HashMap();
    static HashMap<List, Integer> toolHarvestLevels = new HashMap();
    static HashSet<List> toolEffectiveness = new HashSet();

    public static void plantGrass(yc world, int x2, int y, int z2) {
        GrassEntry grass = (GrassEntry)ku.a((Random)world.t, grassList);
        if (grass == null || grass.block == null || !grass.block.d(world, x2, y, z2)) {
            return;
        }
        world.d(x2, y, z2, grass.block.cm, grass.metadata);
    }

    public static ur getGrassSeed(yc world) {
        SeedEntry entry = (SeedEntry)ku.a((Random)world.t, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.seed.l();
    }

    public static boolean canHarvestBlock(amq block, qx player, int metadata) {
        if (block.cB.l()) {
            return true;
        }
        ur stack = player.bJ.g();
        if (stack == null) {
            return player.b(block);
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return player.b(block);
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        if (blockHarvestLevel == null) {
            return player.b(block);
        }
        return blockHarvestLevel <= harvestLevel;
    }

    public static boolean canToolHarvestBlock(amq block, int metadata, ur stack) {
        if (stack == null) {
            return false;
        }
        List info = toolClasses.get(stack.b());
        if (info == null) {
            return false;
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = toolHarvestLevels.get(Arrays.asList(block, metadata, toolClass));
        return blockHarvestLevel != null && blockHarvestLevel <= harvestLevel;
    }

    public static float blockStrength(amq block, qx player, yc world, int x2, int y, int z2) {
        int metadata = world.h(x2, y, z2);
        float hardness = block.m(world, x2, y, z2);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(block, player, metadata)) {
            float speed = ForgeEventFactory.getBreakSpeed(player, block, metadata, 1.0f);
            return (speed < 0.0f ? 0.0f : speed) / hardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(block, metadata) / hardness / 30.0f;
    }

    public static boolean isToolEffective(ur stack, amq block, int metadata) {
        List toolClass = toolClasses.get(stack.b());
        return toolClass != null && toolEffectiveness.contains(Arrays.asList(block, metadata, toolClass.get(0)));
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        MinecraftForge.setToolClass(up.t, "pickaxe", 0);
        MinecraftForge.setToolClass(up.x, "pickaxe", 1);
        MinecraftForge.setToolClass(up.g, "pickaxe", 2);
        MinecraftForge.setToolClass(up.I, "pickaxe", 0);
        MinecraftForge.setToolClass(up.B, "pickaxe", 3);
        MinecraftForge.setToolClass(up.u, "axe", 0);
        MinecraftForge.setToolClass(up.y, "axe", 1);
        MinecraftForge.setToolClass(up.h, "axe", 2);
        MinecraftForge.setToolClass(up.J, "axe", 0);
        MinecraftForge.setToolClass(up.C, "axe", 3);
        MinecraftForge.setToolClass(up.s, "shovel", 0);
        MinecraftForge.setToolClass(up.w, "shovel", 1);
        MinecraftForge.setToolClass(up.f, "shovel", 2);
        MinecraftForge.setToolClass(up.H, "shovel", 0);
        MinecraftForge.setToolClass(up.A, "shovel", 3);
        for (amq block : uy.c) {
            MinecraftForge.setBlockHarvestLevel(block, "pickaxe", 0);
        }
        for (amq block : vj.c) {
            MinecraftForge.setBlockHarvestLevel(block, "shovel", 0);
        }
        for (amq block : un.c) {
            MinecraftForge.setBlockHarvestLevel(block, "axe", 0);
        }
        MinecraftForge.setBlockHarvestLevel(amq.as, "pickaxe", 3);
        MinecraftForge.setBlockHarvestLevel(amq.bU, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(amq.az, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(amq.aA, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(amq.J, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(amq.ak, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(amq.K, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(amq.al, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(amq.Q, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(amq.R, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(amq.aQ, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(amq.aR, "pickaxe", 2);
        MinecraftForge.removeBlockEffectiveness(amq.aQ, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(amq.as, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(amq.aR, "pickaxe");
    }

    public static String getTexture(String _default, Object obj) {
        if (obj instanceof up) {
            return ((up)obj).getTextureFile();
        }
        if (obj instanceof amq) {
            return ((amq)obj).getTextureFile();
        }
        return _default;
    }

    public static int getTotalArmorValue(qx player) {
        int ret = 0;
        for (int x2 = 0; x2 < player.bJ.b.length; ++x2) {
            ur stack = player.bJ.b[x2];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)((Object)stack.b())).getArmorDisplay(player, stack, x2);
                continue;
            }
            if (stack == null || !(stack.b() instanceof su)) continue;
            ret += ((su)stack.b()).b;
        }
        return ret;
    }

    public static boolean onPickBlock(aoh target, qx player, yc world) {
        int x2;
        ur result = null;
        boolean isCreative = player.cd.d;
        if (target.a == aoi.a) {
            x2 = target.b;
            int y = target.c;
            int z2 = target.d;
            amq var8 = amq.p[world.a(x2, y, z2)];
            if (var8 == null) {
                return false;
            }
            result = var8.getPickBlock(target, world, x2, y, z2);
        } else {
            if (target.a != aoi.b || target.g == null || !isCreative) {
                return false;
            }
            result = target.g.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        for (x2 = 0; x2 < 9; ++x2) {
            ur stack = player.bJ.a(x2);
            if (stack == null || !stack.a(result) || !ur.a((ur)stack, (ur)result)) continue;
            player.bJ.c = x2;
            return true;
        }
        if (!isCreative) {
            return false;
        }
        int slot = player.bJ.i();
        if (slot < 0 || slot >= 9) {
            slot = player.bJ.c;
        }
        player.bJ.a(slot, result);
        player.bJ.c = slot;
        return true;
    }

    public static void onLivingSetAttackTarget(md entity, md target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(md entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(md entity, lh src, int amount) {
        return MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static int onLivingHurt(md entity, lh src, int amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0 : event.ammount;
    }

    public static boolean onLivingDeath(md entity, lh src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(md entity, lh source, ArrayList<px> drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit, specialDropValue));
    }

    public static float onLivingFall(md entity, float distance) {
        LivingFallEvent event = new LivingFallEvent(entity, distance);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.distance;
    }

    public static boolean isLivingOnLadder(amq block, yc world, int x2, int y, int z2) {
        return block != null && block.isLadder(world, x2, y, z2);
    }

    public static void onLivingJump(md entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static px onPlayerTossEvent(qx player, ur item) {
        player.captureDrops = true;
        px ret = player.a(item, false);
        player.capturedDrops.clear();
        player.captureDrops = false;
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        player.a(event.entityItem);
        return event.entityItem;
    }

    static {
        grassList.add(new GrassEntry(amq.ag, 0, 20));
        grassList.add(new GrassEntry(amq.ah, 0, 10));
        seedList.add(new SeedEntry(new ur(up.S), 10));
        ForgeHooks.initTools();
    }

    static class SeedEntry
    extends kv {
        public final ur seed;

        public SeedEntry(ur seed, int weight) {
            super(weight);
            this.seed = seed;
        }
    }

    static class GrassEntry
    extends kv {
        public final amq block;
        public final int metadata;

        public GrassEntry(amq block, int meta, int weight) {
            super(weight);
            this.block = block;
            this.metadata = meta;
        }
    }
}

