/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.liquids;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidEvent
extends Event {
    public final LiquidStack liquid;
    public final int x;
    public final int y;
    public final int z;
    public final yc world;

    public LiquidEvent(LiquidStack liquid, yc world, int x2, int y, int z2) {
        this.liquid = liquid;
        this.world = world;
        this.x = x2;
        this.y = y;
        this.z = z2;
    }

    public static final void fireEvent(LiquidEvent event) {
        MinecraftForge.EVENT_BUS.post(event);
    }

    public static class LiquidSpilledEvent
    extends LiquidEvent {
        public LiquidSpilledEvent(LiquidStack liquid, yc world, int x2, int y, int z2) {
            super(liquid, world, x2, y, z2);
        }
    }

    public static class LiquidDrainingEvent
    extends LiquidEvent {
        public final ILiquidTank tank;

        public LiquidDrainingEvent(LiquidStack liquid, yc world, int x2, int y, int z2, ILiquidTank tank) {
            super(liquid, world, x2, y, z2);
            this.tank = tank;
        }
    }

    public static class LiquidFillingEvent
    extends LiquidEvent {
        public final ILiquidTank tank;

        public LiquidFillingEvent(LiquidStack liquid, yc world, int x2, int y, int z2, ILiquidTank tank) {
            super(liquid, world, x2, y, z2);
            this.tank = tank;
        }
    }

    public static class LiquidMotionEvent
    extends LiquidEvent {
        public LiquidMotionEvent(LiquidStack liquid, yc world, int x2, int y, int z2) {
            super(liquid, world, x2, y, z2);
        }
    }
}

