/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class OreDictionary {
    private static boolean hasInit = false;
    private static int maxID = 0;
    private static HashMap<String, Integer> oreIDs = new HashMap();
    private static HashMap<Integer, ArrayList<ur>> oreStacks = new HashMap();

    public static void initVanillaEntries() {
        if (!hasInit) {
            OreDictionary.registerOre("logWood", new ur(amq.M, 1, -1));
            OreDictionary.registerOre("plankWood", new ur(amq.A, 1, -1));
            OreDictionary.registerOre("slabWood", new ur((amq)amq.bR, 1, -1));
            OreDictionary.registerOre("stairWood", amq.aw);
            OreDictionary.registerOre("stairWood", amq.ca);
            OreDictionary.registerOre("stairWood", amq.cb);
            OreDictionary.registerOre("stairWood", amq.bZ);
            OreDictionary.registerOre("stickWood", up.D);
            OreDictionary.registerOre("treeSapling", new ur(amq.B, 1, -1));
            OreDictionary.registerOre("treeLeaves", new ur((amq)((Object)amq.N), 1, -1));
        }
        HashMap<ur, String> replacements = new HashMap<ur, String>();
        replacements.put(new ur(amq.A, 1, -1), "plankWood");
        replacements.put(new ur(up.D), "stickWood");
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        for (int i2 = 0; i2 < 16; ++i2) {
            ur dye = new ur(up.aW, 1, i2);
            if (!hasInit) {
                OreDictionary.registerOre(dyes[i2], dye);
            }
            replacements.put(dye, dyes[i2]);
        }
        hasInit = true;
        ur[] replaceStacks = replacements.keySet().toArray(new ur[replacements.keySet().size()]);
        ur[] exclusions = new ur[]{new ur(amq.R), new ur(up.bc)};
        List recipes = wn.a().b();
        ArrayList<Object> recipesToRemove = new ArrayList<Object>();
        ArrayList<Object> recipesToAdd = new ArrayList<Object>();
        for (Object obj : recipes) {
            ur output;
            wq recipe;
            if (obj instanceof wq) {
                recipe = (wq)obj;
                output = recipe.b();
                if (output != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.d, replaceStacks)) continue;
                recipesToRemove.add(recipe);
                recipesToAdd.add(new ShapedOreRecipe(recipe, replacements));
                continue;
            }
            if (!(obj instanceof wr) || (output = (recipe = (wr)obj).b()) != null && OreDictionary.containsMatch(false, exclusions, output) || !OreDictionary.containsMatch(true, recipe.b.toArray(new ur[recipe.b.size()]), replaceStacks)) continue;
            recipesToRemove.add((wp)obj);
            ShapelessOreRecipe newRecipe = new ShapelessOreRecipe((wr)recipe, replacements);
            recipesToAdd.add(newRecipe);
        }
        recipes.removeAll(recipesToRemove);
        recipes.addAll(recipesToAdd);
        if (recipesToRemove.size() > 0) {
            System.out.println("Replaced " + recipesToRemove.size() + " ore recipies");
        }
    }

    public static int getOreID(String name) {
        Integer val = oreIDs.get(name);
        if (val == null) {
            val = maxID++;
            oreIDs.put(name, val);
            oreStacks.put(val, new ArrayList());
        }
        return val;
    }

    public static String getOreName(int id) {
        for (Map.Entry<String, Integer> entry : oreIDs.entrySet()) {
            if (id != entry.getValue()) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static int getOreID(ur itemStack) {
        if (itemStack == null) {
            return -1;
        }
        for (Map.Entry<Integer, ArrayList<ur>> ore : oreStacks.entrySet()) {
            for (ur target : ore.getValue()) {
                if (itemStack.c != target.c || target.j() != -1 && itemStack.j() != target.j()) continue;
                return ore.getKey();
            }
        }
        return -1;
    }

    public static ArrayList<ur> getOres(String name) {
        return OreDictionary.getOres(OreDictionary.getOreID(name));
    }

    public static String[] getOreNames() {
        return oreIDs.keySet().toArray(new String[oreIDs.keySet().size()]);
    }

    public static ArrayList<ur> getOres(Integer id) {
        ArrayList<Object> val = oreStacks.get(id);
        if (val == null) {
            val = new ArrayList();
            oreStacks.put(id, val);
        }
        return val;
    }

    private static boolean containsMatch(boolean strict, ur[] inputs, ur ... targets) {
        for (ur input : inputs) {
            for (ur target : targets) {
                if (!OreDictionary.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(ur target, ur input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.c == input.c && (target.j() == -1 && !strict || target.j() == input.j());
    }

    public static void registerOre(String name, up ore) {
        OreDictionary.registerOre(name, new ur(ore));
    }

    public static void registerOre(String name, amq ore) {
        OreDictionary.registerOre(name, new ur(ore));
    }

    public static void registerOre(String name, ur ore) {
        OreDictionary.registerOre(name, OreDictionary.getOreID(name), ore);
    }

    public static void registerOre(int id, up ore) {
        OreDictionary.registerOre(id, new ur(ore));
    }

    public static void registerOre(int id, amq ore) {
        OreDictionary.registerOre(id, new ur(ore));
    }

    public static void registerOre(int id, ur ore) {
        OreDictionary.registerOre(OreDictionary.getOreName(id), id, ore);
    }

    private static void registerOre(String name, int id, ur ore) {
        ArrayList<ur> ores = OreDictionary.getOres(id);
        ore = ore.l();
        ores.add(ore);
        MinecraftForge.EVENT_BUS.post(new OreRegisterEvent(name, ore));
    }

    static {
        OreDictionary.initVanillaEntries();
    }

    public static class OreRegisterEvent
    extends Event {
        public final String Name;
        public final ur Ore;

        public OreRegisterEvent(String name, ur ore) {
            this.Name = name;
            this.Ore = ore;
        }
    }
}

