/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.libraries;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ICodec;
import paulscode.sound.Library;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.Source;
import paulscode.sound.libraries.ChannelJavaSound;
import paulscode.sound.libraries.LibraryJavaSound$Exception;
import paulscode.sound.libraries.LibraryJavaSound$MixerRanking;
import paulscode.sound.libraries.SourceJavaSound;

@SideOnly(value=Side.CLIENT)
public class LibraryJavaSound
extends Library {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final int XXX = 0;
    private final int maxClipSize = 0x100000;
    private static Mixer myMixer = null;
    private static LibraryJavaSound$MixerRanking myMixerRanking = null;
    private static LibraryJavaSound instance = null;
    private static int minSampleRate = 4000;
    private static int maxSampleRate = 48000;
    private static int lineCount = 32;
    private static boolean useGainControl = true;
    private static boolean usePanControl = true;
    private static boolean useSampleRateControl = true;

    public LibraryJavaSound() {
        instance = this;
    }

    /*
     * WARNING - void declaration
     */
    public void init() {
        LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking = null;
        if (myMixer == null) {
            for (Mixer.Info info : AudioSystem.getMixerInfo()) {
                if (!info.getName().equals("Java Sound Audio Engine")) continue;
                libraryJavaSound$MixerRanking = new LibraryJavaSound$MixerRanking();
                try {
                    libraryJavaSound$MixerRanking.rank(info);
                }
                catch (LibraryJavaSound$Exception libraryJavaSound$Exception) {
                    break;
                }
                if (libraryJavaSound$MixerRanking.rank < 14) break;
                myMixer = AudioSystem.getMixer(info);
                LibraryJavaSound.mixerRanking(true, libraryJavaSound$MixerRanking);
                break;
            }
            if (myMixer == null) {
                void var2_4;
                LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking2 = libraryJavaSound$MixerRanking;
                for (Mixer.Info info : AudioSystem.getMixerInfo()) {
                    libraryJavaSound$MixerRanking = new LibraryJavaSound$MixerRanking();
                    try {
                        libraryJavaSound$MixerRanking.rank(info);
                    }
                    catch (LibraryJavaSound$Exception libraryJavaSound$Exception) {
                        // empty catch block
                    }
                    if (var2_4 != null && libraryJavaSound$MixerRanking.rank <= var2_4.rank) continue;
                    LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking3 = libraryJavaSound$MixerRanking;
                }
                if (var2_4 == null) {
                    throw new LibraryJavaSound$Exception("No useable mixers found!", new LibraryJavaSound$MixerRanking());
                }
                try {
                    myMixer = AudioSystem.getMixer(var2_4.mixerInfo);
                    LibraryJavaSound.mixerRanking(true, (LibraryJavaSound$MixerRanking)var2_4);
                }
                catch (Exception exception) {
                    throw new LibraryJavaSound$Exception("No useable mixers available!", new LibraryJavaSound$MixerRanking());
                }
            }
        }
        this.setMasterVolume(1.0f);
        this.message("JavaSound initialized.");
        super.init();
    }

    public static boolean libraryCompatible() {
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            if (!info.getName().equals("Java Sound Audio Engine")) continue;
            return true;
        }
        return false;
    }

    protected Channel createChannel(int n) {
        return new ChannelJavaSound(n, myMixer);
    }

    public void cleanup() {
        super.cleanup();
        instance = null;
        myMixer = null;
        myMixerRanking = null;
    }

    public boolean loadSound(FilenameURL filenameURL) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(filenameURL == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(filenameURL.getFilename()) != null) {
            return true;
        }
        ICodec iCodec = SoundSystemConfig.getCodec(filenameURL.getFilename());
        if (this.errorCheck(iCodec == null, "No codec found for file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        URL uRL = filenameURL.getURL();
        if (this.errorCheck(uRL == null, "Unable to open file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.initialize(uRL);
        SoundBuffer soundBuffer = iCodec.readAll();
        iCodec.cleanup();
        iCodec = null;
        if (soundBuffer != null) {
            this.bufferMap.put(filenameURL.getFilename(), soundBuffer);
        } else {
            this.errorMessage("Sound buffer null in method 'loadSound'");
        }
        return true;
    }

    public boolean loadSound(SoundBuffer soundBuffer, String string) {
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(string == null, "Identifier not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(string) != null) {
            return true;
        }
        if (soundBuffer != null) {
            this.bufferMap.put(string, soundBuffer);
        } else {
            this.errorMessage("Sound buffer null in method 'loadSound'");
        }
        return true;
    }

    public void setMasterVolume(float f2) {
        super.setMasterVolume(f2);
        Set set = this.sourceMap.keySet();
        for (String string : set) {
            Source source = (Source)this.sourceMap.get(string);
            if (source == null) continue;
            source.positionChanged();
        }
    }

    public void newSource(boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, float f2, float f3, float f4, int n, float f5) {
        SoundBuffer soundBuffer = null;
        if (!bl2) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!bl2 && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(string, new SourceJavaSound(this.listener, bl, bl2, bl3, string, filenameURL, soundBuffer, f2, f3, f4, n, f5, false));
    }

    public void rawDataStream(AudioFormat audioFormat, boolean bl, String string, float f2, float f3, float f4, int n, float f5) {
        this.sourceMap.put(string, new SourceJavaSound(this.listener, audioFormat, bl, string, f2, f3, f4, n, f5));
    }

    public void quickPlay(boolean bl, boolean bl2, boolean bl3, String string, FilenameURL filenameURL, float f2, float f3, float f4, int n, float f5, boolean bl4) {
        SoundBuffer soundBuffer = null;
        if (!bl2) {
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage("Source '" + string + "' was not created " + "because an error occurred while loading " + filenameURL.getFilename());
                return;
            }
            soundBuffer = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (soundBuffer == null) {
                this.errorMessage("Source '" + string + "' was not created " + "because audio data was not found for " + filenameURL.getFilename());
                return;
            }
        }
        if (!bl2 && soundBuffer != null) {
            soundBuffer.trimData(0x100000);
        }
        this.sourceMap.put(string, new SourceJavaSound(this.listener, bl, bl2, bl3, string, filenameURL, soundBuffer, f2, f3, f4, n, f5, bl4));
    }

    public void copySources(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'copySources'");
        }
        this.sourceMap.clear();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Source source = (Source)hashMap.get(string);
            if (source == null) continue;
            SoundBuffer soundBuffer = null;
            if (!source.toStream) {
                this.loadSound(source.filenameURL);
                soundBuffer = (SoundBuffer)this.bufferMap.get(source.filenameURL.getFilename());
            }
            if (!source.toStream && soundBuffer != null) {
                soundBuffer.trimData(0x100000);
            }
            if (!source.toStream && soundBuffer == null) continue;
            this.sourceMap.put(string, new SourceJavaSound(this.listener, source, soundBuffer));
        }
    }

    public void setListenerVelocity(float f2, float f3, float f4) {
        super.setListenerVelocity(f2, f3, f4);
        this.listenerMoved();
    }

    public void dopplerChanged() {
        super.dopplerChanged();
        this.listenerMoved();
    }

    public static Mixer getMixer() {
        return LibraryJavaSound.mixer(false, null);
    }

    public static void setMixer(Mixer mixer) {
        LibraryJavaSound.mixer(true, mixer);
        SoundSystemException soundSystemException = SoundSystem.getLastException();
        SoundSystem.setException(null);
        if (soundSystemException != null) {
            throw soundSystemException;
        }
    }

    private static synchronized Mixer mixer(boolean bl, Mixer mixer) {
        if (bl) {
            if (mixer == null) {
                return myMixer;
            }
            LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking = new LibraryJavaSound$MixerRanking();
            try {
                libraryJavaSound$MixerRanking.rank(mixer.getMixerInfo());
            }
            catch (LibraryJavaSound$Exception libraryJavaSound$Exception) {
                SoundSystemConfig.getLogger().printStackTrace(libraryJavaSound$Exception, 1);
                SoundSystem.setException(libraryJavaSound$Exception);
            }
            myMixer = mixer;
            LibraryJavaSound.mixerRanking(true, libraryJavaSound$MixerRanking);
            if (instance != null) {
                ChannelJavaSound channelJavaSound;
                ListIterator listIterator = LibraryJavaSound.instance.normalChannels.listIterator();
                SoundSystem.setException(null);
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(mixer);
                }
                listIterator = LibraryJavaSound.instance.streamingChannels.listIterator();
                while (listIterator.hasNext()) {
                    channelJavaSound = (ChannelJavaSound)listIterator.next();
                    channelJavaSound.newMixer(mixer);
                }
            }
        }
        return myMixer;
    }

    public static LibraryJavaSound$MixerRanking getMixerRanking() {
        return LibraryJavaSound.mixerRanking(false, null);
    }

    private static synchronized LibraryJavaSound$MixerRanking mixerRanking(boolean bl, LibraryJavaSound$MixerRanking libraryJavaSound$MixerRanking) {
        if (bl) {
            myMixerRanking = libraryJavaSound$MixerRanking;
        }
        return myMixerRanking;
    }

    public static void setMinSampleRate(int n) {
        LibraryJavaSound.minSampleRate(true, n);
    }

    private static synchronized int minSampleRate(boolean bl, int n) {
        if (bl) {
            minSampleRate = n;
        }
        return minSampleRate;
    }

    public static void setMaxSampleRate(int n) {
        LibraryJavaSound.maxSampleRate(true, n);
    }

    private static synchronized int maxSampleRate(boolean bl, int n) {
        if (bl) {
            maxSampleRate = n;
        }
        return maxSampleRate;
    }

    public static void setLineCount(int n) {
        LibraryJavaSound.lineCount(true, n);
    }

    private static synchronized int lineCount(boolean bl, int n) {
        if (bl) {
            lineCount = n;
        }
        return lineCount;
    }

    public static void useGainControl(boolean bl) {
        LibraryJavaSound.useGainControl(true, bl);
    }

    private static synchronized boolean useGainControl(boolean bl, boolean bl2) {
        if (bl) {
            useGainControl = bl2;
        }
        return useGainControl;
    }

    public static void usePanControl(boolean bl) {
        LibraryJavaSound.usePanControl(true, bl);
    }

    private static synchronized boolean usePanControl(boolean bl, boolean bl2) {
        if (bl) {
            usePanControl = bl2;
        }
        return usePanControl;
    }

    public static void useSampleRateControl(boolean bl) {
        LibraryJavaSound.useSampleRateControl(true, bl);
    }

    private static synchronized boolean useSampleRateControl(boolean bl, boolean bl2) {
        if (bl) {
            useSampleRateControl = bl2;
        }
        return useSampleRateControl;
    }

    public static String getTitle() {
        return "Java Sound";
    }

    public static String getDescription() {
        return "The Java Sound API.  For more information, see http://java.sun.com/products/java-media/sound/";
    }

    public String getClassName() {
        return "LibraryJavaSound";
    }

    static /* synthetic */ int access$000(boolean bl, int n) {
        return LibraryJavaSound.minSampleRate(bl, n);
    }

    static /* synthetic */ int access$100(boolean bl, int n) {
        return LibraryJavaSound.maxSampleRate(bl, n);
    }

    static /* synthetic */ int access$200(boolean bl, int n) {
        return LibraryJavaSound.lineCount(bl, n);
    }

    static /* synthetic */ boolean access$300(boolean bl, boolean bl2) {
        return LibraryJavaSound.useGainControl(bl, bl2);
    }

    static /* synthetic */ boolean access$400(boolean bl, boolean bl2) {
        return LibraryJavaSound.usePanControl(bl, bl2);
    }

    static /* synthetic */ boolean access$500(boolean bl, boolean bl2) {
        return LibraryJavaSound.useSampleRateControl(bl, bl2);
    }
}

