/*
 * Decompiled with CFR 0.152.
 */
package ic2.bcIntegration32x.core;

import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import ic2.api.IElectricItem;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.machine.tileentity.TileEntityElectricMachine;
import ic2.core.block.wiring.TileEntityElectricBlock;
import ic2.core.item.ElectricItem;

public class TriggerCapacitor
extends Trigger {
    int action = 0;

    public TriggerCapacitor(int id, int action) {
        super(id);
        this.action = action;
    }

    public String getTextureFile() {
        return "/ic2/sprites/bctriggers.png";
    }

    public int getIndexInTexture() {
        switch (this.action) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 16;
            }
            case 5: {
                return 17;
            }
            case 6: {
                return 18;
            }
            case 7: {
                return 21;
            }
            case 8: {
                return 19;
            }
            case 9: {
                return 20;
            }
        }
        return 0;
    }

    public String getDescription() {
        switch (this.action) {
            case 0: {
                return "Capacitor Empty";
            }
            case 1: {
                return "Capacitor Has Energy";
            }
            case 2: {
                return "Space For Energy";
            }
            case 3: {
                return "Capacitor Full";
            }
            case 4: {
                return "Charging Empty Item";
            }
            case 5: {
                return "Charging Partially Charged Item";
            }
            case 6: {
                return "Charging Fully Charged Item";
            }
            case 7: {
                return "Discharging Empty Item";
            }
            case 8: {
                return "Discharging Partially Charged Item";
            }
            case 9: {
                return "Discharging Fully Charged Item";
            }
        }
        return "This shouldn't happen";
    }

    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEntityElectricMachine) {
            TileEntityElectricMachine teb = (TileEntityElectricMachine)tile;
            boolean hasEnergy = teb.energy >= teb.maxInput;
            boolean hasRoom = teb.energy <= teb.maxEnergy - teb.maxInput;
            boolean dischargeEnergy = this.canDischarge(teb.inventory[1]);
            boolean dischargeRoom = this.canCharge(teb.inventory[1]);
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 7: {
                    return !dischargeEnergy;
                }
                case 8: {
                    return dischargeEnergy && dischargeRoom;
                }
                case 9: {
                    return !dischargeRoom;
                }
            }
        } else if (tile instanceof TileEntityBaseGenerator) {
            TileEntityBaseGenerator teb = (TileEntityBaseGenerator)tile;
            boolean hasEnergy = teb.storage > 0;
            boolean hasRoom = teb.storage < teb.maxStorage;
            boolean chargeEnergy = this.canDischarge(teb.inventory[0]);
            boolean chargeRoom = this.canCharge(teb.inventory[0]);
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 4: {
                    return !chargeEnergy;
                }
                case 5: {
                    return chargeEnergy && chargeRoom;
                }
                case 6: {
                    return !chargeRoom;
                }
            }
        } else if (tile instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock teb = (TileEntityElectricBlock)tile;
            boolean hasEnergy = teb.energy >= teb.output;
            boolean hasRoom = teb.energy < teb.maxStorage;
            boolean chargeEnergy = this.canDischarge(teb.inventory[0]);
            boolean chargeRoom = this.canCharge(teb.inventory[0]);
            boolean dischargeEnergy = this.canDischarge(teb.inventory[1]);
            boolean dischargeRoom = this.canCharge(teb.inventory[1]);
            switch (this.action) {
                case 0: {
                    return !hasEnergy;
                }
                case 1: {
                    return hasEnergy;
                }
                case 2: {
                    return hasRoom;
                }
                case 3: {
                    return !hasRoom;
                }
                case 4: {
                    return !chargeEnergy;
                }
                case 5: {
                    return chargeEnergy && chargeRoom;
                }
                case 6: {
                    return !chargeRoom;
                }
                case 7: {
                    return !dischargeEnergy;
                }
                case 8: {
                    return dischargeEnergy && dischargeRoom;
                }
                case 9: {
                    return !dischargeRoom;
                }
            }
        }
        return false;
    }

    private IElectricItem getElectricItem(ur itemStack) {
        if (itemStack == null) {
            return null;
        }
        up item = itemStack.b();
        if (item instanceof IElectricItem) {
            return (IElectricItem)item;
        }
        return null;
    }

    private boolean canDischarge(ur itemStack) {
        IElectricItem electricItem = this.getElectricItem(itemStack);
        if (electricItem == null) {
            return false;
        }
        return ElectricItem.discharge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) > 0;
    }

    private boolean canCharge(ur itemStack) {
        IElectricItem electricItem = this.getElectricItem(itemStack);
        if (electricItem == null) {
            return false;
        }
        return ElectricItem.charge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) > 0;
    }
}

