/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import cpw.mods.fml.relauncher.ReflectionHelper;
import ic2.core.ContainerIC2;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.machine.ContainerMiner;
import ic2.core.block.machine.tileentity.TileEntityElecMachine;
import ic2.core.block.machine.tileentity.TileEntityPump;
import ic2.core.item.ElectricItem;
import ic2.core.item.tool.ItemElectricToolDDrill;
import ic2.core.item.tool.ItemElectricToolDrill;
import ic2.core.item.tool.ItemScanner;
import ic2.core.util.StackUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ISidedInventory;

public class TileEntityMiner
extends TileEntityElecMachine
implements IHasGui,
ISidedInventory {
    public int targetX = 0;
    public int targetY = -1;
    public int targetZ = 0;
    public short miningTicker = 0;
    public String stuckOn = null;
    private AudioSource audioSource;

    public TileEntityMiner() {
        super(4, 0, 1000, 32, IC2.enableMinerLapotron ? 3 : 1);
    }

    @Override
    public void g() {
        super.g();
        boolean wasOperating = this.isOperating();
        boolean needsInvUpdate = false;
        if (this.isOperating()) {
            --this.energy;
            if (this.inventory[1] != null && up.e[this.inventory[1].c] instanceof ItemScanner) {
                this.energy -= ElectricItem.charge(this.inventory[1], this.energy, 2, false, false);
            }
            if (this.inventory[3] != null && (up.e[this.inventory[3].c] instanceof ItemElectricToolDrill || up.e[this.inventory[3].c] instanceof ItemElectricToolDDrill)) {
                this.energy -= ElectricItem.charge(this.inventory[3], this.energy, 1, false, false);
            }
        }
        if (this.energy <= this.maxEnergy) {
            needsInvUpdate = this.provideEnergy();
        }
        if (wasOperating) {
            needsInvUpdate = this.mine();
        } else if (this.inventory[3] == null) {
            if (this.energy >= 2 && this.canWithdraw()) {
                this.targetY = -1;
                this.miningTicker = (short)(this.miningTicker + 1);
                this.energy -= 2;
                if (this.miningTicker >= 20) {
                    this.miningTicker = 0;
                    needsInvUpdate = this.withdrawPipe();
                }
            } else if (this.isStuck()) {
                this.miningTicker = 0;
            }
        }
        this.setActive(this.isOperating());
        if (wasOperating != this.isOperating()) {
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            this.d();
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.targetX = nbttagcompound.e("targetX");
        this.targetY = nbttagcompound.e("targetY");
        this.targetZ = nbttagcompound.e("targetZ");
        this.miningTicker = nbttagcompound.d("miningTicker");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("targetX", (int)((short)this.targetX));
        nbttagcompound.a("targetY", (int)((short)this.targetY));
        nbttagcompound.a("targetZ", (int)((short)this.targetZ));
        nbttagcompound.a("miningTicker", this.miningTicker);
    }

    public boolean mine() {
        if (this.targetY < 0) {
            this.aquireTarget();
            return false;
        }
        if (!this.canReachTarget(this.targetX, this.targetY, this.targetZ, true)) {
            int x = this.targetX - this.l;
            int z = this.targetZ - this.n;
            if (Math.abs(x) > Math.abs(z)) {
                this.targetX = x > 0 ? --this.targetX : ++this.targetX;
            } else {
                this.targetZ = z > 0 ? --this.targetZ : ++this.targetZ;
            }
            return false;
        }
        if (!this.canMine(this.targetX, this.targetY, this.targetZ)) {
            int id = this.k.a(this.targetX, this.targetY, this.targetZ);
            if ((id == amq.D.cm || id == amq.E.cm || id == amq.F.cm || id == amq.G.cm) && this.isAnyPumpConnected()) {
                return false;
            }
            this.miningTicker = (short)-1;
            this.stuckOn = amq.p[id].B();
            return false;
        }
        this.stuckOn = null;
        this.miningTicker = (short)(this.miningTicker + 1);
        --this.energy;
        if (this.inventory[3].c == Ic2Items.diamondDrill.c) {
            this.miningTicker = (short)(this.miningTicker + 3);
            this.energy -= 14;
        }
        if (this.miningTicker >= 200) {
            this.miningTicker = 0;
            this.mineBlock();
            return true;
        }
        return false;
    }

    public void mineBlock() {
        if (this.inventory[3].b() instanceof ItemElectricToolDrill) {
            ElectricItem.use(this.inventory[3], 50, null);
        } else if (this.inventory[3].b() instanceof ItemElectricToolDDrill) {
            ElectricItem.use(this.inventory[3], 80, null);
        }
        int id = this.k.a(this.targetX, this.targetY, this.targetZ);
        int meta = this.k.h(this.targetX, this.targetY, this.targetZ);
        boolean liquid = false;
        if (id == amq.D.cm || id == amq.E.cm || id == amq.F.cm || id == amq.G.cm) {
            liquid = true;
            if (meta != 0) {
                id = 0;
            }
        }
        if (id != 0) {
            if (!liquid) {
                amq ore = amq.p[id];
                StackUtil.distributeDrop(this, ore.getBlockDropped(this.k, this.targetX, this.targetY, this.targetZ, meta, xe.a((int)xc.u.z, (ur)this.inventory[3])));
            } else {
                if (id == amq.D.cm || id == amq.E.cm) {
                    this.usePump(amq.E.cm);
                }
                if (id == amq.F.cm || id == amq.G.cm) {
                    this.usePump(amq.G.cm);
                }
            }
            this.k.e(this.targetX, this.targetY, this.targetZ, 0);
            this.energy -= 2 * (this.m - this.targetY);
        }
        if (this.targetX == this.l && this.targetZ == this.n) {
            this.k.b(this.targetX, this.targetY, this.targetZ, Ic2Items.miningPipe.c);
            if (this.inventory[2].a == 0) {
                this.inventory[2] = null;
            }
            this.energy -= 10;
        }
        this.updateMineTip(this.targetY);
        this.targetY = -1;
    }

    public boolean withdrawPipe() {
        int y = this.getPipeTip();
        int blockId = this.k.a(this.l, y, this.n);
        if (blockId != 0) {
            StackUtil.distributeDrop(this, amq.p[blockId].getBlockDropped(this.k, this.l, y, this.n, this.k.h(this.l, y, this.n), 0));
            this.k.e(this.l, y, this.n, 0);
        }
        if (this.inventory[2] != null && this.inventory[2].c != Ic2Items.miningPipe.c && this.inventory[2].c < amq.p.length && amq.p[this.inventory[2].c] != null && amq.p[this.inventory[2].c].cm != 0) {
            this.k.d(this.l, y, this.n, this.inventory[2].c, this.inventory[2].j());
            --this.inventory[2].a;
            if (this.inventory[2].a == 0) {
                this.inventory[2] = null;
            }
            this.updateMineTip(y + 1);
            return true;
        }
        this.updateMineTip(y + 1);
        return false;
    }

    public void updateMineTip(int low) {
        if (low == this.m) {
            return;
        }
        int x = this.l;
        int z = this.n;
        for (int y = this.m - 1; y > low; --y) {
            int id = this.k.a(x, y, z);
            if (id == Ic2Items.miningPipe.c || this.inventory[2] == null || this.inventory[2].a <= 0) continue;
            this.k.e(x, y, z, Ic2Items.miningPipe.c);
            --this.inventory[2].a;
            if (this.inventory[2].a > 0) continue;
            this.inventory[2] = null;
        }
        this.k.e(x, low, z, Ic2Items.miningPipeTip.c);
    }

    public boolean canReachTarget(int x, int y, int z, boolean ignore) {
        if (this.l == x && this.n == z) {
            return true;
        }
        if (!ignore && !this.canPass(this.k.a(x, y, z))) {
            return false;
        }
        int xdif = x - this.l;
        int zdif = z - this.n;
        if (Math.abs(xdif) > Math.abs(zdif)) {
            x = xdif > 0 ? --x : ++x;
        } else {
            z = zdif > 0 ? --z : ++z;
        }
        return this.canReachTarget(x, y, z, false);
    }

    public void aquireTarget() {
        int y = this.getPipeTip();
        if (y >= this.m || this.inventory[1] == null || !(this.inventory[1].b() instanceof ItemScanner)) {
            this.setTarget(this.l, y - 1, this.n);
            return;
        }
        int scanrange = ((ItemScanner)this.inventory[1].b()).startLayerScan(this.inventory[1]);
        if (scanrange > 0) {
            for (int x = this.l - scanrange; x <= this.l + scanrange; ++x) {
                for (int z = this.n - scanrange; z <= this.n + scanrange; ++z) {
                    int m;
                    int n = this.k.a(x, y, z);
                    if ((!ItemScanner.isValuable(n, m = this.k.h(x, y, z)) || !this.canMine(x, y, z)) && (!this.isAnyPumpConnected() || this.k.h(x, y, z) != 0 || n != amq.F.cm && n != amq.G.cm)) continue;
                    this.setTarget(x, y, z);
                    return;
                }
            }
        }
        this.setTarget(this.l, y - 1, this.n);
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public int getPipeTip() {
        int y = this.m;
        while (this.k.a(this.l, y - 1, this.n) == Ic2Items.miningPipe.c || this.k.a(this.l, y - 1, this.n) == Ic2Items.miningPipeTip.c) {
            --y;
        }
        return y;
    }

    public boolean canPass(int id) {
        return id == 0 || id == amq.D.cm || id == amq.E.cm || id == amq.F.cm || id == amq.G.cm || id == Ic2Items.miner.c || id == Ic2Items.miningPipe.c || id == Ic2Items.miningPipeTip.c;
    }

    public boolean isOperating() {
        return this.energy > 100 && this.canOperate();
    }

    public boolean canOperate() {
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return false;
        }
        if (this.inventory[2].c != Ic2Items.miningPipe.c) {
            return false;
        }
        if (this.inventory[3].c != Ic2Items.miningDrill.c && this.inventory[3].c != Ic2Items.diamondDrill.c) {
            return false;
        }
        return !this.isStuck();
    }

    public boolean isStuck() {
        return this.miningTicker < 0;
    }

    public String getStuckOn() {
        return this.stuckOn;
    }

    public boolean canMine(int x, int y, int z) {
        int id = this.k.a(x, y, z);
        int meta = this.k.h(x, y, z);
        if (id == 0) {
            return true;
        }
        if (id == Ic2Items.miningPipe.c || id == Ic2Items.miningPipeTip.c || id == amq.ax.cm) {
            return false;
        }
        if ((id == amq.D.cm || id == amq.E.cm || id == amq.F.cm || id == amq.G.cm) && this.isPumpConnected()) {
            return true;
        }
        amq block = amq.p[id];
        if (block.m(this.k, x, y, z) < 0.0f) {
            return false;
        }
        if (block.a(meta, false) && block.cB.l()) {
            return true;
        }
        if (id == amq.Z.cm) {
            return true;
        }
        if (this.inventory[3] != null && (this.inventory[3].c != Ic2Items.miningDrill.c || this.inventory[3].c != Ic2Items.diamondDrill.c)) {
            try {
                HashMap toolClasses = (HashMap)ReflectionHelper.getPrivateValue(ForgeHooks.class, null, (String[])new String[]{"toolClasses"});
                List tc = (List)toolClasses.get(this.inventory[3].c);
                if (tc == null) {
                    return this.inventory[3].b(block);
                }
                Object[] ta = tc.toArray();
                String cls = (String)ta[0];
                int hvl = (Integer)ta[1];
                HashMap toolHarvestLevels = (HashMap)ReflectionHelper.getPrivateValue(ForgeHooks.class, null, (String[])new String[]{"toolHarvestLevels"});
                Integer bhl = (Integer)toolHarvestLevels.get(Arrays.asList(block.cm, meta, cls));
                if (bhl == null) {
                    return this.inventory[3].b(block);
                }
                if (bhl > hvl) {
                    return false;
                }
                return this.inventory[3].b(block);
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }

    public boolean canWithdraw() {
        return this.k.a(this.l, this.m - 1, this.n) == Ic2Items.miningPipe.c || this.k.a(this.l, this.m - 1, this.n) == Ic2Items.miningPipeTip.c;
    }

    public boolean isPumpConnected() {
        if (this.k.q(this.l, this.m + 1, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l, this.m + 1, this.n)).canHarvest()) {
            return true;
        }
        if (this.k.q(this.l, this.m - 1, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l, this.m - 1, this.n)).canHarvest()) {
            return true;
        }
        if (this.k.q(this.l + 1, this.m, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l + 1, this.m, this.n)).canHarvest()) {
            return true;
        }
        if (this.k.q(this.l - 1, this.m, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l - 1, this.m, this.n)).canHarvest()) {
            return true;
        }
        if (this.k.q(this.l, this.m, this.n + 1) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l, this.m, this.n + 1)).canHarvest()) {
            return true;
        }
        return this.k.q(this.l, this.m, this.n - 1) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l, this.m, this.n - 1)).canHarvest();
    }

    public boolean isAnyPumpConnected() {
        if (this.k.q(this.l, this.m + 1, this.n) instanceof TileEntityPump) {
            return true;
        }
        if (this.k.q(this.l, this.m - 1, this.n) instanceof TileEntityPump) {
            return true;
        }
        if (this.k.q(this.l + 1, this.m, this.n) instanceof TileEntityPump) {
            return true;
        }
        if (this.k.q(this.l - 1, this.m, this.n) instanceof TileEntityPump) {
            return true;
        }
        if (this.k.q(this.l, this.m, this.n + 1) instanceof TileEntityPump) {
            return true;
        }
        return this.k.q(this.l, this.m, this.n - 1) instanceof TileEntityPump;
    }

    public void usePump(int id) {
        if (this.k.q(this.l, this.m + 1, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l, this.m + 1, this.n)).canHarvest()) {
            ((TileEntityPump)this.k.q(this.l, this.m + 1, this.n)).pumpThis(id);
            return;
        }
        if (this.k.q(this.l, this.m - 1, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l, this.m - 1, this.n)).canHarvest()) {
            ((TileEntityPump)this.k.q(this.l, this.m - 1, this.n)).pumpThis(id);
            return;
        }
        if (this.k.q(this.l + 1, this.m, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l + 1, this.m, this.n)).canHarvest()) {
            ((TileEntityPump)this.k.q(this.l + 1, this.m, this.n)).pumpThis(id);
            return;
        }
        if (this.k.q(this.l - 1, this.m, this.n) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l - 1, this.m, this.n)).canHarvest()) {
            ((TileEntityPump)this.k.q(this.l - 1, this.m, this.n)).pumpThis(id);
            return;
        }
        if (this.k.q(this.l, this.m, this.n + 1) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l, this.m, this.n + 1)).canHarvest()) {
            ((TileEntityPump)this.k.q(this.l, this.m, this.n + 1)).pumpThis(id);
            return;
        }
        if (this.k.q(this.l, this.m, this.n - 1) instanceof TileEntityPump && ((TileEntityPump)this.k.q(this.l, this.m, this.n - 1)).canHarvest()) {
            ((TileEntityPump)this.k.q(this.l, this.m, this.n - 1)).pumpThis(id);
            return;
        }
    }

    @Override
    public String b() {
        return "Miner";
    }

    public int gaugeEnergyScaled(int i) {
        if (this.energy <= 0) {
            return 0;
        }
        int r = this.energy * i / 1000;
        if (r > i) {
            r = i;
        }
        return r;
    }

    @Override
    public ContainerIC2 getGuiContainer(qx entityPlayer) {
        return new ContainerMiner(entityPlayer, this);
    }

    @Override
    public String getGuiClassName(qx entityPlayer) {
        return "block.machine.gui.GuiMiner";
    }

    @Override
    public void onGuiClosed(qx entityPlayer) {
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/MinerOp.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    public int getStartInventorySide(ForgeDirection side) {
        ForgeDirection backSide;
        ForgeDirection frontSide;
        ForgeDirection rightSide;
        ForgeDirection leftSide;
        switch (this.getFacing()) {
            case 2: {
                leftSide = ForgeDirection.WEST;
                rightSide = ForgeDirection.EAST;
                frontSide = ForgeDirection.SOUTH;
                backSide = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                leftSide = ForgeDirection.EAST;
                rightSide = ForgeDirection.WEST;
                frontSide = ForgeDirection.NORTH;
                backSide = ForgeDirection.SOUTH;
                break;
            }
            case 4: {
                leftSide = ForgeDirection.SOUTH;
                rightSide = ForgeDirection.NORTH;
                frontSide = ForgeDirection.EAST;
                backSide = ForgeDirection.WEST;
                break;
            }
            default: {
                leftSide = ForgeDirection.NORTH;
                rightSide = ForgeDirection.SOUTH;
                frontSide = ForgeDirection.WEST;
                backSide = ForgeDirection.EAST;
            }
        }
        if (side == leftSide || side == frontSide) {
            return 3;
        }
        if (side == rightSide || side == backSide) {
            return 1;
        }
        switch (side) {
            case DOWN: {
                return 0;
            }
        }
        return 2;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }
}

