/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.Direction;
import ic2.api.IEnergyStorage;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.audio.AudioPosition;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.TileEntityBlock;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class TileEntityTeleporter
extends TileEntityBlock
implements INetworkTileEntityEventListener {
    private static final Direction[] directions = Direction.values();
    public boolean targetSet = false;
    public int targetX;
    public int targetY;
    public int targetZ;
    private AudioSource audioSource = null;
    private static final int EventTeleport = 0;

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.targetSet = nbttagcompound.n("targetSet");
        this.targetX = nbttagcompound.e("targetX");
        this.targetY = nbttagcompound.e("targetY");
        this.targetZ = nbttagcompound.e("targetZ");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("targetSet", this.targetSet);
        nbttagcompound.a("targetX", this.targetX);
        nbttagcompound.a("targetY", this.targetY);
        nbttagcompound.a("targetZ", this.targetZ);
    }

    @Override
    public boolean enableUpdateEntity() {
        return true;
    }

    public void g() {
        super.g();
        if (IC2.platform.isSimulating()) {
            if (this.k.B(this.l, this.m, this.n) && this.targetSet) {
                boolean prevWorldChunkLoadOverride = this.k.z;
                this.k.z = true;
                zz chunk = this.k.I().d(this.targetX >> 4, this.targetZ >> 4);
                this.k.z = prevWorldChunkLoadOverride;
                if (chunk == null || chunk.a(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.c || chunk.c(this.targetX & 0xF, this.targetY, this.targetZ & 0xF) != Ic2Items.teleporter.j()) {
                    this.targetSet = false;
                    this.setActive(false);
                } else {
                    this.setActive(true);
                    List entitiesNearby = this.k.a(lq.class, aoe.a((double)(this.l - 1), (double)this.m, (double)(this.n - 1), (double)(this.l + 2), (double)(this.m + 3), (double)(this.n + 2)));
                    if (!entitiesNearby.isEmpty()) {
                        double minDistanceSquared = Double.MAX_VALUE;
                        lq closestEntity = null;
                        for (lq entity : entitiesNearby) {
                            double distSquared;
                            if (entity.o != null || !((distSquared = ((double)this.l - entity.t) * ((double)this.l - entity.t) + ((double)(this.m + 1) - entity.u) * ((double)(this.m + 1) - entity.u) + ((double)this.n - entity.v) * ((double)this.n - entity.v)) < minDistanceSquared)) continue;
                            minDistanceSquared = distSquared;
                            closestEntity = entity;
                        }
                        this.teleport(closestEntity);
                    }
                }
            } else {
                this.setActive(false);
            }
        }
        if (IC2.platform.isRendering() && this.getActive()) {
            this.spawnBlueParticles(2, this.l, this.m, this.n);
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public void teleport(lq user) {
        double distance = Math.sqrt((this.l - this.targetX) * (this.l - this.targetX) + (this.m - this.targetY) * (this.m - this.targetY) + (this.n - this.targetZ) * (this.n - this.targetZ));
        int weight = this.getWeightOf(user);
        if (weight == 0) {
            return;
        }
        int energyCost = (int)((double)weight * Math.pow(distance + 10.0, 0.7) * 5.0);
        if (energyCost > this.getAvailableEnergy()) {
            return;
        }
        this.consumeEnergy(energyCost);
        if (user instanceof iq) {
            ((iq)user).a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.W(), (double)this.targetZ + 0.5);
        } else {
            user.a((double)this.targetX + 0.5, (double)this.targetY + 1.5 + user.W(), (double)this.targetZ + 0.5, user.z, user.A);
        }
        IC2.network.initiateTileEntityEvent(this, 0, true);
        if (user instanceof qx && distance >= 1000.0) {
            IC2.achievements.issueAchievement((qx)user, "teleportFarAway");
        }
    }

    public void spawnBlueParticles(int n, int x, int y, int z) {
        for (int i = 0; i < n; ++i) {
            this.k.a("reddust", (double)((float)x + this.k.t.nextFloat()), (double)((float)(y + 1) + this.k.t.nextFloat()), (double)((float)z + this.k.t.nextFloat()), -1.0, 0.0, 1.0);
            this.k.a("reddust", (double)((float)x + this.k.t.nextFloat()), (double)((float)(y + 2) + this.k.t.nextFloat()), (double)((float)z + this.k.t.nextFloat()), -1.0, 0.0, 1.0);
        }
    }

    public void consumeEnergy(int energy) {
        LinkedList<IEnergyStorage> energySources = new LinkedList<IEnergyStorage>();
        for (Direction direction : directions) {
            IEnergyStorage energySource;
            any target = direction.applyToTileEntity(this);
            if (!(target instanceof IEnergyStorage) || !(energySource = (IEnergyStorage)target).isTeleporterCompatible(direction.getInverse()) || energySource.getStored() <= 0) continue;
            energySources.add(energySource);
        }
        while (energy > 0) {
            int drain = (energy + energySources.size() - 1) / energySources.size();
            Iterator it2 = energySources.iterator();
            while (it2.hasNext()) {
                IEnergyStorage energySource = (IEnergyStorage)it2.next();
                if (drain > energy) {
                    drain = energy;
                }
                if (energySource.getStored() <= drain) {
                    energy -= energySource.getStored();
                    energySource.setStored(0);
                    it2.remove();
                    continue;
                }
                energy -= drain;
                energySource.addEnergy(-drain);
            }
        }
    }

    public int getAvailableEnergy() {
        int energy = 0;
        for (Direction direction : directions) {
            IEnergyStorage storage;
            any target = direction.applyToTileEntity(this);
            if (!(target instanceof IEnergyStorage) || !(storage = (IEnergyStorage)target).isTeleporterCompatible(direction.getInverse())) continue;
            energy += storage.getStored();
        }
        return energy;
    }

    public int getWeightOf(lq user) {
        int weight = 0;
        lq ce2 = user;
        while (ce2 != null) {
            int i;
            if (ce2 instanceof px) {
                ur is = ((px)ce2).d();
                weight += 100 * is.a / is.d();
            } else if (ce2 instanceof ox || ce2 instanceof py || ce2 instanceof pv) {
                weight += 100;
            } else if (ce2 instanceof qx) {
                weight += 1000;
                if (IC2.enableTeleporterInventory) {
                    qw inv = ((qx)ce2).bJ;
                    for (i = 0; i < inv.a.length; ++i) {
                        if (inv.a[i] == null) continue;
                        weight += 100 * inv.a[i].a / inv.a[i].d();
                    }
                }
            } else if (ce2 instanceof qg) {
                weight += 2500;
            } else if (ce2 instanceof pp) {
                weight += 10000;
            } else if (ce2 instanceof mi) {
                weight += 500;
            }
            if (IC2.enableTeleporterInventory && ce2 instanceof md) {
                md living = (md)ce2;
                int n = i = ce2 instanceof qx ? 1 : 0;
                while (i <= 4) {
                    ur item = living.p(i);
                    if (item != null) {
                        weight += 100 * item.a / item.d();
                    }
                    ++i;
                }
            }
            ce2 = ce2.n;
        }
        return weight;
    }

    public void setTarget(int x, int y, int z) {
        this.targetSet = true;
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        IC2.network.updateTileEntityField(this, "targetX");
        IC2.network.updateTileEntityField(this, "targetY");
        IC2.network.updateTileEntityField(this, "targetZ");
    }

    @Override
    public List getNetworkedFields() {
        Vector<String> ret = new Vector<String>(3);
        ret.add("targetX");
        ret.add("targetY");
        ret.add("targetZ");
        ret.addAll(super.getNetworkedFields());
        return ret;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("active") && this.prevActive != this.getActive()) {
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, "Machines/Teleporter/TeleChargedLoop.ogg", true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                IC2.audioManager.playOnce(this, PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, IC2.audioManager.defaultVolume);
                IC2.audioManager.playOnce(new AudioPosition(this.k, (float)this.targetX + 0.5f, (float)this.targetY + 0.5f, (float)this.targetZ + 0.5f), PositionSpec.Center, "Machines/Teleporter/TeleUse.ogg", true, IC2.audioManager.defaultVolume);
                this.spawnBlueParticles(20, this.l, this.m, this.n);
                this.spawnBlueParticles(20, this.targetX, this.targetY, this.targetZ);
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\n" + "T: " + this + " (" + this.l + "," + this.m + "," + this.n + ")");
            }
        }
    }
}

