/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.IMetalArmor;
import ic2.core.IC2;
import ic2.core.IC2Potion;
import ic2.core.Ic2Items;
import ic2.core.item.ElectricItem;
import ic2.core.item.ItemTinCan;
import ic2.core.item.armor.ItemArmorElectric;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class ItemArmorQuantumSuit
extends ItemArmorElectric
implements IMetalArmor {
    private static final int[] potionRemovalCost = new int[ll.a.length];
    public static Map speedTickerMap = new HashMap();
    public static Map jumpChargeMap = new HashMap();
    public static Map enableQuantumSpeedOnSprintMap = new HashMap();

    public ItemArmorQuantumSuit(int id, int index, int armorrendering, int armorType) {
        super(id, index, armorrendering, armorType, 1000000, 1000, 3);
        if (armorType == 3) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(md player, ur armor, lh source, double damage, int slot) {
        if (source == lh.h && this.a == 3) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = energyPerDamage > 0 ? 25 * ElectricItem.discharge(armor, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true) / energyPerDamage : 0;
            return new ISpecialArmor.ArmorProperties(10, 1.0, damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @ForgeSubscribe
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (IC2.platform.isSimulating() && event.entity instanceof qx) {
            qx player = (qx)event.entity;
            ur armor = player.bJ.b[0];
            if (armor != null && armor.c == this.cj) {
                int fallDamage = (int)event.distance - 3;
                int energyCost = this.getEnergyPerDamage() * fallDamage;
                if (energyCost <= ElectricItem.discharge(armor, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true)) {
                    ElectricItem.discharge(armor, energyCost, Integer.MAX_VALUE, true, false);
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public double getDamageAbsorptionRatio() {
        if (this.a == 1) {
            return 1.1;
        }
        return 1.0;
    }

    @Override
    public int getEnergyPerDamage() {
        return 900;
    }

    @Override
    public boolean isMetalArmor(ur itemstack, qx player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public vb f(ur stack) {
        return vb.c;
    }

    public void onArmorTickUpdate(yc world, qx player, ur itemStack) {
        boolean ret = false;
        switch (this.a) {
            case 0: {
                IC2.platform.profilerStartSection("QuantumHelmet");
                int air = player.al();
                if (ElectricItem.canUse(itemStack, 1000) && air < 100) {
                    player.f(air + 200);
                    ElectricItem.use(itemStack, 1000, null);
                    ret = true;
                } else if (air <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                if (ElectricItem.canUse(itemStack, 1000) && player.cc().c()) {
                    int slot = -1;
                    for (int i = 0; i < player.bJ.a.length; ++i) {
                        if (player.bJ.a[i] == null || player.bJ.a[i].c != Ic2Items.filledTinCan.c) continue;
                        slot = i;
                        break;
                    }
                    if (slot > -1) {
                        ItemTinCan can = (ItemTinCan)player.bJ.a[slot].b();
                        player.cc().a(can.g(), can.h());
                        can.c(player.bJ.a[slot], player.p, player);
                        can.onEaten(player);
                        if (--player.bJ.a[slot].a <= 0) {
                            player.bJ.a[slot] = null;
                        }
                        ElectricItem.use(itemStack, 1000, null);
                        ret = true;
                    }
                } else if (player.cc().a() <= 0) {
                    IC2.achievements.issueAchievement(player, "starveWithQHelmet");
                }
                for (lm effect : new LinkedList(player.bz())) {
                    int cost = potionRemovalCost[effect.a()];
                    if (cost <= 0 || !ElectricItem.canUse(itemStack, cost *= effect.c() + 1)) continue;
                    ElectricItem.use(itemStack, cost, null);
                    IC2.platform.removePotion((md)player, effect.a());
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 1: {
                IC2.platform.profilerStartSection("QuantumBodyarmor");
                player.B();
                IC2.platform.profilerEndSection();
                break;
            }
            case 2: {
                IC2.platform.profilerStartSection("QuantumLeggings");
                boolean enableQuantumSpeedOnSprint = true;
                if (IC2.platform.isRendering()) {
                    enableQuantumSpeedOnSprint = IC2.enableQuantumSpeedOnSprint;
                } else if (enableQuantumSpeedOnSprintMap.containsKey(player)) {
                    enableQuantumSpeedOnSprint = (Boolean)enableQuantumSpeedOnSprintMap.get(player);
                }
                if (ElectricItem.canUse(itemStack, 1000) && (player.E && Math.abs(player.w) + Math.abs(player.y) > (double)0.1f || player.H()) && (enableQuantumSpeedOnSprint && player.ai() || !enableQuantumSpeedOnSprint && IC2.keyboard.isBoostKeyDown(player))) {
                    int speedTicker;
                    int n = speedTicker = speedTickerMap.containsKey(player) ? (Integer)speedTickerMap.get(player) : 0;
                    if (++speedTicker >= 10) {
                        speedTicker = 0;
                        ElectricItem.use(itemStack, 1000, null);
                        ret = true;
                    }
                    speedTickerMap.put(player, speedTicker);
                    float speed = 0.22f;
                    if (player.H()) {
                        speed = 0.1f;
                        if (player.bF) {
                            player.x += (double)0.1f;
                        }
                    }
                    if (speed > 0.0f) {
                        player.a(0.0f, 1.0f, speed);
                    }
                }
                IC2.platform.profilerEndSection();
                break;
            }
            case 3: {
                float jumpCharge;
                IC2.platform.profilerStartSection("QuantumBoots");
                float f = jumpCharge = jumpChargeMap.containsKey(player) ? ((Float)jumpChargeMap.get(player)).floatValue() : 1.0f;
                if (ElectricItem.canUse(itemStack, 1000) && player.E && jumpCharge < 1.0f) {
                    jumpCharge = 1.0f;
                    ElectricItem.use(itemStack, 1000, null);
                    ret = true;
                }
                if (player.x >= 0.0 && jumpCharge > 0.0f && !player.H()) {
                    if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isBoostKeyDown(player)) {
                        if (jumpCharge == 1.0f) {
                            player.w *= 3.5;
                            player.y *= 3.5;
                        }
                        player.x += (double)(jumpCharge * 0.3f);
                        jumpCharge = (float)((double)jumpCharge * 0.75);
                    } else if (jumpCharge < 1.0f) {
                        jumpCharge = 0.0f;
                    }
                }
                jumpChargeMap.put(player, Float.valueOf(jumpCharge));
                IC2.platform.profilerEndSection();
            }
        }
        if (ret) {
            player.bK.b();
        }
    }

    public static void removePlayerReferences(qx player) {
        speedTickerMap.remove(player);
        jumpChargeMap.remove(player);
        enableQuantumSpeedOnSprintMap.remove(player);
    }

    static {
        ItemArmorQuantumSuit.potionRemovalCost[ll.u.H] = 10000;
        ItemArmorQuantumSuit.potionRemovalCost[IC2Potion.radiation.H] = 10000;
        ItemArmorQuantumSuit.potionRemovalCost[ll.v.H] = 25000;
    }
}

