/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.api.IReactor;
import ic2.api.IReactorComponent;
import ic2.core.item.ItemGradual;
import ic2.core.util.StackUtil;

public class ItemReactorHeatStorage
extends ItemGradual
implements IReactorComponent {
    public int heatStorage;

    public ItemReactorHeatStorage(int id, int index, int heatStorage) {
        super(id, index);
        this.heatStorage = heatStorage;
    }

    @Override
    public void processChamber(IReactor reactor, ur yourStack, int x, int y) {
    }

    @Override
    public boolean acceptUraniumPulse(IReactor reactor, ur yourStack, ur pulsingStack, int youX, int youY, int pulseX, int pulseY) {
        return false;
    }

    @Override
    public boolean canStoreHeat(IReactor reactor, ur yourStack, int x, int y) {
        return true;
    }

    @Override
    public int getMaxHeat(IReactor reactor, ur yourStack, int x, int y) {
        return this.heatStorage;
    }

    @Override
    public int getCurrentHeat(IReactor reactor, ur yourStack, int x, int y) {
        return this.getHeatOfStack(yourStack);
    }

    @Override
    public int alterHeat(IReactor reactor, ur yourStack, int x, int y, int heat) {
        int myHeat = this.getHeatOfStack(yourStack);
        if ((myHeat += heat) > this.heatStorage) {
            reactor.setItemAt(x, y, null);
            heat = this.heatStorage - myHeat + 1;
        } else {
            if (myHeat < 0) {
                heat = myHeat;
                myHeat = 0;
            } else {
                heat = 0;
            }
            this.setHeatForStack(yourStack, myHeat);
        }
        return heat;
    }

    @Override
    public float influenceExplosion(IReactor reactor, ur yourStack) {
        return 0.0f;
    }

    private void setHeatForStack(ur stack, int heat) {
        bq nbtData = StackUtil.getOrCreateNbtData(stack);
        nbtData.a("heat", heat);
        if (this.heatStorage > 0) {
            double p = (double)heat / (double)this.heatStorage;
            int newDmg = (int)((double)stack.k() * p);
            if (newDmg >= stack.k()) {
                newDmg = stack.k() - 1;
            }
            stack.b(newDmg);
        }
    }

    private int getHeatOfStack(ur stack) {
        bq nbtData = StackUtil.getOrCreateNbtData(stack);
        return nbtData.e("heat");
    }
}

