/*
 * Decompiled with CFR 0.152.
 */
package ic2.neiIntegration.core;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.core.Ic2Items;
import ic2.core.item.ItemScrapbox;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ScrapboxRecipeHandler
extends TemplateRecipeHandler {
    public static DecimalFormat liquidAmountFormat = new DecimalFormat("0.##%");
    public static PositionedStack scrapboxPositionedStack = new PositionedStack((Object)Ic2Items.scrapBox, 51, 24);

    public String getRecipeName() {
        return "Scrapbox";
    }

    public String getRecipeId() {
        return "ic2.scrapbox";
    }

    public String getGuiTexture() {
        return "/ic2/sprites/ScrapboxRecipes.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        Float chance = ((CachedScrapboxRecipe)((Object)this.arecipes.get((int)recipe))).chance;
        String costString = liquidAmountFormat.format(chance);
        gui.drawTextCentered(costString, 85, 11, -8355712, false);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 25, 16), this.getRecipeId(), new Object[0]));
    }

    protected List getRecipeList() {
        Vector result = new Vector();
        List input = null;
        input = ItemScrapbox.getDropList();
        float total = ((Float)((Map.Entry)input.get(input.size() - 1)).getValue()).floatValue();
        float lastValue = 0.0f;
        for (Map.Entry entry : input) {
            result.add(new AbstractMap.SimpleEntry(entry.getKey(), Float.valueOf((((Float)entry.getValue()).floatValue() - lastValue) / total)));
            lastValue = ((Float)entry.getValue()).floatValue();
        }
        return result;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry irecipe : this.getRecipeList()) {
                this.arecipes.add(new CachedScrapboxRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ur result) {
        for (Map.Entry irecipe : this.getRecipeList()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ur)((ur)irecipe.getKey()), (ur)result)) continue;
            this.arecipes.add(new CachedScrapboxRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        if (NEIServerUtils.areStacksSameTypeCrafting((ur)Ic2Items.scrapBox, (ur)ingredient)) {
            for (Map.Entry irecipe : this.getRecipeList()) {
                this.arecipes.add(new CachedScrapboxRecipe(irecipe));
            }
        }
    }

    public boolean hasOverlay(avf gui, rq container, int recipe) {
        return false;
    }

    public class CachedScrapboxRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack output;
        public Float chance;

        public PositionedStack getIngredient() {
            return scrapboxPositionedStack;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedScrapboxRecipe(Map.Entry entry) {
            super((TemplateRecipeHandler)ScrapboxRecipeHandler.this);
            this.output = new PositionedStack(entry.getKey(), 111, 24);
            this.chance = (Float)entry.getValue();
        }
    }
}

