/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.network.PacketAdditionalPipes;
import buildcraft.api.core.LaserKind;
import buildcraft.core.Box;
import com.google.common.collect.ImmutableSetMultimap;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoadViewDataProxy
implements IScheduledTickHandler,
Comparator {
    public static final int MAX_SIGHT_RANGE = 31;
    private int sightRange;
    private List lasers;
    private xv[] persistentChunks;
    private boolean active = false;

    public ChunkLoadViewDataProxy(int chunkSightRange) {
        this.setSightRange(chunkSightRange);
        this.lasers = new LinkedList();
        this.persistentChunks = new xv[0];
        this.active = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void toggleLasers() {
        if (this.lasersActive()) {
            this.deactivateLasers();
        } else {
            this.activateLasers();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void activateLasers() {
        this.deactivateLasers();
        ays player = FMLClientHandler.instance().getClient().g;
        int playerY = (int)player.u - 1;
        for (xv coords : this.persistentChunks) {
            int xCoord = coords.a * 16;
            int zCoord = coords.b * 16;
            Box outsideLaser = new Box();
            outsideLaser.initialize(xCoord, playerY, zCoord, xCoord + 16, playerY, zCoord + 16);
            outsideLaser.createLasers(player.p, LaserKind.Blue);
            this.lasers.add(outsideLaser);
            outsideLaser = new Box();
            outsideLaser.initialize(xCoord, playerY - 20, zCoord, xCoord + 16, playerY - 20, zCoord + 16);
            outsideLaser.createLasers(player.p, LaserKind.Blue);
            this.lasers.add(outsideLaser);
            outsideLaser = new Box();
            outsideLaser.initialize(xCoord, playerY + 20, zCoord, xCoord + 16, playerY + 20, zCoord + 16);
            outsideLaser.createLasers(player.p, LaserKind.Blue);
            this.lasers.add(outsideLaser);
            Box insideLaser = new Box();
            insideLaser.initialize(xCoord + 7, playerY, zCoord + 7, xCoord + 9, playerY, zCoord + 9);
            insideLaser.createLasers(player.p, LaserKind.Red);
            this.lasers.add(insideLaser);
            insideLaser = new Box();
            insideLaser.initialize(xCoord + 7, playerY - 20, zCoord + 7, xCoord + 9, playerY - 20, zCoord + 9);
            insideLaser.createLasers(player.p, LaserKind.Red);
            this.lasers.add(insideLaser);
            insideLaser = new Box();
            insideLaser.initialize(xCoord + 7, playerY + 20, zCoord + 7, xCoord + 9, playerY + 20, zCoord + 9);
            insideLaser.createLasers(player.p, LaserKind.Red);
            this.lasers.add(insideLaser);
        }
        this.active = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void deactivateLasers() {
        for (Box laser : this.lasers) {
            laser.deleteLasers();
        }
        this.lasers.clear();
        this.active = false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean lasersActive() {
        return this.active;
    }

    @SideOnly(value=Side.CLIENT)
    public void requestPersistentChunks() {
        PacketAdditionalPipes packet = new PacketAdditionalPipes(65, false);
        PacketDispatcher.sendPacketToServer((ef)packet.makePacket());
    }

    @SideOnly(value=Side.CLIENT)
    public void receivePersistentChunks(xv[] chunks) {
        boolean changed = true;
        if (this.persistentChunks.length == chunks.length) {
            changed = false;
            Arrays.sort(chunks, this);
            Arrays.sort(this.persistentChunks, this);
            for (int i = 0; i < chunks.length; ++i) {
                if (chunks[i].equals((Object)this.persistentChunks[i])) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.persistentChunks = chunks;
            if (this.active) {
                this.activateLasers();
            }
        }
    }

    public void setSightRange(int range) {
        this.sightRange = range;
        if (this.sightRange > 31) {
            this.sightRange = 31;
        }
    }

    public void sendPersistentChunksToPlayer(iq player) {
        if (!AdditionalPipes.instance.chunkSight) {
            return;
        }
        if (this.sightRange > 31) {
            this.sightRange = 31;
        }
        ImmutableSetMultimap persistentChunks = ForgeChunkManager.getPersistentChunksFor((yc)player.p);
        LinkedList<xv> chunksInRange = new LinkedList<xv>();
        int playerX = ((int)player.t >> 4) - this.sightRange / 2;
        int playerZ = ((int)player.v >> 4) - this.sightRange / 2;
        for (int i = -this.sightRange; i <= this.sightRange; ++i) {
            for (int j = -this.sightRange; j <= this.sightRange; ++j) {
                xv coords = new xv(playerX + i, playerZ + j);
                if (!persistentChunks.containsKey((Object)coords)) continue;
                chunksInRange.add(coords);
            }
        }
        PacketAdditionalPipes packet = new PacketAdditionalPipes(15, false);
        packet.writeInt(chunksInRange.size());
        for (xv coords : chunksInRange) {
            packet.writeInt(coords.a);
            packet.writeInt(coords.b);
        }
        player.a.b((ef)packet.makePacket());
        AdditionalPipes.instance.logger.info("[ChunkLoadViewDataProxy] Sent chunks within " + this.sightRange + " of player.");
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    @SideOnly(value=Side.CLIENT)
    public void tickEnd(EnumSet type, Object ... tickData) {
        if (AdditionalPipes.instance.chunkSightAutorefresh && this.lasersActive()) {
            this.requestPersistentChunks();
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT);
    }

    public String getLabel() {
        return this.getClass().getSimpleName();
    }

    public int nextTickSpacing() {
        return 100;
    }

    public int compare(xv first, xv other) {
        int dx = first.a - other.a;
        return dx != 0 ? dx : first.b - other.b;
    }
}

