/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.pipes.logic.PipeLogicTeleport;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsTeleport
extends PipeTeleport
implements IPipeTransportItemsHook {
    private PipeTransportItems transport;

    public PipeItemsTeleport(int itemID) {
        super((PipeTransport)new PipeTransportItems(), new PipeLogicTeleport(), itemID);
        this.transport = (PipeTransportItems)((PipeTeleport)this).transport;
    }

    public void readjustSpeed(IPipedItem item) {
        this.transport.defaultReajustSpeed(item);
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
        if (!AdditionalPipes.proxy.isServer(this.worldObj)) {
            return;
        }
        List connectedTeleportPipes = TeleportManager.instance.getConnectedPipes(this, false);
        if (connectedTeleportPipes.size() <= 0) {
            return;
        }
        LinkedList<ForgeDirection> outputOrientations = new LinkedList<ForgeDirection>();
        PipeTeleport otherPipe = (PipeTeleport)((Object)connectedTeleportPipes.get(rand.nextInt(connectedTeleportPipes.size())));
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!otherPipe.outputOpen(o)) continue;
            outputOrientations.add(o);
        }
        if (outputOrientations.size() <= 0) {
            return;
        }
        ForgeDirection newOrientation = (ForgeDirection)outputOrientations.get(rand.nextInt(outputOrientations.size()));
        TileGenericPipe destination = (TileGenericPipe)otherPipe.container.getTile(newOrientation);
        item.setPosition((double)destination.l + 0.5, (double)destination.m, (double)destination.n + 0.5);
        destination.pipe.transport.entityEntering(item, newOrientation);
        AdditionalPipes.instance.logger.info(item + " from " + this.getPosition() + " to " + otherPipe.getPosition() + " " + newOrientation);
    }

    @Override
    public int getTextureIndex(ForgeDirection direction) {
        return 0;
    }
}

