/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes.logic;

import buildcraft.BuildCraftTransport;
import buildcraft.additionalpipes.AdditionalPipes;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import java.util.Arrays;
import net.minecraftforge.common.ForgeDirection;

public class PipeLogicTeleport
extends PipeLogic {
    private Pipe pipe;
    private boolean[] phasedBroadcastSignal = new boolean[4];
    private int frequency = 0;
    public boolean canReceive = false;
    public String owner = "";
    public boolean isPublic = false;

    public void setTile(TileGenericPipe tile) {
        super.setTile(tile);
        this.pipe = this.container.pipe;
    }

    public boolean blockActivated(qx player) {
        if (!AdditionalPipes.proxy.isServer(player.p)) {
            return true;
        }
        if (this.owner == null || "".equalsIgnoreCase(this.owner)) {
            this.owner = player.bR;
        }
        ur equippedItem = player.bS();
        player.openGui((Object)AdditionalPipes.instance, 1, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    public void updateEntity() {
        super.updateEntity();
        this.updatePhasedSignals();
    }

    public void setFrequency(int freq) {
        this.removePhasedSignals();
        this.frequency = freq;
        this.phasedBroadcastSignal = new boolean[4];
        this.updatePhasedSignals();
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void removePhasedSignals() {
        for (int i = 0; i < this.phasedBroadcastSignal.length; ++i) {
            if (!this.phasedBroadcastSignal[i]) continue;
            Integer[] integerArray = (Integer[])TeleportManager.instance.phasedSignals.get(this.frequency);
            int n = i;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] - 1);
            AdditionalPipes.instance.logger.info("Removing signal " + this.frequency + " : " + i);
        }
    }

    public void updatePhasedSignals() {
        if (!TeleportManager.instance.phasedSignals.containsKey(this.frequency)) {
            Object[] signals = new Integer[4];
            Arrays.fill(signals, (Object)0);
            TeleportManager.instance.phasedSignals.put(this.frequency, signals);
        }
        for (int i = 0; i < this.pipe.broadcastSignal.length; ++i) {
            if (this.phasedBroadcastSignal[i] == this.pipe.broadcastSignal[i]) continue;
            Integer[] integerArray = (Integer[])TeleportManager.instance.phasedSignals.get(this.frequency);
            int n = i;
            Integer.valueOf(integerArray[n] + (this.pipe.broadcastSignal[i] ? 1 : -1));
            AdditionalPipes.instance.logger.info((this.pipe.broadcastSignal[i] ? "Adding signal " : "Removing signal ") + this.frequency + " : " + i);
            this.phasedBroadcastSignal[i] = this.pipe.broadcastSignal[i];
        }
    }

    public boolean isPipeConnected(any tile) {
        Pipe pipe = null;
        if (tile instanceof TileGenericPipe) {
            pipe = ((TileGenericPipe)tile).pipe;
        }
        if (BuildCraftTransport.alwaysConnectPipes) {
            return super.isPipeConnected(tile);
        }
        if (pipe != null && ((Object)((Object)this)).getClass().equals(pipe.logic.getClass())) {
            return false;
        }
        return pipe != null;
    }

    public boolean outputOpen(ForgeDirection to) {
        return this.isPipeConnected(this.container.getTile(to));
    }

    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("freq", this.frequency);
        nbttagcompound.a("canReceive", this.canReceive);
        nbttagcompound.a("owner", this.owner);
        nbttagcompound.a("isPublic", this.isPublic);
    }

    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.frequency = nbttagcompound.e("freq");
        this.canReceive = nbttagcompound.n("canReceive");
        this.owner = nbttagcompound.i("owner");
        this.isPublic = nbttagcompound.n("isPublic");
    }

    public static boolean canPlayerModifyPipe(qx player, PipeLogicTeleport logic) {
        return logic.isPublic || logic.owner.equals(player.bR) || player.cd.d;
    }
}

