/*
 * Decompiled with CFR 0.152.
 */
package abo;

import abo.ABOConfiguration;
import abo.actions.ActionSwitchOnPipe;
import abo.actions.ActionToggleOffPipe;
import abo.actions.ActionToggleOnPipe;
import abo.items.ItemGateSettingsDuplicator;
import abo.pipes.items.PipeItemsBounce;
import abo.pipes.items.PipeItemsCrossover;
import abo.pipes.items.PipeItemsExtraction;
import abo.pipes.items.PipeItemsInsertion;
import abo.pipes.items.PipeItemsRoundRobin;
import abo.pipes.items.PipeItemsStripes;
import abo.pipes.liquids.PipeLiquidsBalance;
import abo.pipes.liquids.PipeLiquidsDiamond;
import abo.pipes.liquids.PipeLiquidsGoldenIron;
import abo.pipes.liquids.PipeLiquidsValve;
import abo.pipes.power.PipePowerDiamond;
import abo.pipes.power.PipePowerIron;
import abo.pipes.power.PipePowerSwitch;
import abo.proxy.ABOProxy;
import abo.triggers.ABOTriggerProvider;
import abo.triggers.TriggerEngineControl;
import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.gates.Trigger;
import buildcraft.core.utils.Localization;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.blueprints.BptItemPipeDiamond;
import buildcraft.transport.blueprints.BptItemPipeIron;
import buildcraft.transport.blueprints.BptItemPipeWooden;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Logger;
import net.minecraftforge.common.Property;

@Mod(modid="Additional-Buildcraft-Objects", name="Additional-Buildcraft-Objects", version="1.0.2", dependencies="required-after:BuildCraft|Transport;required-after:BuildCraft|Energy")
public class ABO {
    public static final String VERSION = "1.0.2";
    public static ABOConfiguration aboConfiguration;
    public static Logger aboLog;
    public static String texturePipes;
    public static String textureTriggers;
    public static String textureItems;
    public static int itemGateSettingsDuplicatorID;
    public static up itemGateSettingsDuplicator;
    public static int pipeLiquidsValveID;
    public static up pipeLiquidsValve;
    public static int pipeLiquidsGoldenIronID;
    public static up pipeLiquidsGoldenIron;
    public static int pipeLiquidsBalanceID;
    public static up pipeLiquidsBalance;
    public static int pipeLiquidsDiamondID;
    public static up pipeLiquidsDiamond;
    public static int pipeItemsRoundRobinID;
    public static up pipeItemsRoundRobin;
    public static int pipeItemsInsertionID;
    public static up pipeItemsInsertion;
    public static int pipeItemsExtractionID;
    public static up pipeItemsExtraction;
    public static int pipeItemsBounceID;
    public static up pipeItemsBounce;
    public static int pipeItemsCrossoverID;
    public static up pipeItemsCrossover;
    public static int pipeItemsStripesID;
    public static up pipeItemsStripes;
    public static int pipePowerSwitchID;
    public static up pipePowerSwitch;
    public static int pipePowerIronID;
    public static up pipePowerIron;
    public static int pipePowerDiamondID;
    public static up pipePowerDiamond;
    public static int triggerEngineControlID;
    public static Trigger triggerEngineControl;
    public static int actionSwitchOnPipeID;
    public static IAction actionSwitchOnPipe;
    public static int actionToggleOnPipeID;
    public static IAction actionToggleOnPipe;
    public static int actionToggleOffPipeID;
    public static IAction actionToggleOffPipe;
    @Mod.Instance(value="Additional-Buildcraft-Objects")
    public static ABO instance;
    private static LinkedList aboRecipes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.PreInit
    public void preInitialize(FMLPreInitializationEvent evt) {
        aboLog.setParent(FMLLog.getLogger());
        aboLog.info("Starting Additional-Buildcraft-Objects #108 1.0.2 (Built for Minecraft 1.4.7 with Buildcraft 3.4.2 and Forge 6.6.0.515");
        aboLog.info("Copyright (c) Flow86, 2011-2012");
        aboConfiguration = new ABOConfiguration(new File(evt.getModConfigurationDirectory(), "abo/main.conf"));
        try {
            aboConfiguration.load();
            itemGateSettingsDuplicator = ABO.createItem(itemGateSettingsDuplicatorID, ItemGateSettingsDuplicator.class, "Gate Settings Duplicator", BuildCraftCore.wrenchItem, BuildCraftTransport.pipeGateAutarchic, null);
            pipeLiquidsValve = ABO.createPipe(pipeLiquidsValveID, PipeLiquidsValve.class, "Valve Pipe", 1, BuildCraftTransport.pipeLiquidsWood, BuildCraftTransport.pipeGateAutarchic, null);
            pipeLiquidsGoldenIron = ABO.createPipe(pipeLiquidsGoldenIronID, PipeLiquidsGoldenIron.class, "Golden Iron Waterproof Pipe", 1, BuildCraftTransport.pipeLiquidsGold, BuildCraftTransport.pipeLiquidsIron, null);
            pipeLiquidsBalance = ABO.createPipe(pipeLiquidsBalanceID, PipeLiquidsBalance.class, "Balancing Waterproof Pipe", 1, BuildCraftTransport.pipeLiquidsWood, new ur((amq)BuildCraftEnergy.engineBlock, 1, 0), BuildCraftTransport.pipeLiquidsWood);
            pipeLiquidsDiamond = ABO.createPipe(pipeLiquidsDiamondID, PipeLiquidsDiamond.class, "Diamond Waterproof Pipe", 1, BuildCraftTransport.pipeItemsDiamond, BuildCraftTransport.pipeWaterproof, null);
            pipeItemsRoundRobin = ABO.createPipe(pipeItemsRoundRobinID, PipeItemsRoundRobin.class, "RoundRobin Transport Pipe", 1, BuildCraftTransport.pipeItemsStone, amq.I, null);
            pipeItemsInsertion = ABO.createPipe(pipeItemsInsertionID, PipeItemsInsertion.class, "Insertion Pipe", 1, BuildCraftTransport.pipeItemsCobblestone, up.aC, null);
            pipeItemsExtraction = ABO.createPipe(pipeItemsExtractionID, PipeItemsExtraction.class, "Extraction Transport Pipe", 1, BuildCraftTransport.pipeItemsWood, amq.A, null);
            pipeItemsBounce = ABO.createPipe(pipeItemsBounceID, PipeItemsBounce.class, "Bounce Transport Pipe", 1, BuildCraftTransport.pipeItemsStone, amq.z, null);
            pipeItemsCrossover = ABO.createPipe(pipeItemsCrossoverID, PipeItemsCrossover.class, "Crossover Transport Pipe", 1, BuildCraftTransport.pipeItemsStone, BuildCraftTransport.pipeItemsIron, null);
            pipeItemsStripes = ABO.createPipe(pipeItemsStripesID, PipeItemsStripes.class, "Stripes Transport Pipe", 8, new ur(up.aW, 1, 0), amq.P, new ur(up.aW, 1, 11));
            pipePowerSwitch = ABO.createPipe(pipePowerSwitchID, PipePowerSwitch.class, "Power Switch Pipe", 1, BuildCraftTransport.pipePowerGold, amq.aM, null);
            pipePowerIron = ABO.createPipe(pipePowerIronID, PipePowerIron.class, "Iron Power Pipe", 1, up.aC, BuildCraftTransport.pipeItemsIron, null);
            pipePowerDiamond = ABO.createPipe(pipePowerDiamondID, PipePowerDiamond.class, "Diamond Power Pipe", 1, up.aC, BuildCraftTransport.pipeItemsDiamond, null);
            triggerEngineControl = new TriggerEngineControl(triggerEngineControlID);
            actionSwitchOnPipe = new ActionSwitchOnPipe(actionSwitchOnPipeID);
            actionToggleOnPipe = new ActionToggleOnPipe(actionToggleOnPipeID);
            actionToggleOffPipe = new ActionToggleOffPipe(actionToggleOffPipeID);
            ActionManager.registerTriggerProvider((ITriggerProvider)new ABOTriggerProvider());
            BuildCraftCore.itemBptProps[ABO.pipeItemsExtraction.cj] = new BptItemPipeWooden();
            BuildCraftCore.itemBptProps[ABO.pipeLiquidsValve.cj] = new BptItemPipeIron();
            BuildCraftCore.itemBptProps[ABO.pipeLiquidsGoldenIron.cj] = new BptItemPipeIron();
            BuildCraftCore.itemBptProps[ABO.pipeLiquidsDiamond.cj] = new BptItemPipeDiamond();
            BuildCraftCore.itemBptProps[ABO.pipePowerIron.cj] = new BptItemPipeIron();
        }
        finally {
            aboConfiguration.save();
        }
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        Localization.addLocalization((String)"/lang/abo/", (String)"en_US");
        ABOProxy.proxy.preloadTextures();
        ABORecipe recipe = new ABORecipe();
        recipe.itemID = ABO.pipeLiquidsValve.cj;
        recipe.isShapeless = true;
        recipe.result = new ur(pipeLiquidsValve, 1);
        recipe.input = new Object[]{BuildCraftTransport.pipeLiquidsWood, BuildCraftTransport.pipeGateAutarchic};
        aboRecipes.add(recipe);
        this.loadRecipes();
    }

    private static up createItem(int defaultID, Class clazz, String descr, Object ingredient1, Object ingredient2, Object ingredient3) {
        String name = Character.toLowerCase(clazz.getSimpleName().charAt(0)) + clazz.getSimpleName().substring(1);
        Property prop = aboConfiguration.getItem(name + ".id", defaultID);
        int id = prop.getInt(defaultID);
        up item = null;
        try {
            item = (up)clazz.getConstructor(Integer.TYPE).newInstance(id);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (item == null) {
            return item;
        }
        item.b(clazz.getSimpleName());
        LanguageRegistry.addName(item, (String)descr);
        ABO.addReceipe(item, 1, ingredient1, ingredient2, ingredient3);
        return item;
    }

    private static void addReceipe(up item, int count, Object ingredient1, Object ingredient2, Object ingredient3) {
        ABORecipe recipe = new ABORecipe();
        recipe.isPipe = item instanceof ItemPipe;
        recipe.itemID = item.cj;
        if (ingredient1 != null && ingredient2 != null && ingredient3 != null) {
            recipe.result = new ur(item, count);
            recipe.input = new Object[]{"ABC", Character.valueOf('A'), ingredient1, Character.valueOf('B'), ingredient2, Character.valueOf('C'), ingredient3};
            aboRecipes.add(recipe);
        } else if (ingredient1 != null && ingredient2 != null) {
            recipe.isShapeless = true;
            recipe.result = new ur(item, count);
            recipe.input = new Object[]{ingredient1, ingredient2};
            aboRecipes.add(recipe);
        }
    }

    private static up createPipe(int defaultID, Class clazz, String descr, int count, Object ingredient1, Object ingredient2, Object ingredient3) {
        String name = Character.toLowerCase(clazz.getSimpleName().charAt(0)) + clazz.getSimpleName().substring(1);
        Property prop = aboConfiguration.getItem(name + ".id", defaultID);
        int id = prop.getInt(defaultID);
        ItemPipe pipe = BlockGenericPipe.registerPipe((int)id, (Class)clazz);
        pipe.b(clazz.getSimpleName());
        LanguageRegistry.addName((Object)pipe, (String)descr);
        ABO.addReceipe((up)pipe, count, ingredient1, ingredient2, ingredient3);
        return pipe;
    }

    public void loadRecipes() {
        for (ABORecipe recipe : aboRecipes) {
            if (recipe.isShapeless) {
                GameRegistry.addShapelessRecipe((ur)recipe.result, (Object[])recipe.input);
            } else {
                GameRegistry.addRecipe((ur)recipe.result, (Object[])recipe.input);
            }
            if (!recipe.isPipe) continue;
            ABOProxy.proxy.registerPipe(recipe.itemID);
        }
    }

    static {
        aboLog = Logger.getLogger("Additional-Buildcraft-Objects");
        texturePipes = "/gfx/abo/pipes.png";
        textureTriggers = "/gfx/abo/triggers.png";
        textureItems = "/gfx/abo/items.png";
        itemGateSettingsDuplicatorID = 10100;
        itemGateSettingsDuplicator = null;
        pipeLiquidsValveID = 10200;
        pipeLiquidsValve = null;
        pipeLiquidsGoldenIronID = 10201;
        pipeLiquidsGoldenIron = null;
        pipeLiquidsBalanceID = 10203;
        pipeLiquidsBalance = null;
        pipeLiquidsDiamondID = 10204;
        pipeLiquidsDiamond = null;
        pipeItemsRoundRobinID = 10300;
        pipeItemsRoundRobin = null;
        pipeItemsInsertionID = 10302;
        pipeItemsInsertion = null;
        pipeItemsExtractionID = 10303;
        pipeItemsExtraction = null;
        pipeItemsBounceID = 10304;
        pipeItemsBounce = null;
        pipeItemsCrossoverID = 10305;
        pipeItemsCrossover = null;
        pipeItemsStripesID = 4071;
        pipeItemsStripes = null;
        pipePowerSwitchID = 10400;
        pipePowerSwitch = null;
        pipePowerIronID = 10401;
        pipePowerIron = null;
        pipePowerDiamondID = 10402;
        pipePowerDiamond = null;
        triggerEngineControlID = 128;
        triggerEngineControl = null;
        actionSwitchOnPipeID = 128;
        actionSwitchOnPipe = null;
        actionToggleOnPipeID = 129;
        actionToggleOnPipe = null;
        actionToggleOffPipeID = 130;
        actionToggleOffPipe = null;
        aboRecipes = new LinkedList();
    }

    private static class ABORecipe {
        int itemID;
        boolean isPipe = false;
        boolean isShapeless = false;
        ur result;
        Object[] input;

        private ABORecipe() {
        }
    }
}

