/*
 * Decompiled with CFR 0.152.
 */
package lol.rptweaks;

import java.util.List;
import lol.rptweaks.Log;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ClassMethodPrinter
extends ClassVisitor {
    protected String mName;
    protected String mDesc;

    public ClassMethodPrinter(ClassVisitor cv, String name, String desc) {
        super(262144, cv);
        this.mName = name;
        this.mDesc = desc;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] ex) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, sig, ex);
        if (!name.equals(this.mName) || !desc.equals(this.mDesc)) {
            return mv;
        }
        Log.info("Tracing " + name + desc);
        return new TraceMethodVisitor(mv, (Printer)new Textifier(){

            public void printText(List tx) {
                for (Object o : tx) {
                    if (o instanceof String) {
                        Log.info((String)o);
                        continue;
                    }
                    if (o instanceof List) {
                        this.printText((List)o);
                        continue;
                    }
                    Log.info("?? " + o.toString());
                }
            }

            public void visitMethodEnd() {
                super.visitMethodEnd();
                this.printText(this.text);
            }
        });
    }
}

