/*
 * Decompiled with CFR 0.152.
 */
package lol.rptweaks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import lol.rptweaks.Log;

public class Config {
    protected HashMap opts = new HashMap();

    private void load0(File f) throws IOException, FileNotFoundException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(f));
        int num = 0;
        while ((line = in.readLine()) != null) {
            this.parseLine(line, num);
            ++num;
        }
    }

    public void load(File f) {
        try {
            Log.debug("Loading configuration");
            this.load0(f);
        }
        catch (FileNotFoundException e) {
            Log.info("FileNotFoundException when loading configuration");
            Log.info("Was looking for config at " + f.getPath());
        }
        catch (IOException e) {
            Log.error("IOException when loading configuration");
            e.printStackTrace();
        }
    }

    public void parseLine(String line, int num) {
        String[] s = line.split("#", 2);
        if (s.length < 1) {
            return;
        }
        s[0] = s[0].trim();
        if (s[0].length() == 0) {
            return;
        }
        if ((s = s[0].split("[ \t\r\n]+")).length != 2) {
            Log.error("Configuration syntax error on line " + num + ". Ignoring line");
            return;
        }
        this.setOption(s[0], this.truthify(s[1], num));
    }

    public boolean truthify(String s, int num) {
        if ((s = s.toLowerCase()).equals("on") || s.equals("true") || s.equals("yes")) {
            return true;
        }
        if (s.equals("off") || s.equals("false") || s.equals("no")) {
            return false;
        }
        Log.error("Don't know how to truthify " + s + ". Assuming false.");
        return false;
    }

    public void setOption(String opt, boolean val) {
        if (this.opts.containsKey(opt)) {
            Log.error("Overwriting option value " + opt);
        }
        Log.debug((val ? "En" : "Dis") + "abling option " + opt);
        this.opts.put(opt.toLowerCase(), val);
    }

    public boolean getOption(String opt, boolean def) {
        if (!this.opts.containsKey(opt)) {
            return def;
        }
        return (Boolean)this.opts.get(opt);
    }
}

