/*
 * Decompiled with CFR 0.152.
 */
package lol.rptweaks;

import lol.rptweaks.Config;
import lol.rptweaks.Log;
import lol.rptweaks.TransformTweaks;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class TransformDuplication
extends TransformTweaks {
    @Override
    public byte[] doTransform(String name, byte[] bytes) {
        if (!(name.equals("com.eloraam.redpower.control.TileIOExpander") || name.equals("com.eloraam.redpower.control.TileBackplane") || name.equals("com.eloraam.redpower.control.TileRAM"))) {
            return null;
        }
        Log.info("Duplication transforming " + name);
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(cr, 0);
        ClassVisit ca = new ClassVisit((ClassVisitor)cw);
        cr.accept((ClassVisitor)ca, 0);
        return cw.toByteArray();
    }

    @Override
    public void config(Config conf) {
        this.setEnabled(true);
    }

    private class MethodVisitHarvestContents
    extends MethodVisitor {
        private int patchStage;

        public MethodVisitHarvestContents(MethodVisitor mv) {
            super(262144, mv);
            this.patchStage = 0;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 183 && this.patchStage == 2) {
                ++this.patchStage;
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, desc);
        }

        public void visitVarInsn(int opcode, int var) {
            if (opcode == 25 && (var == 0 && this.patchStage == 0 || var == 1 && this.patchStage == 1)) {
                ++this.patchStage;
                return;
            }
            this.mv.visitVarInsn(opcode, var);
        }
    }

    private class ClassVisit
    extends ClassVisitor {
        public ClassVisit(ClassVisitor cv) {
            super(262144, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            if (name.equals("addHarvestContents") && mv != null) {
                mv = new MethodVisitHarvestContents(mv);
            }
            return mv;
        }
    }
}

