/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.UpdateManager;
import powercrystals.netherores.NetherOresWorldGenHandler;
import powercrystals.netherores.net.ClientPacketHandler;
import powercrystals.netherores.net.ConnectionHandler;
import powercrystals.netherores.net.INetherOresProxy;
import powercrystals.netherores.net.ServerPacketHandler;
import powercrystals.netherores.ores.BlockNetherOres;
import powercrystals.netherores.ores.EntityArmedOre;
import powercrystals.netherores.ores.ItemNetherOre;
import powercrystals.netherores.ores.Ores;

@Mod(modid="NetherOres", name="Nether Ores", version="1.4.6R2.0.6", dependencies="required-after:PowerCrystalsCore;after:IC2;after:ThermalExpansion|Factory")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"NetherOres"}, packetHandler=ClientPacketHandler.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"NetherOres"}, packetHandler=ServerPacketHandler.class), connectionHandler=ConnectionHandler.class)
public class NetherOresCore
implements IUpdateableMod {
    public static final String modId = "NetherOres";
    public static final String version = "1.4.6R2.0.6";
    public static final String modName = "Nether Ores";
    public static final String terrainTexture = "/powercrystals/netherores/textures/terrain_0.png";
    public static amq blockNetherOres;
    private static Property netherOreBlockId;
    public static Property explosionPower;
    public static Property explosionProbability;
    public static Property enableExplosions;
    public static Property enableExplosionChainReactions;
    public static Property enableAngryPigmen;
    public static Property enableStandardFurnaceRecipes;
    public static Property enableMaceratorRecipes;
    public static Property enablePulverizerRecipes;
    public static Property enableInductionSmelterRecipes;
    public static Property forceOreSpawn;
    @SidedProxy(clientSide="powercrystals.netherores.net.ClientProxy", serverSide="powercrystals.netherores.net.ServerProxy")
    public static INetherOresProxy proxy;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        this.loadConfig(evt.getSuggestedConfigurationFile());
        blockNetherOres = new BlockNetherOres(Integer.parseInt(NetherOresCore.netherOreBlockId.value), 0);
    }

    @Mod.Init
    public void load(FMLInitializationEvent evt) {
        GameRegistry.registerBlock((amq)blockNetherOres, ItemNetherOre.class, (String)"netherOresBlockOres");
        GameRegistry.registerWorldGenerator((IWorldGenerator)new NetherOresWorldGenHandler());
        for (Ores o : Ores.values()) {
            o.load();
        }
        EntityRegistry.registerModEntity(EntityArmedOre.class, (String)"netherOresArmedOre", (int)0, (Object)this, (int)160, (int)5, (boolean)true);
        proxy.load();
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new UpdateManager((IUpdateableMod)this), (Side)Side.CLIENT);
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent e) {
        if (enableStandardFurnaceRecipes.getBoolean(true)) {
            Ores.coal.registerSmelting(new ur(amq.L));
            Ores.diamond.registerSmelting(new ur(amq.az));
            Ores.gold.registerSmelting(new ur(amq.J));
            Ores.iron.registerSmelting(new ur(amq.K));
            Ores.lapis.registerSmelting(new ur(amq.Q));
            Ores.redstone.registerSmelting(new ur(amq.aQ));
            Ores.emerald.registerSmelting(new ur(amq.bU));
        }
        if (enableMaceratorRecipes.getBoolean(true)) {
            Ores.diamond.registerMacerator(new ur(up.n));
            Ores.coal.registerMacerator(new ur(up.m));
            Ores.redstone.registerMacerator(new ur(up.aC));
            Ores.lapis.registerMacerator(new ur(up.aW, 1, 4));
        }
        for (String oreName : OreDictionary.getOreNames()) {
            if (OreDictionary.getOres((String)oreName).size() <= 0) continue;
            this.registerOreDictionaryEntry(oreName, (ur)OreDictionary.getOres((String)oreName).get(0));
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void registerOreDictionaryEntry(String oreName, ur stack) {
        for (Ores ore : Ores.values()) {
            if (!ore.isRegisteredSmelting() && ore.getOreName().trim().toLowerCase().equals(oreName.trim().toLowerCase())) {
                ore.registerSmelting(stack);
            }
            if (ore.isRegisteredMacerator() || !ore.getDustName().trim().toLowerCase().equals(oreName.trim().toLowerCase())) continue;
            ore.registerMacerator(stack);
        }
    }

    private void loadConfig(File f) {
        Configuration c = new Configuration(f);
        c.load();
        netherOreBlockId = c.getBlock("block", "ID.NetherOreBlock", 1440);
        explosionPower = c.get("general", "ExplosionPower", 2);
        NetherOresCore.explosionPower.comment = "How powerful an explosion will be. Creepers are 3, TNT is 4, electrified creepers are 6. This affects both the ability of the explosion to punch through blocks as well as the blast radius.";
        explosionProbability = c.get("general", "ExplosionProbability", 75);
        NetherOresCore.explosionProbability.comment = "The likelyhood an adjacent netherore will turn into an armed ore when one is mined. Percent chance out of 1000 (lower is less likely).";
        enableExplosions = c.get("general", "ExplosionEnable", true);
        NetherOresCore.enableExplosions.comment = "NetherOres have a chance to explode when mined if true.";
        enableExplosionChainReactions = c.get("general", "ExplosionChainReactEnable", true);
        NetherOresCore.enableExplosionChainReactions.comment = "NetherOre explosions can trigger more explosions if true. Does nothing if ExplosionEnable is false.";
        enableAngryPigmen = c.get("general", "AngryPigmenEnable", true);
        NetherOresCore.enableAngryPigmen.comment = "If true, when NetherOres are mined, nearby pigmen become angry to the player.";
        enableStandardFurnaceRecipes = c.get("general", "EnableStandardFurnaceRecipes", true);
        NetherOresCore.enableStandardFurnaceRecipes.comment = "Set this to false to remove the standard furnace recipes (ie, nether iron ore -> normal iron ore).";
        enableMaceratorRecipes = c.get("general", "EnableMaceratorRecipes", true);
        NetherOresCore.enableMaceratorRecipes.comment = "Set this to false to remove the IC2 Macerator recipes (ie, nether iron ore -> 4x iron dust).";
        enablePulverizerRecipes = c.get("general", "EnablePulverizerRecipes", true);
        NetherOresCore.enablePulverizerRecipes.comment = "Set this to false to remove the TE Pulvierzer recipes (ie, nether iron ore -> 4x iron dust).";
        enableInductionSmelterRecipes = c.get("general", "EnableInductionSmelterRecipes", true);
        NetherOresCore.enableInductionSmelterRecipes.comment = "Set this to false to remove the TE Induction Smelter recipes (ie, nether iron ore -> 2x normal iron ore).";
        forceOreSpawn = c.get("general", "ForceOreSpawn", false);
        NetherOresCore.forceOreSpawn.comment = "If true, will spawn nether ores regardless of if a furnace or macerator recipe was found. If false, at least one of those two must be found to spawn the ore.";
        for (Ores o : Ores.values()) {
            o.loadConfig(c);
        }
        c.save();
    }

    @ForgeSubscribe
    public void registerOreEvent(OreDictionary.OreRegisterEvent event) {
        this.registerOreDictionaryEntry(event.Name, event.Ore);
    }

    public String getModId() {
        return modId;
    }

    public String getModName() {
        return modName;
    }

    public String getModFolder() {
        return modId;
    }

    public String getModVersion() {
        return version;
    }
}

