/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.netherores.ores;

import cpw.mods.fml.common.Loader;
import ic2.api.Ic2Recipes;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import powercrystals.netherores.NetherOresCore;
import thermalexpansion.api.core.ItemRegistry;
import thermalexpansion.api.crafting.CraftingManagers;

public enum Ores {
    coal(0, "Coal", 8, 16, 1, 4),
    diamond(1, "Diamond", 4, 3, 1, 4),
    gold(2, "Gold", 8, 6, 1, 4),
    iron(3, "Iron", 8, 8, 1, 4),
    lapis(4, "Lapis", 6, 6, 1, 24),
    redstone(5, "Redstone", 6, 8, 1, 24),
    copper(6, "Copper", 8, 8, 1, 4),
    tin(7, "Tin", 8, 8, 1, 4),
    emerald(8, "Emerald", 3, 2, 1, 4),
    silver(9, "Silver", 6, 4, 1, 4),
    lead(10, "Lead", 6, 6, 1, 4),
    uranium(11, "Uranium", 3, 2, 1, 4),
    nikolite(12, "Nikolite", 8, 4, 1, 24),
    ruby(13, "Ruby", 6, 3, 1, 4),
    rpemerald(14, "GreenSapphire", 6, 3, 1, 4),
    sapphire(15, "Sapphire", 6, 3, 1, 4);

    private int _metadata;
    private String _oreName;
    private String _netherOreName;
    private String _dustName;
    private boolean _registeredSmelting;
    private boolean _registeredMacerator;
    private int _oreGenMinY = 1;
    private int _oreGenMaxY = 126;
    private int _oreGenGroupsPerChunk = 6;
    private int _oreGenBlocksPerGroup = 14;
    private int _smeltCount;
    private int _maceCount;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Ores(int meta, int oreSuffix, int groupsPerChunk, int blocksPerGroup) {
        void maceCount;
        void smeltCount;
        this._metadata = meta;
        this._oreName = "ore" + (String)oreSuffix;
        this._dustName = "dust" + (String)oreSuffix;
        this._netherOreName = "oreNether" + (String)oreSuffix;
        this._oreGenGroupsPerChunk = groupsPerChunk;
        this._oreGenBlocksPerGroup = blocksPerGroup;
        this._smeltCount = smeltCount;
        this._maceCount = maceCount;
    }

    public int getMetadata() {
        return this._metadata;
    }

    public String getOreName() {
        return this._oreName;
    }

    public String getDustName() {
        return this._dustName;
    }

    public boolean isRegisteredSmelting() {
        return this._registeredSmelting;
    }

    public boolean isRegisteredMacerator() {
        return this._registeredMacerator;
    }

    public int getMaxY() {
        return this._oreGenMaxY;
    }

    public int getMinY() {
        return this._oreGenMinY;
    }

    public int getGroupsPerChunk() {
        return this._oreGenGroupsPerChunk;
    }

    public int getBlocksPerGroup() {
        return this._oreGenBlocksPerGroup;
    }

    public void load() {
        MinecraftForge.setBlockHarvestLevel((amq)NetherOresCore.blockNetherOres, (int)this._metadata, (String)"pickaxe", (int)2);
        ur oreStack = new ur(NetherOresCore.blockNetherOres, 1, this._metadata);
        OreDictionary.registerOre((String)this._netherOreName, (ur)oreStack);
    }

    public void registerSmelting(ur smeltStack) {
        this._registeredSmelting = true;
        if (NetherOresCore.enableStandardFurnaceRecipes.getBoolean(true)) {
            ur smeltTo = smeltStack.l();
            smeltTo.a = this._smeltCount;
            wj.a().addSmelting(NetherOresCore.blockNetherOres.cm, this._metadata, smeltTo, 1.0f);
        }
        if (NetherOresCore.enableInductionSmelterRecipes.getBoolean(true) && Loader.isModLoaded((String)"ThermalExpansion|Factory")) {
            ur smeltToReg = smeltStack.l();
            ur smeltToRich = smeltStack.l();
            ++smeltToReg.a;
            smeltToRich.a += 2;
            CraftingManagers.smelterManager.addRecipe(320, new ur(NetherOresCore.blockNetherOres, 1, this._metadata), new ur(amq.H), smeltToReg, ItemRegistry.getItem((String)"slagRich", (int)1), 10, false);
            CraftingManagers.smelterManager.addRecipe(400, new ur(NetherOresCore.blockNetherOres, 1, this._metadata), ItemRegistry.getItem((String)"slagRich", (int)1), smeltToRich, ItemRegistry.getItem((String)"slag", (int)1), 80, false);
        }
    }

    public void registerMacerator(ur maceStack) {
        if (NetherOresCore.enableMaceratorRecipes.getBoolean(true) && Loader.isModLoaded((String)"IC2")) {
            ur maceTo = maceStack.l();
            maceTo.a = this._maceCount;
            Ic2Recipes.addMaceratorRecipe((ur)new ur(NetherOresCore.blockNetherOres, 1, this._metadata), (ur)maceTo.l());
        }
        if (NetherOresCore.enablePulverizerRecipes.getBoolean(true) && Loader.isModLoaded((String)"ThermalExpansion|Factory")) {
            ur pulvPriTo = maceStack.l();
            ur pulvSecTo = new ur(amq.be);
            pulvPriTo.a = this._maceCount;
            pulvSecTo.a = 1;
            CraftingManagers.pulverizerManager.addRecipe(400, new ur(NetherOresCore.blockNetherOres, 1, this._metadata), pulvPriTo, pulvSecTo, 15, false);
        }
    }

    public void loadConfig(Configuration c) {
        this._oreGenMaxY = c.get("WorldGen", this._oreName + "MaxY", this._oreGenMaxY).getInt();
        this._oreGenMinY = c.get("WorldGen", this._oreName + "MinY", this._oreGenMinY).getInt();
        this._oreGenGroupsPerChunk = c.get("WorldGen", this._oreName + "GroupsPerChunk", this._oreGenGroupsPerChunk).getInt();
        this._oreGenBlocksPerGroup = c.get("WorldGen", this._oreName + "BlocksPerGroup", this._oreGenBlocksPerGroup).getInt();
        if (this._oreGenMinY >= this._oreGenMaxY) {
            this._oreGenMinY = this._oreGenMaxY - 1;
        }
    }
}

