/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.general;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.machinemuse.general.geometry.Colour;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.geometry.SwirlyMuseCircle;
import net.machinemuse.general.gui.MuseGui;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.general.gui.clickable.IClickable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.ForgeHooksClient;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public abstract class MuseRenderer {
    protected static bce renderItem;
    protected static SwirlyMuseCircle selectionCircle;

    public static void drawCircleAround(double xoffset, double yoffset, double radius) {
        if (selectionCircle == null) {
            selectionCircle = new SwirlyMuseCircle(new Colour(0.0, 1.0, 0.0, 0.0), new Colour(0.8f, 1.0, 0.8f, 1.0));
        }
        selectionCircle.draw(radius, xoffset, yoffset);
    }

    public static List pointsInLine(int num, MusePoint2D a, MusePoint2D b) {
        ArrayList<MusePoint2D> points = new ArrayList<MusePoint2D>();
        if (num < 1) {
            return points;
        }
        if (num < 2) {
            points.add(b.minus(a).times(0.5).plus(a));
        } else {
            MusePoint2D step = b.minus(a).times(1.0f / (float)(num + 1));
            for (int i = 1; i < num + 1; ++i) {
                points.add(a.plus(step.times(i)));
            }
        }
        return points;
    }

    public static DoubleBuffer getColourGradient(Colour c1, Colour c2, int numsegments) {
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numsegments * 4));
        for (double i = 0.0; i < (double)numsegments; i += 1.0) {
            Colour c3 = c1.interpolate(c2, i / (double)numsegments);
            buffer.put(c3.r);
            buffer.put(c3.g);
            buffer.put(c3.b);
            buffer.put(c3.a);
        }
        buffer.flip();
        return buffer;
    }

    public static DoubleBuffer getArcPoints(double startangle, double endangle, double radius, double xoffset, double yoffset, double zoffset) {
        int numVertices = (int)Math.ceil(Math.abs((endangle - startangle) * 16.0 * Math.PI));
        double theta = (endangle - startangle) / (double)numVertices;
        DoubleBuffer buffer = BufferUtils.createDoubleBuffer((int)(numVertices * 3));
        double x = radius * Math.sin(startangle);
        double y = radius * Math.cos(startangle);
        double tf = Math.tan(theta);
        double rf = Math.cos(theta);
        for (int i = 0; i < numVertices; ++i) {
            buffer.put(x + xoffset);
            buffer.put(y + yoffset);
            buffer.put(zoffset);
            double tx = y;
            double ty = -x;
            x += tx * tf;
            y += ty * tf;
            x *= rf;
            y *= rf;
        }
        buffer.flip();
        return buffer;
    }

    public static void on2D() {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
    }

    public static void off2D() {
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
    }

    public static void arraysOnC() {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32886);
    }

    public static void arraysOnT() {
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
    }

    public static void arraysOff() {
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32886);
        GL11.glDisableClientState((int)32888);
    }

    public static void texturelessOn() {
        GL11.glDisable((int)3553);
    }

    public static void texturelessOff() {
        GL11.glEnable((int)3553);
    }

    public static void blendingOn() {
        Minecraft.x();
        if (Minecraft.t()) {
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    public static void blendingOff() {
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)2848);
        GL11.glDisable((int)2881);
        GL11.glDisable((int)3042);
    }

    public static void drawItemAt(double x, double y, ur item) {
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        MuseRenderer.getRenderItem().b(MuseRenderer.getFontRenderer(), MuseRenderer.getRenderEngine(), item, (int)x, (int)y);
        MuseRenderer.getRenderItem().c(MuseRenderer.getFontRenderer(), MuseRenderer.getRenderEngine(), item, (int)x, (int)y);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2896);
    }

    public static void drawIconAt(double x, double y, MuseIcon icon, Colour colour) {
        if (icon == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2929);
        MuseRenderer.texturelessOff();
        MuseRenderer.blendingOn();
        ForgeHooksClient.bindTexture((String)icon.getTexturefile(), (int)0);
        if (colour != null) {
            colour.doGL();
        }
        baz tess = baz.a;
        tess.b();
        float r = 0.0625f;
        float u = (float)(icon.getIconIndex() % 16) * r;
        float v = (float)(icon.getIconIndex() / 16) * r;
        tess.a(x, y, 0.0, (double)u, (double)v);
        tess.a(x, y + 16.0, 0.0, (double)u, (double)(v + r));
        tess.a(x + 16.0, y + 16.0, 0.0, (double)(u + r), (double)(v + r));
        tess.a(x + 16.0, y, 0.0, (double)(u + r), (double)v);
        tess.a();
        MuseRenderer.blendingOff();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void drawIconPartial(double x, double y, MuseIcon icon, Colour colour, double left, double top, double right, double bottom) {
        if (icon == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)2929);
        MuseRenderer.texturelessOff();
        MuseRenderer.blendingOn();
        ForgeHooksClient.bindTexture((String)icon.getTexturefile(), (int)0);
        if (colour != null) {
            colour.doGL();
        }
        baz tess = baz.a;
        tess.b();
        double r = 0.0625;
        double u = (double)(icon.getIconIndex() % 16) * r;
        double v = (double)(icon.getIconIndex() / 16) * r;
        tess.a(x + left, y + top, 0.0, u + r * r * left, v + r * r * top);
        tess.a(x + left, y + bottom, 0.0, u + r * r * left, v + r * r * bottom);
        tess.a(x + right, y + bottom, 0.0, u + r * r * right, v + r * r * bottom);
        tess.a(x + right, y + top, 0.0, u + r * r * right, v + r * r * top);
        tess.a();
        MuseRenderer.blendingOff();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void relativeCoords(MuseGui gui) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(gui.g / 2), (float)(gui.h / 2), (float)0.0f);
        GL11.glScalef((float)gui.getxSize(), (float)gui.getySize(), (float)0.0f);
    }

    public static void drawString(String s, double x, double y) {
        arw.a();
        MuseRenderer.getFontRenderer().a(s, (int)x, (int)y, new Colour(1.0, 1.0, 1.0, 1.0).getInt());
    }

    public static void drawCenteredString(String s, double x, double y) {
        double xradius = MuseRenderer.getFontRenderer().a(s) / 2;
        MuseRenderer.drawString(s, x - xradius, y);
    }

    public static void drawRectPrism(double x, double d, double e, double f, double z, double g, float texturex, float texturey, float texturex2, float texturey2) {
        MuseRenderer.arraysOnT();
        MuseRenderer.texturelessOff();
        aoj[] points = new aoj[]{aoj.a((double)x, (double)e, (double)z), aoj.a((double)d, (double)e, (double)z), aoj.a((double)x, (double)f, (double)z), aoj.a((double)d, (double)f, (double)z), aoj.a((double)x, (double)e, (double)g), aoj.a((double)d, (double)e, (double)g), aoj.a((double)x, (double)f, (double)g), aoj.a((double)d, (double)f, (double)g)};
        axq[] va1 = new axq[]{new axq(points[0], texturex, texturey2), new axq(points[2], texturex2, texturey2), new axq(points[3], texturex2, texturey), new axq(points[1], texturex, texturey)};
        new axd(va1).a(baz.a, 1.0f);
        axq[] va2 = new axq[]{new axq(points[2], texturex, texturey2), new axq(points[6], texturex2, texturey2), new axq(points[7], texturex2, texturey), new axq(points[3], texturex, texturey)};
        new axd(va2).a(baz.a, 1.0f);
        axq[] va3 = new axq[]{new axq(points[6], texturex, texturey2), new axq(points[4], texturex2, texturey2), new axq(points[5], texturex2, texturey), new axq(points[7], texturex, texturey)};
        new axd(va3).a(baz.a, 1.0f);
        axq[] va4 = new axq[]{new axq(points[4], texturex, texturey2), new axq(points[0], texturex2, texturey2), new axq(points[1], texturex2, texturey), new axq(points[5], texturex, texturey)};
        new axd(va4).a(baz.a, 1.0f);
        axq[] va5 = new axq[]{new axq(points[1], texturex, texturey2), new axq(points[3], texturex2, texturey2), new axq(points[7], texturex2, texturey), new axq(points[5], texturex, texturey)};
        new axd(va5).a(baz.a, 1.0f);
        axq[] va6 = new axq[]{new axq(points[0], texturex, texturey2), new axq(points[4], texturex2, texturey2), new axq(points[6], texturex2, texturey), new axq(points[2], texturex, texturey)};
        new axd(va6).a(baz.a, 1.0f);
        MuseRenderer.texturelessOff();
        MuseRenderer.arraysOff();
    }

    private static void drawTriangles3DT(float[] v, float[] textures2, int[] i) {
        MuseRenderer.arraysOnT();
        MuseRenderer.texturelessOff();
        FloatBuffer vertices = BufferUtils.createFloatBuffer((int)v.length);
        vertices.put(v);
        vertices.flip();
        FloatBuffer textures = BufferUtils.createFloatBuffer((int)textures2.length);
        textures.put(textures2);
        textures.flip();
        IntBuffer indices = BufferUtils.createIntBuffer((int)i.length);
        indices.put(i);
        indices.flip();
        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)vertices);
        GL11.glTexCoordPointer((int)2, (int)0, (FloatBuffer)textures);
        GL11.glDrawElements((int)4, (IntBuffer)indices);
        MuseRenderer.texturelessOff();
        MuseRenderer.arraysOff();
    }

    public static void drawStringsJustified(List words, double x1, double x2, double y) {
        int totalwidth = 0;
        for (String word : words) {
            totalwidth += MuseRenderer.getFontRenderer().a(word);
        }
        double spacing = (x2 - x1 - (double)totalwidth) / (double)(words.size() - 1);
        double currentwidth = 0.0;
        for (String word : words) {
            MuseRenderer.drawString(word, x1 + currentwidth, y);
            currentwidth += (double)MuseRenderer.getFontRenderer().a(word) + spacing;
        }
    }

    public static void glowOn() {
        arw.a();
        bfe.a((int)bfe.b, (float)240.0f, (float)240.0f);
    }

    public static void glowOff() {
        arw.b();
    }

    public static atq getFontRenderer() {
        return Minecraft.x().p;
    }

    public static bba getRenderEngine() {
        return Minecraft.x().o;
    }

    public static bce getRenderItem() {
        if (renderItem == null) {
            renderItem = new bce();
        }
        return renderItem;
    }

    public static void drawLineBetween(IClickable firstClickable, IClickable secondClickable, Colour gradientColour) {
        MusePoint2D secondpoint;
        MusePoint2D firstpoint;
        long varia = System.currentTimeMillis() % 2000L - 1000L;
        double gradientRatio = 1.0 - (double)((varia + 1000L) % 1000L) / 1000.0;
        MusePoint2D midpoint = firstClickable.getPosition().minus(secondClickable.getPosition()).times(Math.abs((double)varia / 1000.0)).plus(secondClickable.getPosition());
        if (varia < 0L) {
            firstpoint = secondClickable.getPosition();
            secondpoint = firstClickable.getPosition();
        } else {
            firstpoint = firstClickable.getPosition();
            secondpoint = secondClickable.getPosition();
        }
        GL11.glDisable((int)3553);
        GL11.glBegin((int)1);
        gradientColour.withAlpha(gradientRatio).doGL();
        GL11.glVertex3d((double)midpoint.x(), (double)midpoint.y(), (double)1.0);
        gradientColour.withAlpha(0.0).doGL();
        GL11.glVertex3d((double)firstpoint.x(), (double)firstpoint.y(), (double)1.0);
        gradientColour.withAlpha(gradientRatio).doGL();
        GL11.glVertex3d((double)secondpoint.x(), (double)secondpoint.y(), (double)1.0);
        Colour.WHITE.withAlpha(1.0).doGL();
        GL11.glVertex3d((double)midpoint.x(), (double)midpoint.y(), (double)1.0);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public static void drawLightning(double x1, double y1, double z1, double x2, double y2, double z2, Colour colour) {
        double tx = x2 - x1;
        double ty = y2 - y1;
        double tz = z2 - z1;
        double cx = 0.0;
        double cy = 0.0;
        double cz = 0.0;
        double jagfactor = 0.3;
        MuseRenderer.texturelessOn();
        MuseRenderer.blendingOn();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glBegin((int)3);
        while (Math.abs(cx) < Math.abs(tx) && Math.abs(cy) < Math.abs(ty) && Math.abs(cz) < Math.abs(tz)) {
            colour.doGL();
            double ox = x1 + cx;
            double oy = y1 + cy;
            double oz = z1 + cz;
            GL11.glVertex3d((double)(x1 + (cx += Math.random() * tx * jagfactor - 0.1 * tx)), (double)(y1 + (cy += Math.random() * ty * jagfactor - 0.1 * ty)), (double)(z1 + (cz += Math.random() * tz * jagfactor - 0.1 * tz)));
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        MuseRenderer.texturelessOff();
    }
}

