/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client;

import cpw.mods.fml.common.Loader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.general.geometry.MusePoint2D;
import net.machinemuse.general.gui.clickable.ClickableKeybinding;
import net.machinemuse.general.gui.clickable.ClickableModule;
import net.machinemuse.powersuits.common.MuseLogger;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Keyboard;

public class KeybindManager {
    protected Set keybindings = new HashSet();
    protected static KeybindManager instance;

    protected KeybindManager() {
    }

    public static KeybindManager getInstance() {
        if (instance == null) {
            instance = new KeybindManager();
        }
        return instance;
    }

    public static Set getKeybindings() {
        return KeybindManager.getInstance().keybindings;
    }

    public static arv addKeybinding(String keybindDescription, int keycode, MusePoint2D position) {
        arv kb = new arv(keybindDescription, keycode);
        KeybindManager.getInstance().keybindings.add(new ClickableKeybinding(kb, position));
        return kb;
    }

    public static String parseName(arv keybind) {
        if (keybind.d < 0) {
            return "Mouse" + (keybind.d + 100);
        }
        return Keyboard.getKeyName((int)keybind.d);
    }

    public static void writeOutKeybinds() {
        try {
            File file = new File(Loader.instance().getConfigDir(), "powersuits-keybinds.cfg");
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            List modulesToWrite = MuseItemUtils.getPlayerInstalledModules((qx)Minecraft.x().g);
            for (ClickableKeybinding keybinding : KeybindManager.getInstance().keybindings) {
                writer.write(keybinding.getKeyBinding().d + ":" + keybinding.getPosition().x() + ":" + keybinding.getPosition().y() + "\n");
                for (ClickableModule module : keybinding.getBoundModules()) {
                    writer.write(module.getModule().getName() + "~" + module.getPosition().x() + "~" + module.getPosition().y() + "\n");
                }
            }
            writer.close();
        }
        catch (Exception e) {
            MuseLogger.logError("Problem writing out keyconfig :(");
            e.printStackTrace();
        }
    }

    public static void readInKeybinds() {
        try {
            File file = new File(Loader.instance().getConfigDir(), "powersuits-keybinds.cfg");
            if (!file.exists()) {
                MuseLogger.logError("No powersuits keybind file found.");
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ClickableKeybinding workingKeybinding = null;
            while (reader.ready()) {
                String[] exploded;
                String line = reader.readLine();
                if (line.contains(":")) {
                    exploded = line.split(":");
                    int id = Integer.parseInt(exploded[0]);
                    if (!arv.b.b(id)) {
                        MusePoint2D position = new MusePoint2D(Double.parseDouble(exploded[1]), Double.parseDouble(exploded[2]));
                        workingKeybinding = new ClickableKeybinding(new arv(Keyboard.getKeyName((int)id), id), position);
                        KeybindManager.getInstance().keybindings.add(workingKeybinding);
                        continue;
                    }
                    workingKeybinding = null;
                    continue;
                }
                if (!line.contains("~") || workingKeybinding == null) continue;
                exploded = line.split("~");
                MusePoint2D position = new MusePoint2D(Double.parseDouble(exploded[1]), Double.parseDouble(exploded[2]));
                IPowerModule module = ModuleManager.getModule(exploded[0]);
                if (module == null) continue;
                ClickableModule cmodule = new ClickableModule(module, position);
                workingKeybinding.bindModule(cmodule);
            }
            reader.close();
        }
        catch (Exception e) {
            MuseLogger.logError("Problem reading in keyconfig :(");
            e.printStackTrace();
        }
    }
}

