/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPowerModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.general.MuseStringUtils;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.common.ModularPowersuits;
import net.machinemuse.powersuits.common.MuseCreativeTab;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModule;
import net.machinemuse.powersuits.powermodule.ToggleablePowerModule;
import net.machinemuse.powersuits.powermodule.modules.BlinkDriveModule;
import net.machinemuse.powersuits.powermodule.modules.InPlaceAssemblerModule;
import net.machinemuse.powersuits.powermodule.modules.PlasmaCannonModule;
import net.machinemuse.powersuits.powermodule.modules.PowerModuleBase;
import net.machinemuse.powersuits.powermodule.modules.RailgunModule;
import net.machinemuse.powersuits.powermodule.modules.SprintAssistModule;
import net.machinemuse.powersuits.powermodule.modules.StepAssistModule;
import net.minecraftforge.common.Configuration;
import org.lwjgl.input.Keyboard;

public class Config {
    public static final String SEBK_ICON_PATH = "/resources/machinemuse/sebkicons.png";
    public static final String SEBK_ARMOR_PATH = "/resources/machinemuse/sebkarmor.png";
    public static final String SEBK_ARMORPANTS_PATH = "/resources/machinemuse/sebkarmorpants.png";
    public static final String WC_ICON_PATH = "/resources/machinemuse/watericons.png";
    public static final String TINKERTABLE_TEXTURE_PATH = "/resources/machinemuse/tinkertable_tx.png";
    public static final String BLANK_ARMOR_MODEL_PATH = "/resources/machinemuse/blankarmor.png";
    public static final String MUSE_ICON_PATH = "/resources/machinemuse/museicons.png";
    public static final String SEBK_TOOL_TEXTURE = "/resources/machinemuse/tool.png";
    public static final String CITIZENJOE_ARMOR_PATH = "/resources/machinemuse/joearmor.png";
    public static final String CITIZENJOE_ARMORPANTS_PATH = "/resources/machinemuse/joearmorpants.png";
    private static final int[] assignedItemIDs = new int[Items.values().length];
    private static final int[] assignedBlockIDs = new int[Blocks.values().length];
    private static Configuration config;

    public static void init(Configuration config) {
        Config.config = config;
        config.load();
        for (Blocks blocks : Blocks.values()) {
            Config.assignedBlockIDs[blocks.ordinal()] = config.getBlock(blocks.englishName, blocks.defaultBlockId).getInt();
        }
        for (Enum enum_ : Items.values()) {
            Config.assignedItemIDs[enum_.ordinal()] = config.getItem(((Items)enum_).englishName, ((Items)enum_).defaultItemID).getInt();
        }
        config.save();
    }

    public static String getNetworkChannelName() {
        return "mmmPowerSuits";
    }

    public static tj getCreativeTab() {
        return MuseCreativeTab.instance();
    }

    public static double getSalvageChance() {
        return config.get("general", "Salvage Ratio", 0.9).getDouble(0.9);
    }

    public static boolean isDebugging() {
        return config.get("general", "Debugging info", false).getBoolean(false);
    }

    public static int getAssignedItemID(Items item) {
        if (assignedItemIDs[item.ordinal()] == 0) {
            Config.assignedItemIDs[item.ordinal()] = config.getItem(item.englishName, item.defaultItemID).getInt();
        }
        return assignedItemIDs[item.ordinal()];
    }

    public static int getAssignedBlockID(Blocks block) {
        if (assignedBlockIDs[block.ordinal()] == 0) {
            Config.assignedBlockIDs[block.ordinal()] = config.getBlock(block.englishName, block.defaultBlockId).getInt();
        }
        return assignedBlockIDs[block.ordinal()];
    }

    public static ur copyAndResize(ur stack, int number) {
        ur copy = stack.l();
        copy.a = number;
        return copy;
    }

    public static void addModule(IPowerModule module) {
        ModuleManager.addModule(module);
    }

    public static void loadPowerModules() {
        List<IModularItem> ARMORONLY = Arrays.asList(ModularPowersuits.powerArmorHead, ModularPowersuits.powerArmorTorso, ModularPowersuits.powerArmorLegs, ModularPowersuits.powerArmorFeet);
        List<IModularItem> ALLITEMS = Arrays.asList(ModularPowersuits.powerArmorHead, ModularPowersuits.powerArmorTorso, ModularPowersuits.powerArmorLegs, ModularPowersuits.powerArmorFeet, ModularPowersuits.powerTool);
        List<IModularItem> HEADONLY = Arrays.asList(ModularPowersuits.powerArmorHead);
        List<IModularItem> TORSOONLY = Arrays.asList(ModularPowersuits.powerArmorTorso);
        List<IModularItem> LEGSONLY = Arrays.asList(ModularPowersuits.powerArmorLegs);
        List<IModularItem> FEETONLY = Arrays.asList(ModularPowersuits.powerArmorFeet);
        List<IModularItem> TOOLONLY = Arrays.asList(ModularPowersuits.powerTool);
        PowerModuleBase module = new ToggleablePowerModule("Night Vision", HEADONLY, MuseIcon.SCANNER, "Special").setDescription("A pair of augmented vision goggles to help you see at night and underwater.").addInstallCost(Config.copyAndResize(ItemComponent.laserHologram, 1)).addInstallCost(Config.copyAndResize(ItemComponent.controlCircuit, 1));
        Config.addModule(module);
        module = new ToggleablePowerModule("Active Camouflage", TORSOONLY, MuseIcon.ORB_1_BLUE, "Special").setDescription("Emit a hologram of your surroundings to make yourself almost imperceptible.").addInstallCost(Config.copyAndResize(ItemComponent.laserHologram, 4)).addInstallCost(Config.copyAndResize(ItemComponent.fieldEmitter, 2)).addInstallCost(Config.copyAndResize(ItemComponent.controlCircuit, 2));
        Config.addModule(module);
        module = new ToggleablePowerModule("Flight Control", HEADONLY, MuseIcon.INDICATOR_1_GREEN, "Special").setDescription("An integrated control circuit to help you fly better. Press Z to go down.").addInstallCost(Config.copyAndResize(ItemComponent.controlCircuit, 1));
        Config.addModule(module);
        Config.addModule(new PlasmaCannonModule(TOOLONLY));
        module = new ToggleablePowerModule("Melee Assist", TOOLONLY, MuseIcon.PUNCHY, "Weapon").setDescription("A much simpler addon, makes your powertool punches hit harder.").addBaseProperty("Punch Energy Consumption", 10.0, "J").addBaseProperty("Melee Damage", 2.0, "pt").addTradeoffProperty("Impact", "Punch Energy Consumption", 100.0, "J").addTradeoffProperty("Impact", "Melee Damage", 8.0, "pt").addTradeoffProperty("Carry-through", "Punch Energy Consumption", 20.0, "J").addTradeoffProperty("Carry-through", "Melee Knockback", 1.0, "P").addInstallCost(Config.copyAndResize(ItemComponent.servoMotor, 2)).addInstallCost(Config.copyAndResize(ItemComponent.lvcapacitor, 1));
        Config.addModule(module);
        Config.addModule(new RailgunModule(TOOLONLY));
        Config.addModule(new InPlaceAssemblerModule(TOOLONLY));
        Config.addModule(new BlinkDriveModule(TOOLONLY));
        module = new PowerModule("Kinetic Generator", LEGSONLY, MuseIcon.NEXUS_1_RED, "Energy").setDescription("Generate power with your movement.").addBaseProperty("Weight", 1000.0).addBaseProperty("Energy Generation Per 5 Blocks", 250.0).addTradeoffProperty("Energy Generated", "Energy Generation Per 5 Blocks", 750.0, " Joules").addTradeoffProperty("Energy Generated", "Weight", 3000.0, "g").addInstallCost(Config.copyAndResize(ItemComponent.servoMotor, 2)).addInstallCost(Config.copyAndResize(ItemComponent.controlCircuit, 1));
        Config.addModule(module);
        module = new PowerModule("Solar Generator", HEADONLY, MuseIcon.NEXUS_1_GREEN, "Energy").setDescription("Let the sun power your adventures.").addBaseProperty("Daytime Solar Energy Generation", 2000.0).addBaseProperty("Nighttime Solar Energy Generation", 200.0).addInstallCost(Config.copyAndResize(ItemComponent.solarPanel, 1)).addInstallCost(Config.copyAndResize(ItemComponent.controlCircuit, 2));
        Config.addModule(module);
        module = new ToggleablePowerModule("Auto-Feeder", HEADONLY, MuseIcon.NEXUS_1_BLUE, "Environment").setDescription("Whenever you're hungry, this module will grab the bottom-left-most food item from your inventory and feed it to you, storing the rest for later.").addBaseProperty("Eating Energy Consumption", 100.0).addBaseProperty("Auto-Feeder Efficiency", 50.0).addTradeoffProperty("Efficiency", "Eating Energy Consumption", 100.0).addTradeoffProperty("Efficiency", "Auto-Feeder Efficiency", 50.0).addInstallCost(Config.copyAndResize(ItemComponent.servoMotor, 2)).addInstallCost(Config.copyAndResize(ItemComponent.controlCircuit, 1));
        Config.addModule(module);
        module = new PowerModule("Iron Plating", ARMORONLY, MuseIcon.MODULE_IRON_PLATING, "Armor").setDescription("Basic plating is heavy but protective.").addInstallCost(Config.copyAndResize(ItemComponent.basicPlating, 1)).addTradeoffProperty("Plating Thickness", "Armor (Physical)", 5.0, " Points").addTradeoffProperty("Plating Thickness", "Weight", 10000.0, "g");
        Config.addModule(module);
        module = new PowerModule("Diamond Plating", ARMORONLY, MuseIcon.MODULE_DIAMOND_PLATING, "Armor").setDescription("Advanced plating is lighter, harder, and more protective than Basic but much harder to make.").addInstallCost(Config.copyAndResize(ItemComponent.advancedPlating, 1)).addTradeoffProperty("Plating Thickness", "Armor (Physical)", 6.0, " Points").addTradeoffProperty("Plating Thickness", "Weight", 6000.0, "g");
        Config.addModule(module);
        module = new PowerModule("Energy Shield", ARMORONLY, MuseIcon.ENERGY_SHIELD, "Armor").setDescription("Energy shields are much lighter than plating, but consume energy.").addInstallCost(Config.copyAndResize(ItemComponent.fieldEmitter, 2)).addTradeoffProperty("Field Strength", "Armor (Energy)", 6.0, " Points").addTradeoffProperty("Field Strength", "Energy Per Damage", 500.0, "J");
        Config.addModule(module);
        module = new ToggleablePowerModule("Shovel", TOOLONLY, MuseIcon.TOOL_SHOVEL, "Tool").setDescription("Shovels are good for soft materials like dirt and sand.").addInstallCost(new ur(up.o, 3)).addInstallCost(Config.copyAndResize(ItemComponent.solenoid, 1)).addBaseProperty("Shovel Energy Consumption", 50.0, "J").addBaseProperty("Shovel Harvest Speed", 8.0, "x").addTradeoffProperty("Overclock", "Shovel Energy Consumption", 950.0).addTradeoffProperty("Overclock", "Shovel Harvest Speed", 22.0);
        Config.addModule(module);
        module = new ToggleablePowerModule("Pickaxe", TOOLONLY, MuseIcon.TOOL_PICK, "Tool").setDescription("Picks are good for harder materials like stone and ore.").addInstallCost(new ur(up.o, 3)).addInstallCost(Config.copyAndResize(ItemComponent.solenoid, 1)).addBaseProperty("Pickaxe Energy Consumption", 50.0, "J").addBaseProperty("Pickaxe Harvest Speed", 8.0, "x").addTradeoffProperty("Overclock", "Pickaxe Energy Consumption", 950.0).addTradeoffProperty("Overclock", "Pickaxe Harvest Speed", 22.0);
        Config.addModule(module);
        module = new ToggleablePowerModule("Axe", TOOLONLY, MuseIcon.TOOL_AXE, "Tool").setDescription("Axes are mostly for chopping trees.").addInstallCost(new ur(up.o, 3)).addInstallCost(Config.copyAndResize(ItemComponent.solenoid, 1)).addBaseProperty("Axe Energy Consumption", 50.0, "J").addBaseProperty("Axe Harvest Speed", 8.0, "x").addTradeoffProperty("Overclock", "Axe Energy Consumption", 950.0).addTradeoffProperty("Overclock", "Axe Harvest Speed", 22.0);
        Config.addModule(module);
        module = new PowerModule("Diamond Drill Upgrade", TOOLONLY, MuseIcon.DIAMOND_PICK, "Special").setDescription("Add diamonds to allow your pickaxe module to mine Obsidian. *REQUIRES PICKAXE MODULE TO WORK*").addInstallCost(Config.copyAndResize(ItemComponent.solenoid, 1)).addInstallCost(new ur(up.n, 3));
        Config.addModule(module);
        module = new ToggleablePowerModule("Aqua Affinity", TOOLONLY, MuseIcon.AQUA_AFFINITY, "Special").setDescription("Reduces the speed penalty for using your tool underwater.").addInstallCost(Config.copyAndResize(ItemComponent.servoMotor, 1)).addBaseProperty("Underwater Energy Consumption", 0.0, "J").addBaseProperty("Underwater Harvest Speed", 0.2, "%").addTradeoffProperty("Power", "Underwater Energy Consumption", 100.0).addTradeoffProperty("Power", "Underwater Harvest Speed", 0.8);
        Config.addModule(module);
        module = new PowerModule("Basic Battery", ALLITEMS, MuseIcon.BATTERY1, "Energy").setDescription("Integrate a battery to allow the item to store energy.").addInstallCost(Config.copyAndResize(ItemComponent.lvcapacitor, 1)).addBaseProperty("Maximum Energy", 20000.0, "J").addBaseProperty("Weight", 2000.0, "g").addTradeoffProperty("Battery Size", "Maximum Energy", 80000.0).addTradeoffProperty("Battery Size", "Weight", 8000.0);
        Config.addModule(module);
        module = new PowerModule("Advanced Battery", ALLITEMS, MuseIcon.BATTERY2, "Energy").setDescription("Integrate a more advanced battery to store more energy.").addInstallCost(Config.copyAndResize(ItemComponent.mvcapacitor, 1)).addBaseProperty("Maximum Energy", 100000.0, "J").addBaseProperty("Weight", 2000.0, "g").addTradeoffProperty("Battery Size", "Maximum Energy", 400000.0).addTradeoffProperty("Battery Size", "Weight", 8000.0);
        Config.addModule(module);
        module = new PowerModule("Elite Battery", ALLITEMS, MuseIcon.BATTERYCRYSTAL, "Energy").setDescription("Integrate a the most advanced battery to store an extensive amount of energy.").addInstallCost(Config.copyAndResize(ItemComponent.hvcapacitor, 1)).addBaseProperty("Maximum Energy", 750000.0, "J").addBaseProperty("Weight", 2000.0, "g").addTradeoffProperty("Battery Size", "Maximum Energy", 4250000.0).addTradeoffProperty("Battery Size", "Weight", 8000.0);
        Config.addModule(module);
        Config.addModule(new SprintAssistModule());
        module = new ToggleablePowerModule("Jump Assist", LEGSONLY, MuseIcon.JUMP_ASSIST, "Movement").setDescription("Another set of servo motors to help you jump higher.").addSimpleTradeoff(module, "Power", "Jump Energy Consumption", "J", 0.0, 25.0, "Jump Boost", "%", 1.0, 4.0).addSimpleTradeoff(module, "Compensation", "Jump Energy Consumption", "J", 0.0, 5.0, "Jump Exhaustion Compensation", "%", 0.0, 1.0).addInstallCost(Config.copyAndResize(ItemComponent.servoMotor, 4));
        Config.addModule(module);
        module = new ToggleablePowerModule("Shock Absorber", FEETONLY, MuseIcon.SHOCK_ABSORBER, "Movement").setDescription("With some servos, springs, and padding, you should be able to negate a portion of fall damage.").addSimpleTradeoff(module, "Power", "Impact Energy consumption", "J/m", 0.0, 10.0, "Distance Reduction", "%", 0.0, 1.0).addInstallCost(Config.copyAndResize(ItemComponent.servoMotor, 2)).addInstallCost(new ur(amq.ae, 2));
        Config.addModule(module);
        module = new ToggleablePowerModule("Glider", TORSOONLY, MuseIcon.GLIDER, "Movement").setDescription("Tack on some wings to turn downward into forward momentum. Press sneak+forward while falling to activate.").addInstallCost(Config.copyAndResize(ItemComponent.gliderWing, 2));
        Config.addModule(module);
        module = new PowerModule("Parachute", TORSOONLY, MuseIcon.PARACHUTE_MODULE, "Movement").setDescription("Add a parachute to slow your descent. Activate by pressing sneak (defaults to Shift) in midair.").addInstallCost(Config.copyAndResize(ItemComponent.parachute, 2));
        Config.addModule(module);
        module = new ToggleablePowerModule("Jetpack", TORSOONLY, MuseIcon.JETPACK, "Movement").setDescription("A jetpack should allow you to jump indefinitely, or at least until you run out of power.").addInstallCost(Config.copyAndResize(ItemComponent.ionThruster, 4)).addBaseProperty("Jet Energy Consumption", 0.0, "J/t").addBaseProperty("Jet Thrust", 0.0, "N").addTradeoffProperty("Thrust", "Jet Energy Consumption", 150.0).addTradeoffProperty("Thrust", "Jet Thrust", 0.16);
        Config.addModule(module);
        module = new ToggleablePowerModule("Jet Boots", FEETONLY, MuseIcon.JETBOOTS, "Movement").setDescription("Jet boots are not as strong as a jetpack, but they should at least be strong enough to counteract gravity.").addInstallCost(Config.copyAndResize(ItemComponent.ionThruster, 2)).addBaseProperty("Jet Energy Consumption", 0.0).addBaseProperty("Jet Thrust", 0.0).addTradeoffProperty("Thrust", "Jet Energy Consumption", 75.0).addTradeoffProperty("Thrust", "Jet Thrust", 0.08);
        Config.addModule(module);
        module = new ToggleablePowerModule("Water Electrolyzer", HEADONLY, MuseIcon.WATER_ELECTROLYZER, "Environment").setDescription("When you run out of air, this module will jolt the water around you, electrolyzing a small bubble to breathe from.").addInstallCost(Config.copyAndResize(ItemComponent.lvcapacitor, 1)).addBaseProperty("Jolt Energy", 1000.0, "J");
        Config.addModule(module);
        module = new ToggleablePowerModule("Swim Boost", LEGSONLY, MuseIcon.SWIM_BOOST, "Movement").setDescription("By refitting an ion thruster for underwater use, you may be able to add extra forward (or backward) thrust when underwater.").addInstallCost(Config.copyAndResize(ItemComponent.ionThruster, 1)).addInstallCost(Config.copyAndResize(ItemComponent.solenoid, 2)).addTradeoffProperty("Thrust", "Swim Boost Energy Consumption", 100.0, "J").addTradeoffProperty("Thrust", "Underwater Movement Boost", 1.0, "m/s");
        Config.addModule(module);
        Config.addModule(new StepAssistModule(LEGSONLY));
        module = new ToggleablePowerModule("Custom Colour Module", ALLITEMS, MuseIcon.NETHERSTAR, "Cosmetic").setDescription("Give your armor some coloured tinting to customize your armor's appearance.").addInstallCost(Config.copyAndResize(ItemComponent.laserHologram, 1)).addTradeoffProperty("Red Intensity", "Red Tint", 1.0, "%").addTradeoffProperty("Green Intensity", "Green Tint", 1.0, "%").addTradeoffProperty("Blue Intensity", "Blue Tint", 1.0, "%");
        Config.addModule(module);
        module = new ToggleablePowerModule("Transparent Armor", ARMORONLY, MuseIcon.TRANSPARENT_ARMOR, "Cosmetic").setDescription("Make the item transparent, so you can show off your skin without losing armor.").addInstallCost(Config.copyAndResize(ItemComponent.laserHologram, 1));
        Config.addModule(module);
        module = new PowerModule("Citizen Joe Style", ARMORONLY, MuseIcon.ORB_1_GREEN, "Cosmetic").setDescription("An alternative armor texture, c/o CitizenJoe of IC2 forums.");
        Config.addModule(module);
    }

    public static Configuration getConfig() {
        return config;
    }

    public static boolean doAdditionalInfo() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && Keyboard.isKeyDown((int)42);
    }

    public static Object additionalInfoInstructions() {
        String message = "Press SHIFT for more information.";
        message = MuseStringUtils.wrapMultipleFormatTags(message, new Object[]{MuseStringUtils.FormatCodes.Grey, MuseStringUtils.FormatCodes.Italic});
        return message;
    }

    public static enum Guis {
        GuiTinkerTable,
        GuiSuitManager,
        GuiPortableCrafting;

    }

    public static enum Items {
        PowerArmorHead(24770, 0, "powerArmorHead", "Power Armor Head"),
        PowerArmorTorso(24771, 1, "powerArmorTorso", "Power Armor Torso"),
        PowerArmorLegs(24772, 2, "powerArmorLegs", "Power Armor Legs"),
        PowerArmorFeet(24773, 3, "powerArmorFeet", "Power Armor Feet"),
        PowerTool(24774, 4, "powerTool", "Power Tool"),
        PowerArmorComponent(24775, 5, "powerArmorComponent", "Power Armor Component");

        public final int defaultItemID;
        public final int iconIndex;
        public final String idName;
        public final String englishName;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Items(String defaultItemID, String iconIndex) {
            void englishName;
            void idName;
            this.defaultItemID = (int)defaultItemID;
            this.iconIndex = (int)iconIndex;
            this.idName = idName;
            this.englishName = englishName;
        }
    }

    public static enum Blocks {
        TinkerTable(2477, 0, "tinkerTable", "Power Armor Tinker Table");

        public final int defaultBlockId;
        public final int textureIndex;
        public final String idName;
        public final String englishName;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Blocks(String defaultBlockId, String textureIndex) {
            void englishName;
            void idName;
            this.defaultBlockId = (int)defaultBlockId;
            this.textureIndex = (int)textureIndex;
            this.idName = idName;
            this.englishName = englishName;
        }
    }
}

