/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.modules;

import java.util.List;
import net.machinemuse.api.ElectricItemUtils;
import net.machinemuse.api.IRightClickModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.MusePlayerUtils;
import net.machinemuse.general.gui.MuseIcon;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.modules.PowerModuleBase;

public class RailgunModule
extends PowerModuleBase
implements IRightClickModule {
    private static String IMPULSE = "Railgun Total Impulse";
    private static String ENERGY = "Railgun Energy Cost";

    public RailgunModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 6));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.hvcapacitor, 1));
        this.addBaseProperty(IMPULSE, 500.0, "Ns");
        this.addBaseProperty(ENERGY, 500.0, "J");
        this.addTradeoffProperty("Voltage", IMPULSE, 2500.0);
        this.addTradeoffProperty("Voltage", ENERGY, 2500.0);
    }

    @Override
    public MuseIcon getIcon(ur item) {
        return MuseIcon.CLAW_LASER;
    }

    @Override
    public String getCategory() {
        return "Weapon";
    }

    @Override
    public String getName() {
        return "Railgun";
    }

    @Override
    public String getDescription() {
        return "An assembly which accelerates a projectile to supersonic speeds using magnetic force. Heavy recoil.";
    }

    public void drawParticleStreamTo(qx source, yc world, double x, double y, double z) {
        aoj direction = source.Z().a();
        double scale = 1.0;
        double xoffset = 1.3f;
        double yoffset = -0.2;
        double zoffset = 0.3f;
        aoj horzdir = direction.a();
        horzdir.d = 0.0;
        horzdir = horzdir.a();
        double cx = source.t + direction.c * xoffset - direction.d * horzdir.c * yoffset - horzdir.e * zoffset;
        double cy = source.u + (double)source.e() + direction.d * xoffset + (1.0 - Math.abs(direction.d)) * yoffset;
        double cz = source.v + direction.e * xoffset - direction.d * horzdir.e * yoffset + horzdir.c * zoffset;
        double dx = x - cx;
        double dy = y - cy;
        double dz = z - cz;
        double ratio = Math.sqrt(dx * dx + dy * dy + dz * dz);
        while (Math.abs(cx - x) > Math.abs(dx / ratio)) {
            world.a("townaura", cx, cy, cz, 0.0, 0.0, 0.0);
            cx += dx * 0.1 / ratio;
            cy += dy * 0.1 / ratio;
            cz += dz * 0.1 / ratio;
        }
    }

    @Override
    public void onRightClick(qx player, yc world, ur itemStack) {
        double range = 64.0;
        double energyConsumption = ModuleManager.computeModularProperty(itemStack, ENERGY);
        if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
            ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
            aoh hitMOP = MusePlayerUtils.doCustomRayTrace(player.p, player, true, range);
            world.a((lq)player, "random.bow", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            double damage = ModuleManager.computeModularProperty(itemStack, IMPULSE) / 100.0;
            double knockback = damage / 20.0;
            aoj lookVec = player.Z();
            if (hitMOP != null) {
                switch (hitMOP.a) {
                    case b: {
                        this.drawParticleStreamTo(player, world, hitMOP.f.c, hitMOP.f.d, hitMOP.f.e);
                        lh damageSource = lh.a((qx)player);
                        if (!hitMOP.g.a(damageSource, (int)damage)) break;
                        hitMOP.g.g(lookVec.c * knockback, Math.abs(lookVec.d + (double)0.2f) * knockback, lookVec.e * knockback);
                        break;
                    }
                    case a: {
                        this.drawParticleStreamTo(player, world, hitMOP.f.c, hitMOP.f.d, hitMOP.f.e);
                        break;
                    }
                }
                player.g(-lookVec.c * knockback, Math.abs(-lookVec.d + (double)0.2f) * knockback, -lookVec.e * knockback);
                world.a((lq)player, "random.bow", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
        }
    }
}

