/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.tick;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.machinemuse.api.ElectricItemUtils;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.IPlayerTickModule;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.general.MuseMathUtils;
import net.machinemuse.powersuits.common.MuseLogger;
import net.machinemuse.powersuits.common.PlayerInputMap;
import net.machinemuse.powersuits.event.MovementManager;

public class PlayerTickHandler
implements ITickHandler {
    public void tickStart(EnumSet type, Object ... tickData) {
        qx player = PlayerTickHandler.toPlayer(tickData[0]);
        this.handle(player);
    }

    public void handle(qx player) {
        List modularItemsEquipped = MuseItemUtils.modularItemsEquipped(player);
        ur helmet = player.q(3);
        ur torso = player.q(2);
        ur pants = player.q(1);
        ur boots = player.q(0);
        ur tool = player.bS();
        double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
        double totalWeight = MuseItemUtils.getPlayerWeight(player);
        double weightCapacity = 25000.0;
        double totalEnergyDrain = 0.0;
        double foodAdjustment = 0.0;
        yc world = player.p;
        double landMovementFactor = 0.1;
        double jumpMovementFactor = 0.02;
        aoj playerHorzFacing = player.Z();
        playerHorzFacing.d = 0.0;
        playerHorzFacing.a();
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.bR);
        boolean jumpkey = movementInput.jumpKey;
        float forwardkey = movementInput.forwardKey;
        float strafekey = movementInput.strafeKey;
        boolean sneakkey = movementInput.sneakKey;
        boolean downkey = movementInput.downKey;
        boolean hasSprintAssist = false;
        boolean hasGlider = false;
        boolean hasParachute = false;
        boolean hasJetpack = false;
        boolean hasJetboots = false;
        boolean hasJumpAssist = false;
        boolean hasSwimAssist = false;
        boolean hasNightVision = false;
        boolean hasInvis = false;
        boolean hasFlightControl = false;
        boolean hasFeeder = false;
        boolean hasSolarGeneration = false;
        boolean hasKineticGeneration = false;
        for (IPlayerTickModule module : ModuleManager.getPlayerTickModules()) {
            for (ur itemStack : modularItemsEquipped) {
                if (!module.isValidForItem(itemStack, player)) continue;
                if (MuseItemUtils.itemHasActiveModule(itemStack, module.getName())) {
                    module.onPlayerTickActive(player, itemStack);
                    continue;
                }
                module.onPlayerTickInactive(player, itemStack);
            }
        }
        if (helmet != null && helmet.b() instanceof IModularItem) {
            IModularItem modular = (IModularItem)helmet.b();
            hasNightVision = MuseItemUtils.itemHasActiveModule(helmet, "Night Vision");
            hasFlightControl = MuseItemUtils.itemHasActiveModule(helmet, "Flight Control");
            hasFeeder = MuseItemUtils.itemHasActiveModule(helmet, "Auto-Feeder");
            hasSolarGeneration = MuseItemUtils.itemHasActiveModule(helmet, "Solar Generator");
            if (helmet.p().b("ench")) {
                helmet.p().o("ench");
            }
        }
        if (pants != null && pants.b() instanceof IModularItem) {
            hasSprintAssist = MuseItemUtils.itemHasActiveModule(pants, "Sprint Assist");
            hasJumpAssist = MuseItemUtils.itemHasActiveModule(pants, "Jump Assist");
            hasSwimAssist = MuseItemUtils.itemHasActiveModule(pants, "Swim Boost");
            hasKineticGeneration = MuseItemUtils.itemHasActiveModule(pants, "Kinetic Generator");
            if (pants.p().b("ench")) {
                pants.p().o("ench");
            }
        }
        if (boots != null && boots.b() instanceof IModularItem) {
            hasJetboots = MuseItemUtils.itemHasActiveModule(boots, "Jet Boots");
            if (boots.p().b("ench")) {
                boots.p().o("ench");
            }
        }
        if (torso != null && torso.b() instanceof IModularItem) {
            hasInvis = MuseItemUtils.itemHasActiveModule(torso, "Active Camouflage");
            hasJetpack = MuseItemUtils.itemHasActiveModule(torso, "Jetpack");
            hasGlider = MuseItemUtils.itemHasActiveModule(torso, "Glider");
            hasParachute = MuseItemUtils.itemHasActiveModule(torso, "Parachute");
            if (torso.p().b("ench")) {
                torso.p().o("ench");
            }
        }
        lm nightVision = null;
        lm invis = null;
        Collection effects = player.bz();
        for (lm effect : effects) {
            if (effect.c() == -337 && effect.a() == ll.r.H) {
                nightVision = effect;
                break;
            }
            if (effect.c() != 81 || effect.a() != ll.p.H) continue;
            invis = effect;
            break;
        }
        if (hasNightVision && totalEnergyDrain + 5.0 < totalEnergy) {
            if (nightVision == null || nightVision.b() < 210) {
                player.d(new lm(ll.r.H, 500, -337));
                totalEnergyDrain += 5.0;
            }
        } else if (nightVision != null) {
            player.o(ll.r.H);
        }
        if (hasInvis && totalEnergyDrain + 50.0 < totalEnergy) {
            if (invis == null || invis.b() < 210) {
                player.d(new lm(ll.p.H, 500, 81));
                totalEnergyDrain += 50.0;
            }
        } else if (invis != null) {
            player.o(ll.p.H);
        }
        if (player.H()) {
            if (hasSwimAssist && (forwardkey != 0.0f || strafekey != 0.0f || jumpkey || sneakkey)) {
                double moveRatio = 0.0;
                if (forwardkey != 0.0f) {
                    moveRatio += (double)(forwardkey * forwardkey);
                }
                if (strafekey != 0.0f) {
                    moveRatio += (double)(strafekey * strafekey);
                }
                if (jumpkey || sneakkey) {
                    moveRatio += 0.04000000000000001;
                }
                double swimAssistRate = ModuleManager.computeModularProperty(pants, "Underwater Movement Boost") * 0.05;
                double swimEnergyConsumption = ModuleManager.computeModularProperty(pants, "Swim Boost Energy Consumption");
                if (swimEnergyConsumption + totalEnergyDrain < totalEnergy) {
                    totalEnergyDrain += swimEnergyConsumption;
                    player.w += player.Z().c * swimAssistRate * (double)forwardkey / moveRatio;
                    player.x += player.Z().d * swimAssistRate * (double)forwardkey / moveRatio;
                    player.y += player.Z().e * swimAssistRate * (double)forwardkey / moveRatio;
                    if (jumpkey) {
                        player.x += swimAssistRate * 0.2 / moveRatio;
                    }
                    if (sneakkey) {
                        player.x -= swimAssistRate * 0.2 / moveRatio;
                    }
                }
            }
        } else {
            double totalVelocity;
            if (hasJumpAssist && jumpkey) {
                double multiplier = MovementManager.getPlayerJumpMultiplier(player);
                if (multiplier > 0.0) {
                    player.x += 0.15 * Math.min(multiplier, 1.0) * PlayerTickHandler.getWeightPenaltyRatio(totalWeight, weightCapacity);
                    MovementManager.setPlayerJumpTicks(player, multiplier - 1.0);
                }
                player.aO = player.aN * 0.7f;
            } else {
                MovementManager.setPlayerJumpTicks(player, 0.0);
            }
            if (hasJetpack || hasJetboots) {
                double jetEnergy = 0.0;
                double thrust = 0.0;
                if (hasJetpack) {
                    jetEnergy += ModuleManager.computeModularProperty(torso, "Jet Energy Consumption");
                    thrust += ModuleManager.computeModularProperty(torso, "Jet Thrust");
                }
                if (hasJetboots) {
                    jetEnergy += ModuleManager.computeModularProperty(boots, "Jet Energy Consumption");
                    thrust += ModuleManager.computeModularProperty(boots, "Jet Thrust");
                }
                if (jetEnergy + totalEnergyDrain < totalEnergy) {
                    thrust *= PlayerTickHandler.getWeightPenaltyRatio(totalWeight, weightCapacity);
                    if (hasFlightControl && thrust > 0.0) {
                        aoj desiredDirection = player.Z().a();
                        double strafeX = desiredDirection.e;
                        double strafeZ = -desiredDirection.c;
                        double scaleStrafe = strafeX * strafeX + strafeZ * strafeZ;
                        desiredDirection.c = desiredDirection.c * (double)Math.signum(forwardkey) + strafeX * (double)Math.signum(strafekey);
                        desiredDirection.d = desiredDirection.d * (double)Math.signum(forwardkey) + (double)(jumpkey ? 1 : 0) - (double)(downkey ? 1 : 0);
                        desiredDirection.e = desiredDirection.e * (double)Math.signum(forwardkey) + strafeZ * (double)Math.signum(strafekey);
                        desiredDirection = desiredDirection.a();
                        if (player.x < 0.0 && desiredDirection.d >= 0.0) {
                            if (-player.x > thrust) {
                                totalEnergyDrain += jetEnergy * thrust;
                                player.x += thrust;
                                thrust = 0.0;
                            } else {
                                totalEnergyDrain += jetEnergy * Math.abs(player.x);
                                thrust -= player.x;
                                player.x = 0.0;
                            }
                        }
                        if (player.x < -1.0) {
                            totalEnergyDrain += jetEnergy * Math.abs(1.0 + player.x);
                            thrust += 1.0 + player.x;
                            player.x = -1.0;
                        }
                        if (Math.abs(player.w) > 0.0 && desiredDirection.b() == 0.0) {
                            if (Math.abs(player.w) > thrust) {
                                totalEnergyDrain += jetEnergy * thrust;
                                player.w -= Math.signum(player.w) * thrust;
                                thrust = 0.0;
                            } else {
                                totalEnergyDrain += jetEnergy * Math.abs(player.w);
                                thrust -= Math.abs(player.w);
                                player.w = 0.0;
                            }
                        }
                        if (Math.abs(player.y) > 0.0 && desiredDirection.b() == 0.0) {
                            if (Math.abs(player.y) > thrust) {
                                totalEnergyDrain += jetEnergy * thrust;
                                player.y -= Math.signum(player.y) * thrust;
                                thrust = 0.0;
                            } else {
                                totalEnergyDrain += jetEnergy * Math.abs(player.y);
                                thrust -= Math.abs(player.y);
                                player.y = 0.0;
                            }
                        }
                        double vx = thrust * desiredDirection.c;
                        double vy = thrust * desiredDirection.d;
                        double vz = thrust * desiredDirection.e;
                        player.w += vx;
                        player.x += vy;
                        player.y += vz;
                        totalEnergyDrain += jetEnergy * (vx * vx + vy * vy + vz * vz);
                    } else if (jumpkey && player.x < 0.5) {
                        totalEnergyDrain += jetEnergy;
                        if (forwardkey == 0.0f) {
                            player.x += thrust;
                        } else {
                            player.x += thrust / 2.0;
                            player.w += playerHorzFacing.c * thrust / 2.0 * (double)Math.signum(forwardkey);
                            player.y += playerHorzFacing.e * thrust / 2.0 * (double)Math.signum(forwardkey);
                        }
                    }
                }
            }
            if (hasGlider && sneakkey && player.x < -0.1 && (!hasParachute || forwardkey > 0.0f) && player.x < -0.1) {
                double motionYchange = Math.min(0.08, -0.1 - player.x);
                player.x += motionYchange;
                player.w += playerHorzFacing.c * motionYchange;
                player.y += playerHorzFacing.e * motionYchange;
                player.aO += 0.03f;
            }
            if (hasParachute && sneakkey && player.x < -0.1 && (!hasGlider || forwardkey <= 0.0f) && (totalVelocity = Math.sqrt(player.w * player.w + player.y * player.y + player.x * player.x) * PlayerTickHandler.getWeightPenaltyRatio(totalWeight, weightCapacity)) > 0.0) {
                player.w = player.w * 0.1 / totalVelocity;
                player.x = player.x * 0.1 / totalVelocity;
                player.y = player.y * 0.1 / totalVelocity;
            }
            if (hasSprintAssist) {
                // empty if block
            }
        }
        if (hasFeeder) {
            qw inv = player.bJ;
            double foodLevel = MuseItemUtils.getFoodLevel(helmet);
            double saturationLevel = MuseItemUtils.getSaturationLevel(helmet);
            double efficiency = ModuleManager.computeModularProperty(helmet, "Auto-Feeder Efficiency");
            rp foodStats = player.cc();
            int foodNeeded = 20 - foodStats.a();
            double eatingEnergyConsumption = (double)foodNeeded * ModuleManager.computeModularProperty(helmet, "Eating Energy Consumption");
            for (int i = 0; i < inv.k_() && (double)foodNeeded > foodLevel; ++i) {
                ur stack = inv.a(i);
                if (stack == null || !(stack.b() instanceof uk)) continue;
                uk food = (uk)stack.b();
                while (stack.a > 0 && (double)foodNeeded > foodLevel) {
                    foodLevel += (double)food.g() * efficiency / 100.0;
                    saturationLevel += (double)food.h() * efficiency / 100.0;
                    player.a("Feeder module: Ate a " + food.d(stack));
                    --stack.a;
                }
                if (stack.a != 0) continue;
                player.bJ.a(i, null);
            }
            int foodConsumed = (int)Math.min((double)foodNeeded, Math.min(foodLevel, eatingEnergyConsumption * (totalEnergy - totalEnergyDrain)));
            if (foodConsumed > 0) {
                if (saturationLevel >= 1.0) {
                    foodStats.a(foodConsumed, 1.0f);
                    saturationLevel -= 1.0;
                } else {
                    foodStats.a(foodConsumed, 0.0f);
                }
                foodLevel -= (double)foodConsumed;
                totalEnergyDrain += eatingEnergyConsumption * (double)foodConsumed;
            }
            MuseItemUtils.setFoodLevel(helmet, foodLevel);
            MuseItemUtils.setSaturationLevel(helmet, saturationLevel);
        }
        if (hasSolarGeneration) {
            boolean moonVisible;
            int xCoord = ke.c((double)player.t);
            int zCoord = ke.c((double)player.v);
            boolean isRaining = false;
            boolean canRain = true;
            if (world.F() % 20L == 0L) {
                canRain = world.t().a(xCoord, zCoord).g() > 0;
            }
            isRaining = canRain && (world.N() || world.M());
            boolean sunVisible = world.u() && !isRaining && world.k(xCoord, ke.c((double)player.u) + 1, zCoord);
            boolean bl = moonVisible = !world.u() && !isRaining && world.k(xCoord, ke.c((double)player.u) + 1, zCoord);
            if (!world.I && !world.u.f && world.F() % 80L == 0L) {
                if (sunVisible) {
                    ElectricItemUtils.givePlayerEnergy(player, ModuleManager.computeModularProperty(helmet, "Daytime Solar Energy Generation"));
                } else if (moonVisible) {
                    ElectricItemUtils.givePlayerEnergy(player, ModuleManager.computeModularProperty(helmet, "Nighttime Solar Energy Generation"));
                }
            }
        }
        if (hasKineticGeneration && !player.am) {
            double distance;
            boolean isNotWalking;
            bq tag = MuseItemUtils.getMuseItemTag(pants);
            boolean bl = isNotWalking = player.o != null || player.H();
            if (!tag.b("x") || isNotWalking) {
                tag.a("x", (int)player.t);
            }
            if (!tag.b("z") || isNotWalking) {
                tag.a("z", (int)player.v);
            }
            if ((distance = Math.sqrt((tag.e("x") - (int)player.t) * (tag.e("x") - (int)player.t) + (tag.e("z") - (int)player.v) * (tag.e("z") - (int)player.v))) >= 5.0) {
                tag.a("x", (int)player.t);
                tag.a("z", (int)player.v);
                ElectricItemUtils.givePlayerEnergy(player, ModuleManager.computeModularProperty(pants, "Energy Generation Per 5 Blocks"));
            }
        }
        if (totalEnergyDrain > 0.0) {
            ElectricItemUtils.drainPlayerEnergy(player, totalEnergyDrain);
        } else {
            ElectricItemUtils.givePlayerEnergy(player, -totalEnergyDrain);
        }
        player.cc().a((float)(-foodAdjustment));
        player.S = (float)MovementManager.computeFallHeightFromVelocity(MuseMathUtils.clampDouble(player.x, -1000.0, 0.0));
        if (totalWeight > weightCapacity) {
            player.w *= weightCapacity / totalWeight;
            player.y *= weightCapacity / totalWeight;
        }
    }

    public static double getWeightPenaltyRatio(double currentWeight, double capacity) {
        if (currentWeight < capacity) {
            return 1.0;
        }
        return capacity / currentWeight;
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        qx player = PlayerTickHandler.toPlayer(tickData[0]);
        List stacks = MuseItemUtils.getModularItemsInInventory((la)player.bJ);
    }

    public static yc toWorld(Object data) {
        yc world = null;
        try {
            world = (yc)data;
        }
        catch (ClassCastException e) {
            MuseLogger.logError("MMMPS: Player tick handler received invalid World object");
            e.printStackTrace();
        }
        return world;
    }

    public static qx toPlayer(Object data) {
        qx player = null;
        try {
            player = (qx)data;
        }
        catch (ClassCastException e) {
            MuseLogger.logError("MMMPS: Player tick handler received invalid Player object");
            e.printStackTrace();
        }
        return player;
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "MMMPS: Player Tick";
    }
}

