/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.redpower;

import codechicken.core.ReflectionManager;
import codechicken.core.asm.InterfaceDependancies;
import codechicken.wirelessredstone.core.IRedstoneEtherLoad;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.RedstoneEtherServer;
import codechicken.wirelessredstone.core.WRCoreClientPacketHandler;
import codechicken.wirelessredstone.core.WirelessRedstoneCore;
import codechicken.wirelessredstone.redpower.WirelessRedstoneRedPower;
import codechicken.wirelessredstone.redpower.weakDependancy_Control;
import com.eloraam.redpower.base.ItemScrewdriver;
import com.eloraam.redpower.core.IRedbusConnectable;
import com.eloraam.redpower.core.Packet211TileDesc;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.logic.TileLogic;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import java.io.IOException;

@InterfaceDependancies
public abstract class TileRPWireless
extends TileLogic
implements ITileWireless,
IRedstoneEtherLoad,
IRedbusConnectable,
IPeripheral {
    int rbaddr = 10;
    int currentfreq;
    int spinoffset;
    int WBuf;
    String owner;
    boolean newlyCreated = true;
    static boolean hasControl = ReflectionManager.classExists((String)"mod_RedPowerControl");

    public int getFreq() {
        return this.currentfreq;
    }

    public void setFreq(int newfreq) {
        if (this.k.I) {
            WRCoreClientPacketHandler.sendSetTileFreq((int)this.l, (int)this.m, (int)this.n, (int)newfreq);
        } else {
            this.currentfreq = newfreq;
            this.updateBlockChange();
        }
    }

    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.Deadmap = 0;
        this.Disabled = false;
        this.currentfreq = nbttagcompound.e("Freq");
        if (nbttagcompound.b("rbaddr")) {
            this.rbaddr = nbttagcompound.c("rbaddr") & 0xFF;
        }
        if (nbttagcompound.b("Owner")) {
            this.owner = nbttagcompound.i("Owner");
        }
    }

    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Freq", this.currentfreq);
        nbttagcompound.a("rbaddr", (byte)this.rbaddr);
        if (this.owner != null) {
            nbttagcompound.a("Owner", this.owner);
        }
    }

    public void onBlockPlaced(ur ist, int side, md ent) {
        if (ent instanceof qx) {
            this.owner = ((qx)ent).bR;
        }
        super.onBlockPlaced(ist, side, ent);
    }

    public void s() {
        super.s();
        if (!this.k.I) {
            RedstoneEtherServer.addToLoadList((yc)this.k, (int)this.l, (int)this.m, (int)this.n, (IRedstoneEtherLoad)this);
        }
    }

    public void onEtherLoad() {
        this.addToEther();
    }

    public void jamTile() {
        this.Disabled = true;
        this.Deadmap = this.k.t.nextInt(256);
        this.scheduleTick(3);
    }

    public void unjamTile() {
        if (this.Disabled) {
            this.Deadmap = this.k.t.nextInt(256);
            this.scheduleTick(3);
        }
        this.Disabled = false;
    }

    public void onTileTick() {
        this.Deadmap >>= 1;
        if (this.Deadmap != 0) {
            this.scheduleTick(3);
        }
        this.updateBlockChange();
    }

    public void onBlockNeighborChange(int i) {
        if (this.tryDropBlock()) {
            return;
        }
    }

    public void onChunkUnload() {
        if (!this.k.I) {
            this.removeFromEther();
        }
    }

    public void w_() {
        super.w_();
        this.newlyCreated = false;
        if (!this.k.I) {
            this.removeFromEther();
        }
    }

    public abstract void addToEther();

    public abstract void removeFromEther();

    public boolean onPartActivateSide(qx entityplayer, int i, int j) {
        ur held = entityplayer.bJ.g();
        if (entityplayer.ah() && !this.k.I && WirelessRedstoneRedPower.integrateControl && held != null && held.b() instanceof ItemScrewdriver) {
            weakDependancy_Control.useScrewdriver(entityplayer, this.k, this.l, this.m, this.n);
            return true;
        }
        if (held != null && held.b() instanceof ItemScrewdriver) {
            return true;
        }
        if (i == this.Rotation >> 2) {
            if (this.k.I) {
                WirelessRedstoneCore.proxy.openTileWirelessGui(entityplayer, (ITileWireless)this);
            }
            return true;
        }
        return false;
    }

    public int getPowerClass(int i) {
        return 0;
    }

    public int getBlockID() {
        return WirelessRedstoneRedPower.blockwireless.cm;
    }

    protected void readFromPacket(Packet211TileDesc packet211tiledesc) throws IOException {
        if (!this.k.I) {
            return;
        }
        super.readFromPacket(packet211tiledesc);
        this.currentfreq = (int)packet211tiledesc.getUVLC();
        this.updateBlockChange();
    }

    protected void writeToPacket(Packet211TileDesc packet211tiledesc) {
        super.writeToPacket(packet211tiledesc);
        packet211tiledesc.addUVLC((long)this.currentfreq);
    }

    public int rbGetAddr() {
        return this.rbaddr;
    }

    public void rbSetAddr(int i) {
        this.rbaddr = i;
    }

    public int rbRead(int i) {
        switch (i) {
            case 0: {
                return this.currentfreq & 0xFF;
            }
            case 1: {
                return this.currentfreq >> 8;
            }
        }
        return 0;
    }

    public void rbWrite(int i, int j) {
        switch (i) {
            case 2: {
                this.WBuf = j;
                break;
            }
            case 3: {
                this.WBuf |= j << 8;
                if (this.WBuf < 0 || this.WBuf > 5000) {
                    return;
                }
                if (!RedstoneEther.server().canBroadcastOnFrequency(this.owner, this.WBuf)) break;
                this.setFreq(this.WBuf);
            }
        }
    }

    public int getConnectClass(int i) {
        return (RedPowerLib.mapRotToCon((int)2, (int)this.Rotation) & RedPowerLib.getConDirMask((int)i)) <= 0 ? 66 : 0;
    }

    public void attach(IComputerAccess computer) {
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                if (arguments.length < 1) {
                    throw new Exception("Not Enough Arguments");
                }
                if (!(arguments[0] instanceof Double) || Math.floor((Double)arguments[0]) != (Double)arguments[0]) {
                    throw new Exception("Argument 0 is not a number");
                }
                int freq = ((Double)arguments[0]).intValue();
                if (freq < 0 || freq > 5000) {
                    throw new Exception("Invalid Frequency: " + freq);
                }
                if (!RedstoneEther.server().canBroadcastOnFrequency(this.owner, freq)) {
                    throw new Exception("Frequency: " + freq + " is private");
                }
                this.setFreq(freq);
                return null;
            }
            case 1: {
                return new Object[]{this.getFreq()};
            }
        }
        throw new Exception("derp?");
    }

    public boolean canAttachToSide(int side) {
        int pside = this.Rotation >> 2;
        return side != pside && side != (pside ^ 1);
    }

    public void detach(IComputerAccess computer) {
    }

    public String[] getMethodNames() {
        return new String[]{"setFreq", "getFreq"};
    }
}

