/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.extrabees;

import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import java.util.HashSet;
import net.bdew.neiaddons.extrabees.AddonExtraBees;
import net.bdew.neiaddons.extrabees.AlleleBeeChromosomePair;
import net.bdew.neiaddons.extrabees.IsolatorRecipeHandler;
import net.bdew.neiaddons.extrabees.SerumUtils;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.forestry.fake.FakeBeeRoot;

public class AddonExtraBeesClient {
    public static FakeBeeRoot beeRoot;

    public static void registerSerums() {
        HashSet<AlleleBeeChromosomePair> res = new HashSet<AlleleBeeChromosomePair>();
        beeRoot = new FakeBeeRoot();
        for (IAlleleBeeSpecies species : AddonExtraBees.allBeeSpecies) {
            IAllele[] template = beeRoot.getTemplate(species.getUID());
            if (template == null) {
                AddonExtraBees.instance.logWarning("Template for %s is null, wtf?", species.getUID());
                continue;
            }
            for (int i = 0; i < template.length; ++i) {
                if (template[i] == null) continue;
                if (!AddonExtraBees.loadBlacklisted && AlleleManager.alleleRegistry.isBlacklisted(template[i].getUID())) {
                    if (!AddonExtraBees.dumpSerums) continue;
                    AddonExtraBees.instance.logInfo("Skipping blacklisted allele: %s", template[i].getUID());
                    continue;
                }
                if (!SerumUtils.shouldMakeSerum(template[i].getUID(), i)) continue;
                res.add(new AlleleBeeChromosomePair(template[i], i));
            }
        }
        if (AddonExtraBees.dumpSerums) {
            AddonExtraBees.instance.logInfo("==== Serum dump ====", new Object[0]);
            for (EnumBeeChromosome chromosome : EnumBeeChromosome.values()) {
                AddonExtraBees.instance.logInfo("%s:", chromosome.toString());
                for (AlleleBeeChromosomePair pair : res) {
                    if (pair.chromosome != chromosome.ordinal()) continue;
                    AlleleManager.alleleRegistry.getAllele(pair.allele);
                    AddonExtraBees.instance.logInfo(" * %s -> %s", pair.allele, SerumUtils.getSerum(pair).r());
                }
                AddonExtraBees.instance.logInfo("===================================", new Object[0]);
            }
        }
        for (AlleleBeeChromosomePair pair : res) {
            API.addNBTItem((ur)SerumUtils.getSerum(pair));
        }
    }

    public static void load() {
        try {
            SerumUtils.setup();
        }
        catch (Throwable e) {
            AddonExtraBees.instance.logWarning("Failed to get serum item:", new Object[0]);
            e.printStackTrace();
            return;
        }
        AddonExtraBees.allBeeSpecies = GeneticsUtils.getAllBeeSpecies(AddonExtraBees.loadBlacklisted);
        AddonExtraBeesClient.registerSerums();
        API.registerRecipeHandler((ICraftingHandler)new IsolatorRecipeHandler());
        FMLInterModComms.sendRuntimeMessage((Object)AddonExtraBees.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)"Exta Bees@Isolator@isolator");
    }
}

