/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.core.ServerUtils;
import codechicken.core.vec.BlockCoord;
import codechicken.core.vec.Vector3;
import codechicken.wirelessredstone.addons.EntityREP;
import codechicken.wirelessredstone.addons.EntityWirelessTracker;
import codechicken.wirelessredstone.addons.ItemWirelessMap;
import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.Remote;
import codechicken.wirelessredstone.addons.Sniffer;
import codechicken.wirelessredstone.addons.WRAddonServerPacketHandler;
import codechicken.wirelessredstone.addons.WirelessMapNodeStorage;
import codechicken.wirelessredstone.addons.WirelessRedstoneAddons;
import codechicken.wirelessredstone.core.FreqChunkPosition;
import codechicken.wirelessredstone.core.FreqCoord;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessReceivingDevice;
import codechicken.wirelessredstone.core.WirelessTransmittingDevice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RedstoneEtherServerAddons
extends RedstoneEtherAddons {
    private HashMap playerInfos = new HashMap();
    private HashMap trackerPlayerMap = new HashMap();
    private HashSet playerTrackers = new HashSet();
    int trackerTicks = 0;

    public void setTriangRequired(qx player, int freq, boolean required) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (required) {
            info.triangSet.add(freq);
        } else {
            info.triangSet.remove(freq);
        }
    }

    private RedstoneEtherAddons.AddonPlayerInfo getPlayerInfo(qx player) {
        return (RedstoneEtherAddons.AddonPlayerInfo)this.playerInfos.get(player.bR);
    }

    @Override
    public boolean isRemoteOn(qx player, int freq) {
        Remote currentremote = this.getPlayerInfo((qx)player).remote;
        return currentremote == null ? false : currentremote.getFreq() == freq;
    }

    public int getRemoteFreq(qx player) {
        Remote currentremote = this.getPlayerInfo((qx)player).remote;
        if (currentremote == null) {
            return 0;
        }
        return currentremote.getFreq();
    }

    @Override
    public void activateRemote(yc world, qx player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.remote != null) {
            if (info.remote.isBeingHeld()) {
                return;
            }
            this.deactivateRemote(world, player);
        }
        if (RedstoneEther.server().isPlayerJammed(player)) {
            return;
        }
        info.remote = new Remote(player);
        info.remote.metaOn();
        RedstoneEther.server().addTransmittingDevice((WirelessTransmittingDevice)info.remote);
    }

    @Override
    public boolean deactivateRemote(yc world, qx player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.remote == null) {
            return false;
        }
        info.remote.metaOff();
        RedstoneEther.server().removeTransmittingDevice((WirelessTransmittingDevice)info.remote);
        info.remote = null;
        return true;
    }

    public void addSniffer(qx player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.sniffer != null) {
            this.remSniffer(player);
        }
        info.sniffer = new Sniffer(player);
        RedstoneEther.server().addReceivingDevice((WirelessReceivingDevice)info.sniffer);
        byte[] ethercopy = new byte[625];
        int freq = 1;
        while (freq <= 5000) {
            int arrayindex = freq - 1 >> 3;
            int bit = freq - 1 & 7;
            if (RedstoneEther.server().isFreqOn(freq)) {
                int n = arrayindex;
                ethercopy[n] = (byte)(ethercopy[n] | 1 << bit);
            }
            ++freq;
        }
        WRAddonServerPacketHandler.sendEtherCopyTo(player, ethercopy);
    }

    public void remSniffer(qx player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.sniffer == null) {
            return;
        }
        RedstoneEther.server().removeReceivingDevice((WirelessReceivingDevice)info.sniffer);
        info.sniffer = null;
    }

    public void processSMPMaps(yc world) {
        RedstoneEther.loadServerWorld((yc)world);
        int dimension = ServerUtils.getDimension((yc)world);
        ArrayList players = ServerUtils.getPlayersInDimension((int)dimension);
        Map txnodes = RedstoneEther.server().getTransmittersInDimension(dimension);
        Set devices = RedstoneEther.server().getTransmittingDevicesInDimension(dimension);
        for (qx player : players) {
            ur helditem = player.bS();
            if (helditem == null || helditem.b() != WirelessRedstoneAddons.wirelessMap || RedstoneEther.server().isPlayerJammed(player)) continue;
            ItemWirelessMap map = (ItemWirelessMap)helditem.b();
            ahn mapdata = map.a(helditem, world);
            if (mapdata.c != player.aq) continue;
            WirelessMapNodeStorage mapnodes = this.getMapNodes(player);
            TreeSet oldnodes = mapnodes.nodes;
            int lastdevices = mapnodes.devices.size();
            this.updatePlayerMapData(player, world, mapdata, txnodes, devices);
            TreeSet addednodes = new TreeSet(mapnodes.nodes);
            TreeSet<FreqChunkPosition> removednodes = new TreeSet<FreqChunkPosition>();
            if (oldnodes.size() != 0) {
                for (FreqChunkPosition node : oldnodes) {
                    if (addednodes.remove(node)) continue;
                    removednodes.add(node);
                }
            }
            if (addednodes.size() == 0 && removednodes.size() == 0 && devices.size() == 0 && lastdevices <= 0) continue;
            WRAddonServerPacketHandler.sendMapUpdatePacketTo(player, helditem.j(), mapdata, addednodes, removednodes, mapnodes.devices);
        }
    }

    private void updatePlayerMapData(qx player, yc world, ahn mapdata, Map txnodes, Set devices) {
        TreeSet<FreqChunkPosition> mnodes = new TreeSet<FreqChunkPosition>();
        TreeSet<FreqCoord> mdevices = new TreeSet<FreqCoord>();
        int blockwidth = 1 << mapdata.d;
        int minx = mapdata.a - blockwidth * 64;
        int minz = mapdata.b - blockwidth * 64;
        int maxx = mapdata.a + blockwidth * 64;
        int maxz = mapdata.b + blockwidth * 64;
        for (Map.Entry entry : txnodes.entrySet()) {
            BlockCoord node = (BlockCoord)entry.getKey();
            RedstoneEther.TXNodeInfo info = (RedstoneEther.TXNodeInfo)entry.getValue();
            if (!info.on || node.x <= minx || node.x >= maxx || node.z <= minz || node.z >= maxz || !RedstoneEther.server().canBroadcastOnFrequency(player, info.freq)) continue;
            mnodes.add(new FreqChunkPosition(node.x - mapdata.a, node.y, node.z - mapdata.b, info.freq));
        }
        for (WirelessTransmittingDevice device : devices) {
            Vector3 pos = device.getPosition();
            if (!(pos.x > (double)minx) || !(pos.x < (double)maxx) || !(pos.z > (double)minz) || !(pos.z < (double)maxz) || !RedstoneEther.server().canBroadcastOnFrequency(player, device.getFreq())) continue;
            mdevices.add(new FreqCoord(pos.x, pos.y, pos.z, device.getFreq()));
        }
        WirelessMapNodeStorage mapnodes = this.getMapNodes(player);
        mapnodes.nodes = mnodes;
        mapnodes.devices = mdevices;
    }

    public void onLogin(qx player) {
        this.playerInfos.put(player.bR, new RedstoneEtherAddons.AddonPlayerInfo());
    }

    public void onLogout(qx player) {
        this.playerInfos.remove(player.bR);
    }

    public void onDimensionChange(qx player) {
        this.deactivateRemote(player.p, player);
        this.remSniffer(player);
        this.playerInfos.put(player.bR, new RedstoneEtherAddons.AddonPlayerInfo());
        Iterator iterator = this.playerTrackers.iterator();
        while (iterator.hasNext()) {
            EntityWirelessTracker tracker = (EntityWirelessTracker)((Object)iterator.next());
            if (!tracker.attachedPlayerName.equals(player.bR)) continue;
            tracker.copyToDimension(player.aq);
            iterator.remove();
        }
    }

    public WirelessMapNodeStorage getMapNodes(qx player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        return info.mapNodes;
    }

    public void updateSMPMapInfo(yc world, qx player, ahn mapdata, int mapno) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (!info.mapInfoSet.contains(mapno)) {
            WRAddonServerPacketHandler.sendMapInfoTo(player, mapno, mapdata);
            info.mapInfoSet.add(mapno);
        }
    }

    public void clearMapNodes(qx player) {
        this.getPlayerInfo((qx)player).mapNodes.clear();
    }

    public void tickTriangs() {
        for (Map.Entry entry : this.playerInfos.entrySet()) {
            iq player = ServerUtils.getPlayer((String)((String)entry.getKey()));
            for (Integer freq : ((RedstoneEtherAddons.AddonPlayerInfo)entry.getValue()).triangSet) {
                Vector3 strengthvec;
                double spinto = !RedstoneEther.server().isFreqOn(freq.intValue()) ? -1.0 : (this.isRemoteOn((qx)player, freq) ? -2.0 : ((strengthvec = this.getBroadcastVector((qx)player, freq)) == null ? -2.0 : (double)(player.z + 180.0f) * Math.PI / 180.0 - Math.atan2(-strengthvec.x, strengthvec.z)));
                WRAddonServerPacketHandler.sendTriangAngleTo((qx)player, freq, (float)spinto);
            }
        }
    }

    public Vector3 getBroadcastVector(qx player, int freq) {
        double distancePow2;
        Vector3 vecTransmitter;
        Vector3 vecAmplitude = new Vector3(0.0, 0.0, 0.0);
        Vector3 vecPlayer = new Vector3(player.t, 0.0, player.v);
        for (FreqChunkPosition node : RedstoneEther.server().getActiveTransmittersOnFreq(freq, player.aq)) {
            vecTransmitter = new Vector3((double)node.x + 0.5, 0.0, (double)node.z + 0.5);
            distancePow2 = vecTransmitter.subtract(vecPlayer).magSquared();
            vecAmplitude.add(vecTransmitter.multiply(1.0 / distancePow2));
        }
        for (WirelessTransmittingDevice device : RedstoneEther.server().getTransmittingDevicesOnFreq(freq)) {
            if (device.getAttachedEntity() == player) {
                return null;
            }
            if (device.getDimension() != player.aq) continue;
            vecTransmitter = device.getPosition();
            vecTransmitter.y = 0.0;
            distancePow2 = vecTransmitter.subtract(vecPlayer).magSquared();
            vecAmplitude.add(vecTransmitter.multiply(1.0 / distancePow2));
        }
        if (vecAmplitude.isZero()) {
            return null;
        }
        return vecAmplitude;
    }

    public void addTracker(EntityWirelessTracker tracker) {
        this.trackerPlayerMap.put(tracker, new HashSet());
        if (tracker.attachedPlayerName != null) {
            this.playerTrackers.add(tracker);
        }
    }

    public void removeTracker(EntityWirelessTracker tracker) {
        HashSet trackedPlayers = (HashSet)this.trackerPlayerMap.get((Object)tracker);
        if (trackedPlayers != null) {
            for (iq player : trackedPlayers) {
                WRAddonServerPacketHandler.sendRemoveTrackerTo(player, tracker);
            }
        }
        this.trackerPlayerMap.remove((Object)tracker);
        if (!tracker.attachedInOtherDimension()) {
            this.playerTrackers.remove((Object)tracker);
        }
    }

    public void updateTracker(EntityWirelessTracker tracker) {
        HashSet trackedPlayers = (HashSet)this.trackerPlayerMap.get((Object)tracker);
        if (trackedPlayers == null) {
            trackedPlayers = new HashSet();
            this.trackerPlayerMap.put(tracker, trackedPlayers);
        }
        for (iq player : trackedPlayers) {
            WRAddonServerPacketHandler.sendTrackerUpdatePacketTo(player, tracker);
        }
        if (tracker.attachedPlayerName != null) {
            this.playerTrackers.add(tracker);
        } else {
            this.playerTrackers.remove((Object)tracker);
        }
    }

    public void processTrackers() {
        ++this.trackerTicks;
        HashSet playerEntities = new HashSet(ServerUtils.getAllPlayers());
        boolean updateFree = this.trackerTicks % 5 == 0;
        boolean updateAttached = this.trackerTicks % 100 == 0;
        Iterator iterator = this.trackerPlayerMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            HashSet trackedPlayers = (HashSet)entry.getValue();
            HashSet<iq> playersToTrack = new HashSet<iq>();
            EntityWirelessTracker tracker = (EntityWirelessTracker)((Object)entry.getKey());
            xv chunk = new xv(tracker.ai, tracker.ak);
            for (qx entityPlayer : playerEntities) {
                iq player = (iq)entityPlayer;
                if (tracker.L) {
                    WRAddonServerPacketHandler.sendRemoveTrackerTo(player, tracker);
                    continue;
                }
                if (tracker.getDimension() == player.aq && !player.f.contains(chunk) && !tracker.attachedToLogout()) {
                    playersToTrack.add(player);
                    if (trackedPlayers.contains(player) && (!tracker.isAttachedToEntity() || !updateAttached) && (tracker.isAttachedToEntity() || !updateFree)) continue;
                    WRAddonServerPacketHandler.sendTrackerUpdatePacketTo(player, tracker);
                    continue;
                }
                if (!trackedPlayers.contains(player)) continue;
                WRAddonServerPacketHandler.sendRemoveTrackerTo(player, tracker);
            }
            if (tracker.L) {
                iterator.remove();
                continue;
            }
            trackedPlayers.clear();
            trackedPlayers.addAll(playersToTrack);
        }
    }

    public boolean detonateREP(qx player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.activeREP == null) {
            return false;
        }
        if (info.activeREP.L) {
            info.activeREP = null;
            return false;
        }
        info.activeREP.detonate();
        info.activeREP.x();
        return true;
    }

    @Override
    public void invalidateREP(qx player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info != null) {
            info.activeREP = null;
        }
    }

    public void updateREPTimeouts() {
        for (Map.Entry entry : this.playerInfos.entrySet()) {
            RedstoneEtherAddons.AddonPlayerInfo info = (RedstoneEtherAddons.AddonPlayerInfo)entry.getValue();
            if (info.REPThrowTimeout <= 0) continue;
            --info.REPThrowTimeout;
        }
    }

    public void throwREP(ur itemstack, yc world, qx player) {
        RedstoneEtherAddons.AddonPlayerInfo info = this.getPlayerInfo(player);
        if (info.REPThrowTimeout > 0) {
            return;
        }
        if (!player.cd.d) {
            --itemstack.a;
        }
        EntityREP activeREP = new EntityREP(world, (md)player);
        world.d((lq)activeREP);
        WRAddonServerPacketHandler.sendSpawnREP(activeREP);
        world.a((lq)player, "random.bow", 0.5f, 0.4f / (world.t.nextFloat() * 0.4f + 0.8f));
        info.activeREP = activeREP;
        info.REPThrowTimeout = 40;
    }
}

