/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.lwjgl.opengl.GL11;

public class CustomSky {
    private static CustomSkyLayer[][] worldSkyLayers = null;

    public static void update(bba re2) {
        worldSkyLayers = null;
        if (!Config.isCustomSky()) {
            return;
        }
        worldSkyLayers = CustomSky.readCustomSkies(re2);
    }

    private static CustomSkyLayer[][] readCustomSkies(bba re2) {
        CustomSkyLayer[][] wsls = new CustomSkyLayer[10][0];
        String prefix = "/terrain/sky";
        int lastWorldId = -1;
        for (int w2 = 0; w2 < wsls.length; ++w2) {
            String worldPrefix = prefix + w2 + "/sky";
            ArrayList<CustomSkyLayer> listSkyLayers = new ArrayList<CustomSkyLayer>();
            for (int i2 = 1; i2 < 1000; ++i2) {
                String path = worldPrefix + i2 + ".properties";
                InputStream in2 = re2.k.e().a(path);
                if (in2 == null) break;
                try {
                    Properties props = new Properties();
                    props.load(in2);
                    Config.dbg("CustomSky properties: " + path);
                    String defSource = worldPrefix + i2 + ".png";
                    CustomSkyLayer sl2 = new CustomSkyLayer(props, defSource);
                    if (!sl2.isValid(path)) continue;
                    sl2.textureId = re2.b(sl2.source);
                    listSkyLayers.add(sl2);
                    in2.close();
                    continue;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            if (listSkyLayers.size() <= 0) continue;
            CustomSkyLayer[] sls = listSkyLayers.toArray(new CustomSkyLayer[listSkyLayers.size()]);
            wsls[w2] = sls;
            lastWorldId = w2;
        }
        if (lastWorldId < 0) {
            return null;
        }
        int worldCount = lastWorldId + 1;
        CustomSkyLayer[][] wslsTrim = new CustomSkyLayer[worldCount][0];
        for (int i3 = 0; i3 < wslsTrim.length; ++i3) {
            wslsTrim[i3] = wsls[i3];
        }
        return wslsTrim;
    }

    public static void renderSky(yc world, bba re2, float celestialAngle, float rainBrightness) {
        if (worldSkyLayers == null) {
            return;
        }
        if (Config.getGameSettings().ofRenderDistanceFine < 128) {
            return;
        }
        int dimId = world.u.h;
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return;
        }
        long time = world.G();
        int timeOfDay = (int)(time % 24000L);
        for (int i2 = 0; i2 < sls.length; ++i2) {
            CustomSkyLayer sl2 = sls[i2];
            if (!sl2.isActive(timeOfDay)) continue;
            sl2.render(timeOfDay, re2, celestialAngle, rainBrightness);
        }
        CustomSky.clearBlend(rainBrightness);
    }

    public static boolean hasSkyLayers(yc world) {
        if (worldSkyLayers == null) {
            return false;
        }
        if (Config.getGameSettings().ofRenderDistanceFine < 128) {
            return false;
        }
        int dimId = world.u.h;
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return false;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return false;
        }
        return sls.length > 0;
    }

    private static void clearBlend(float rainBrightness) {
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)rainBrightness);
    }
}

